/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.logic;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Sequential;

public class TryCatchTask
extends Task {
    private Sequential tryTasks = null;
    private Sequential catchTasks = null;
    private Sequential finallyTasks = null;
    private String property = null;
    private String reference = null;

    public void addTry(Sequential seq) throws BuildException {
        if (this.tryTasks != null) {
            throw new BuildException("You must not specify more than one <try>");
        }
        this.tryTasks = seq;
    }

    public void addCatch(Sequential seq) throws BuildException {
        if (this.catchTasks != null) {
            throw new BuildException("You must not specify more than one <catch>");
        }
        this.catchTasks = seq;
    }

    public void addFinally(Sequential seq) throws BuildException {
        if (this.finallyTasks != null) {
            throw new BuildException("You must not specify more than one <finally>");
        }
        this.finallyTasks = seq;
    }

    public void setProperty(String p) {
        this.property = p;
    }

    public void setReference(String r) {
        this.reference = r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        if (this.tryTasks == null) {
            throw new BuildException("A nested <try> element is required");
        }
        try {
            try {
                this.tryTasks.perform();
            }
            catch (BuildException e) {
                if (this.property != null) {
                    ((ProjectComponent)this).project.setProperty(this.property, e.getMessage());
                }
                if (this.reference != null) {
                    ((ProjectComponent)this).project.addReference(this.reference, (Object)e);
                }
                if (this.catchTasks == null) {
                    throw e;
                }
                this.log("Caught exception: " + e.getMessage(), 2);
                this.catchTasks.perform();
                Object var3_2 = null;
                if (this.finallyTasks == null) return;
                this.finallyTasks.perform();
                return;
            }
            Object var3_1 = null;
            if (this.finallyTasks == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.finallyTasks == null) throw throwable;
            this.finallyTasks.perform();
            throw throwable;
        }
        this.finallyTasks.perform();
    }
}

