/*
 * Decompiled with CFR 0.152.
 */
package de.ready.splitchainer;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.thoughtworks.xstream.XStream;
import de.ready.splitchainer.business.ComponentFactory;
import de.ready.splitchainer.business.Constants;
import de.ready.splitchainer.business.Dancer;
import de.ready.splitchainer.business.DancersSingleton;
import de.ready.splitchainer.business.DataContainer;
import de.ready.splitchainer.business.Definition;
import de.ready.splitchainer.business.Definitions;
import de.ready.splitchainer.business.Gender;
import de.ready.splitchainer.business.IdSingleton;
import de.ready.splitchainer.business.Level;
import de.ready.splitchainer.business.LicensedFunctions;
import de.ready.splitchainer.business.PreferLevel;
import de.ready.splitchainer.business.events.RotationEvent;
import de.ready.splitchainer.gui.BarcodeCreateDialog;
import de.ready.splitchainer.gui.DancerDialog;
import de.ready.splitchainer.gui.JDiagram;
import de.ready.splitchainer.gui.JHistogram;
import de.ready.splitchainer.gui.ListDancersDialog;
import de.ready.splitchainer.gui.RotateDialog;
import de.ready.splitchainer.interfaces.AfterDeuceListener;
import de.ready.splitchainer.interfaces.DisplayStringable;
import de.ready.splitchainer.license.SCLicenseParam;
import de.ready.splitchainer.util.DialogUtil;
import de.ready.splitchainer.util.ImagePathUtils;
import de.ready.splitchainer.util.Timer;
import de.ready.splitchainer.util.X500PrincipalHelper;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.ftp.LicenseManager;
import de.schlichtherle.license.ftp.LicenseParam;
import de.schlichtherle.license.wizard.LicenseWizard;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.PropertyConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitChainer
extends JFrame
implements ActionListener,
AfterDeuceListener,
DisplayStringable {
    private static final long serialVersionUID = 201201131550L;
    private static final String VERSION = "2.0";
    private ResourceBundle resources = ResourceBundle.getBundle(SplitChainer.class.getName());
    private final Logger logger = LoggerFactory.getLogger(SplitChainer.class);
    private final String panelName = "displayPanel";
    private File actualFile = null;
    private Level globalLevel = Level.BASIC;
    private final JMenuBar menuBar;
    private JLabel listingLabel;
    private Timer displayTimer = null;
    private JDialog popupDialog = null;
    private Definitions definitions = new Definitions();
    private int lastIndex = 0;
    private int displayCounter;
    private DataContainer dataContainer = null;
    private JMenu menuScanner = null;
    private JMenu menuRotate = null;
    private JMenu menuScreen = null;
    private LicenseParam useLicenseParam;
    private Timer nextDefinitionTimer;
    private Timer openTipTimer = null;
    private boolean licensed = false;
    private boolean preferSameLevelDancer = false;
    private JMenu menuSquares;
    private Image bImage;
    private LicensedFunctions licensedFunctions = new LicensedFunctions(0L);
    private String licensee = "Free Version, No Warranty";
    private Integer screenNumber2Use = 0;
    private int globalLicenseCounter = 0;
    private boolean overviewActive = false;
    long lastWhen = 0L;
    private StringBuilder code = new StringBuilder();
    Timer clearInputTimer = null;
    private Level lastLevel = null;

    private String getResource(String string) {
        return this.resources.getString(string);
    }

    private Integer getResourceInt(String string, Integer n) {
        try {
            return Integer.valueOf(this.resources.getString(string));
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    private String getResource(String string, Object object) {
        return MessageFormat.format(this.resources.getString(string), object);
    }

    private String getResource(String string, Object[] objectArray) {
        return MessageFormat.format(this.resources.getString(string), objectArray);
    }

    public SplitChainer() {
        Serializable serializable;
        int n = Integer.parseInt(System.getProperty("menuFontSize", "15"));
        Font font = new Font("Courier", 0, n);
        UIManager.put("MenuBar.font", font);
        UIManager.put("MenuItem.font", font);
        UIManager.put("Menu.font", font);
        PropertyConfigurator.configureAndWatch((String)"log4j.properties");
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            super.setDefaultCloseOperation(3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.error("Exception", (Throwable)classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            this.logger.error("Exception", (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.logger.error("Exception", (Throwable)illegalAccessException);
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            this.logger.error("Exception", (Throwable)unsupportedLookAndFeelException);
        }
        try {
            serializable = this.getClass().getResource("splitchainer.png");
            this.logger.trace("Resource is {}", (Object)serializable);
            if (((URL)serializable).toString().startsWith("jar:")) {
                File file = ImagePathUtils.convert((URL)serializable, "splitchainer.png");
                this.logger.trace("Trying to read {}", (Object)file);
                this.bImage = ImageIO.read(file);
            } else {
                this.bImage = ImageIO.read((URL)serializable);
            }
        }
        catch (Exception exception) {
            this.logger.error("splitchainer.png", (Throwable)exception);
        }
        this.setIconImage(this.bImage);
        this.useLicenseParam = new SCLicenseParam();
        this.checkLicense(this, false);
        this.dataContainer = new DataContainer(this);
        DancersSingleton.getInstance(this.dataContainer);
        if (this.licensed) {
            this.globalLevel = this.dataContainer.defaultLevelAtStartup;
        }
        serializable = new JPanel(new BorderLayout());
        ((JComponent)serializable).setBackground(Color.gray);
        this.setContentPane((Container)serializable);
        this.menuBar = new JMenuBar();
        ((Container)serializable).add(this.menuBar, "North");
        this.menuBar.add(this.buildMenuFile());
        this.menuBar.add(this.buildMenuDancer());
        this.buildMenueScreen(this.menuBar);
        this.menuBar.add(this.buildMenuRotate());
        this.buildMenuStatistics(this.menuBar);
        this.menuBar.add(this.buildScannerInput());
        this.menuBar.add(this.buildMenuHelp());
        this.menuBar.add(this.buildMenuSquares());
        this.setTitleLine("");
        this.switchToInputMode();
    }

    private void startDisplayLoop() {
        if (this.displayTimer == null) {
            this.displayTimer = new Timer(this.dataContainer.displayTime, this);
            this.displayTimer.setActionCommand("timer");
            this.displayTimer.setRepeats(true);
        }
        this.displayTimer.start();
    }

    private void stopDisplayLoop() {
        if (this.displayTimer != null) {
            this.displayTimer.stop();
        }
        this.logger.trace("displayTimer stop");
    }

    private void stopDefinitionLoop() {
        this.nextDefinitionTimer.stop();
        this.logger.trace("definitionLoop stop");
    }

    private void startDefinitionLoop() {
        if (this.nextDefinitionTimer == null) {
            this.nextDefinitionTimer = new Timer(60000, this);
            this.nextDefinitionTimer.setActionCommand("nextDefinition");
            this.nextDefinitionTimer.setRepeats(true);
        }
        this.nextDefinitionTimer.start();
        this.pack();
    }

    private void switchToInputMode() {
        this.enableRotate();
        Container container = this.removeOldScreen();
        Dimension dimension = this.getScreenSize();
        this.logger.info("Screen height=" + dimension.height);
        Font font = new Font("Courier", 1, dimension.height / 40);
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("20px, c:" + (dimension.width - 40) + "px:grow, 20px", "" + (dimension.height / 5 - 40) + "px, pref, 40px, " + 4 * dimension.height / 5 + "px:grow"));
        panelBuilder.nextColumn();
        panelBuilder.nextRow();
        JLabel jLabel = new JLabel("<html>" + this.getResource("SplitChainer.welcomePanel.text", this.licensee.replace("\n", "<br/>") + "</html>"));
        jLabel.setFont(font);
        panelBuilder.add((Component)jLabel);
        panelBuilder.nextRow();
        panelBuilder.nextRow();
        Font font2 = new Font("Courier", 0, dimension.height / 80);
        StringBuilder stringBuilder = new StringBuilder("<html>");
        if (this.dataContainer.displayDefinitions.booleanValue()) {
            Definition definition = this.definitions.getDefinition(this.globalLevel);
            String string = String.format("%02x%02x%02x", this.dataContainer.definitionHighlightColor.getRed(), this.dataContainer.definitionHighlightColor.getGreen(), this.dataContainer.definitionHighlightColor.getBlue());
            String string2 = String.format("%02x%02x%02x", this.dataContainer.definitionNormallightColor.getRed(), this.dataContainer.definitionNormallightColor.getGreen(), this.dataContainer.definitionNormallightColor.getBlue());
            stringBuilder.append("<font color=#").append(string).append(" size=+2>").append(definition.getLevel().getName()).append(":</font> ");
            stringBuilder.append("<font color=#").append(string).append(" size=+2><b>").append(definition.getName()).append("</b></font> ");
            if (definition.getTiming().length() > 0) {
                stringBuilder.append("<font color=#").append(string).append(">Timing:</font> ");
                stringBuilder.append("<font color=#").append(string2).append(">").append(definition.getTiming()).append("</font>");
            }
            if (definition.getStartingFormation().length() > 0) {
                stringBuilder.append("<br/><br/><font color=#").append(string).append(">Starting formation:</font> ");
                stringBuilder.append("<font color=#").append(string2).append(">").append(definition.getStartingFormation()).append("</font> ");
            }
            if (this.licensed) {
                stringBuilder.append("<br/><br/><font color=#").append(string2).append(">").append(definition.getDefinition()).append("</font>");
                if (definition.getEndingFormation().length() > 0) {
                    stringBuilder.append("<br/><br/><font color=#").append(string).append(">Ending formation:</font> ");
                    stringBuilder.append("<font color=#").append(string2).append(">").append(definition.getEndingFormation()).append("</font>");
                }
                if (definition.getStyling().length() > 0) {
                    stringBuilder.append("<br/><br/><font color=#").append(string).append(">Styling:</font> ");
                    stringBuilder.append("<font color=#").append(string2).append(">").append(definition.getStyling()).append("</font>");
                }
                if (definition.getComment().length() > 0) {
                    stringBuilder.append("<br/><br/><font color=#").append(string).append(">Comment:</font> ");
                    stringBuilder.append("<font color=#").append(string2).append(">").append(definition.getComment()).append("</font>");
                }
            } else {
                stringBuilder.append("<br/><br/><font color=#").append(string2).append(">Licensed version would show complete definition</font>");
            }
            stringBuilder.append("<br/><br/><font color=#").append(string).append("><em>\u00a9 Copyright 1982, 1986-1988, 1995, 2001-2014. Bill Davis, John Sybalsky, and CALLERLAB Inc., The International Association of Square Dance Callers. Permission to reprint, republish, and create derivative works without royalty is hereby granted, provided this notice appears. Publication on the Internet of derivative works without royalty is hereby granted provided this notice appears. Permission to quote parts or all of this document without royalty is hereby granted, provided this notice is included. Information contained herein shall not be changed nor revised in any derivation or publication.</em></font>");
            stringBuilder.append("</html>");
        }
        this.listingLabel = new JLabel(stringBuilder.toString());
        this.listingLabel.setFont(font2);
        panelBuilder.add((Component)this.listingLabel);
        panelBuilder.getPanel().setName("displayPanel");
        panelBuilder.getPanel().setBackground(this.dataContainer.dancerPanelBackgroundColor);
        container.add(panelBuilder.getPanel());
        this.validate();
        this.repaint();
        this.lastIndex = 0;
    }

    private synchronized void setPopupInvisible() {
        if (this.clearInputTimer != null) {
            this.clearInputTimer.stop();
        }
        if (this.popupDialog != null) {
            this.popupDialog.setVisible(false);
            this.popupDialog = null;
        }
    }

    @Override
    public void setDisplayString(String string) {
        Object object;
        this.setPopupInvisible();
        Font font = new Font("Courier", 2, this.dataContainer.fontSize * 2);
        Color color = this.dataContainer.popupColor;
        String string2 = new String(string);
        if (string2.length() > 7 && string2.substring(0, 7).matches("#[0-9A-F]{6}")) {
            object = string2.substring(0, 7);
            color = Color.decode((String)object);
            string2 = string2.substring(7);
        }
        object = ((Graphics2D)this.getGraphics()).getFontRenderContext();
        String string3 = "<html>" + string2.replaceAll("\n", "<br>") + "</html>";
        PanelBuilder panelBuilder = string2.split("\n");
        double d = 0.0;
        double d2 = 0.0;
        for (String string4 : panelBuilder) {
            Rectangle2D rectangle2D = font.getStringBounds(string4, (FontRenderContext)object);
            d = Math.max(d, Math.ceil(rectangle2D.getWidth()));
            d2 = Math.max(d2, Math.ceil(rectangle2D.getHeight()));
        }
        PanelBuilder panelBuilder2 = new PanelBuilder(new FormLayout("c:" + Math.ceil(d) + "px", "" + Math.ceil(d2 *= (double)((String[])panelBuilder).length) + "px"));
        panelBuilder2.getPanel().setBackground(color);
        JLabel jLabel = new JLabel(string3);
        jLabel.setFont(font);
        jLabel.setBackground(color);
        jLabel.setHorizontalTextPosition(0);
        panelBuilder2.add((Component)jLabel);
        this.popupDialog = new JDialog(this);
        this.popupDialog.setUndecorated(true);
        this.popupDialog.setContentPane(panelBuilder2.getPanel());
        this.popupDialog.pack();
        this.popupDialog.setLocationRelativeTo(this);
        this.popupDialog.setVisible(true);
        DialogUtil.setupActions(this.popupDialog, this.menuBar);
        this.clearInputTimer = new Timer(this.dataContainer.popupTime * ((PanelBuilder)panelBuilder).length, this);
        this.clearInputTimer.setRepeats(false);
        this.clearInputTimer.setActionCommand("clearInput");
        this.clearInputTimer.start();
    }

    public void showMe() {
        this.setVisible(true);
    }

    private void setTitleLine(String string) {
        String string2 = "SplitChainer V2.0 (Release " + this.getResource("SplitChainer.hgbuild.release") + " from " + this.getResource("SplitChainer.hgbuild.date") + ")";
        if (this.actualFile != null) {
            string2 = string2 + " " + this.actualFile.getName();
        }
        if (string != null && string.length() > 0) {
            string2 = string2 + string;
        }
        this.setTitle(string2);
    }

    private JMenu buildMenuFile() {
        JMenu jMenu = new JMenu(this.getResource("SplitChainer.menu.file.text"));
        JMenuItem jMenuItem = new JMenuItem(this.getResource("SplitChainer.menu.file.open.text"));
        jMenuItem.setActionCommand("open");
        jMenuItem.addActionListener(this);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 128, true));
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(this.getResource("SplitChainer.menu.file.save.text"));
        jMenuItem2.setActionCommand("save");
        jMenuItem2.addActionListener(this);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(83, 128, true));
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(this.getResource("SplitChainer.menu.file.save_as.text"));
        jMenuItem3.setActionCommand("saveAs");
        jMenuItem3.addActionListener(this);
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(83, 192, true));
        jMenu.add(jMenuItem3);
        JSeparator jSeparator = new JSeparator();
        jMenu.add(jSeparator);
        JMenuItem jMenuItem4 = new JMenuItem(this.getResource("SplitChainer.menu.file.preferences.text"));
        jMenuItem4.setActionCommand("preferences");
        jMenuItem4.addActionListener(this);
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(80, 128, true));
        jMenu.add(jMenuItem4);
        JSeparator jSeparator2 = new JSeparator();
        jMenu.add(jSeparator2);
        JMenuItem jMenuItem5 = new JMenuItem(this.getResource("SplitChainer.menu.file.license.text"));
        jMenuItem5.setActionCommand("license");
        jMenuItem5.addActionListener(this);
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(73, 128));
        jMenu.add(jMenuItem5);
        JSeparator jSeparator3 = new JSeparator();
        jMenu.add(jSeparator3);
        JMenuItem jMenuItem6 = new JMenuItem(this.getResource("SplitChainer.menu.file.exit.text"));
        jMenuItem6.setActionCommand("exit");
        jMenuItem6.addActionListener(this);
        jMenuItem6.setAccelerator(KeyStroke.getKeyStroke(115, 512, true));
        jMenu.add(jMenuItem6);
        return jMenu;
    }

    private JMenu buildMenuDancer() {
        JMenu jMenu = new JMenu(this.getResource("SplitChainer.menu.dancer.text"));
        JMenuItem jMenuItem = new JMenuItem(this.getResource("SplitChainer.menu.dancer.new.text"));
        jMenuItem.setActionCommand("newDancer");
        jMenuItem.addActionListener(this);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 128, true));
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(this.getResource("SplitChainer.menu.dancer.list.text"));
        jMenuItem2.setActionCommand("listDancer");
        jMenuItem2.addActionListener(this);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(76, 128, true));
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(this.getResource("SplitChainer.menu.dancer.overview.text"));
        jMenuItem3.setActionCommand("overview");
        jMenuItem3.addActionListener(this);
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(86, 128, true));
        jMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem(this.getResource("SplitChainer.menu.dancer.present.text"));
        jMenuItem4.setActionCommand("present");
        jMenuItem4.addActionListener(this);
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(86, 512, true));
        jMenu.add(jMenuItem4);
        return jMenu;
    }

    private JMenu buildMenuTip() {
        JMenu jMenu = new JMenu(this.getResource("SplitChainer.menu.tip.text"));
        JMenuItem jMenuItem = new JMenuItem(this.getResource("SplitChainer.menu.tip.new.text"));
        jMenuItem.setActionCommand("newTip");
        jMenuItem.addActionListener(this);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, 128, true));
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(this.getResource("SplitChainer.menu.tip.list.text"));
        jMenuItem2.setActionCommand("listTip");
        jMenuItem2.addActionListener(this);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(77, 128, true));
        jMenu.add(jMenuItem2);
        return jMenu;
    }

    private JMenu buildMenuRotate() {
        this.menuRotate = new JMenu(this.getResource("SplitChainer.menu.rotate.text"));
        JMenuItem jMenuItem = new JMenuItem(this.getResource("SplitChainer.menu.rotate.same.text"));
        jMenuItem.setActionCommand("rotate");
        jMenuItem.addActionListener(this);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 128, true));
        this.menuRotate.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(this.getResource("SplitChainer.menu.rotate.other.text"));
        jMenuItem2.setActionCommand("srotate");
        jMenuItem2.addActionListener(this);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(82, 512, true));
        this.menuRotate.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(this.getResource("SplitChainer.menu.rotate.opentip.text"));
        jMenuItem3.setActionCommand("openTip");
        jMenuItem3.addActionListener(this);
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(84, 512, true));
        this.menuRotate.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem(this.getResource("SplitChainer.menu.rotate.start_display.text"));
        jMenuItem4.setActionCommand("startDisplay");
        jMenuItem4.addActionListener(this);
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(68, 128, true));
        this.menuRotate.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem(this.getResource("SplitChainer.menu.rotate.stop_display.text"));
        jMenuItem5.setActionCommand("stopDisplay");
        jMenuItem5.addActionListener(this);
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(68, 512, true));
        this.menuRotate.add(jMenuItem5);
        return this.menuRotate;
    }

    private void buildMenuStatistics(JMenuBar jMenuBar) {
        JMenuItem jMenuItem;
        JMenu jMenu = new JMenu(this.getResource("SplitChainer.menu.tools.text"));
        int n = 0;
        if (this.licensedFunctions.isHistogramLicensed().booleanValue()) {
            jMenuItem = new JMenuItem(this.getResource("SplitChainer.menu.tools.histogram.text"));
            jMenuItem.setActionCommand("histogram");
            jMenuItem.addActionListener(this);
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(72, 128, true));
            jMenu.add(jMenuItem);
            ++n;
        }
        if (this.licensedFunctions.isDiagramLicensed().booleanValue()) {
            jMenuItem = new JMenuItem(this.getResource("SplitChainer.menu.tools.diagram.text"));
            jMenuItem.setActionCommand("diagram");
            jMenuItem.addActionListener(this);
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(72, 512, true));
            jMenu.add(jMenuItem);
            ++n;
        }
        if (this.licensedFunctions.isPersonInSquareLicensed().booleanValue()) {
            jMenuItem = new JMenuItem(this.getResource("SplitChainer.menu.tools.personInSquare.text"));
            jMenuItem.setActionCommand("personInSquare");
            jMenuItem.addActionListener(this);
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 512, true));
            jMenu.add(jMenuItem);
            ++n;
        }
        if (this.licensedFunctions.isSquareToPersonLicensed().booleanValue()) {
            jMenuItem = new JMenuItem(this.getResource("SplitChainer.menu.tools.squareToPerson.text"));
            jMenuItem.setActionCommand("squareToPerson");
            jMenuItem.addActionListener(this);
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 640, true));
            jMenu.add(jMenuItem);
            ++n;
        }
        if (this.licensedFunctions.isBarcodeLicensed().booleanValue()) {
            jMenuItem = new JMenuItem(this.getResource("SplitChainer.menu.tools.barcode.text"));
            jMenuItem.setActionCommand("barcode");
            jMenuItem.addActionListener(this);
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, 128, true));
            jMenu.add(jMenuItem);
            ++n;
        }
        if (n != 0) {
            jMenuBar.add(jMenu);
        }
    }

    private int getEventNumber(int n) {
        return 49 + n;
    }

    private void buildMenueScreen(JMenuBar jMenuBar) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        if (graphicsDeviceArray.length == 1) {
            return;
        }
        this.menuScreen = new JMenu("Display");
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            int n = i + 1;
            JMenuItem jMenuItem = new JMenuItem("" + n + "  (" + graphicsDeviceArray[i].getDisplayMode().getWidth() + "x" + graphicsDeviceArray[i].getDisplayMode().getHeight() + ")");
            jMenuItem.setActionCommand("Screen" + n);
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(this.getEventNumber(i), 128, true));
            jMenuItem.addActionListener(this);
            this.menuScreen.add(jMenuItem);
        }
        jMenuBar.add(this.menuScreen);
    }

    private void buildMenuePDF(JMenuBar jMenuBar) {
    }

    private JMenu buildScannerInput() {
        this.menuScanner = new JMenu("Scanner");
        JMenuItem jMenuItem = new JMenuItem("0");
        jMenuItem.setActionCommand("Scanner0");
        jMenuItem.addActionListener(this);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(48, 0, true));
        this.menuScanner.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("1");
        jMenuItem2.setActionCommand("Scanner1");
        jMenuItem2.addActionListener(this);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(49, 0, true));
        this.menuScanner.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("2");
        jMenuItem3.setActionCommand("Scanner2");
        jMenuItem3.addActionListener(this);
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(50, 0, true));
        this.menuScanner.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("3");
        jMenuItem4.setActionCommand("Scanner3");
        jMenuItem4.addActionListener(this);
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(51, 0, true));
        this.menuScanner.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("4");
        jMenuItem5.setActionCommand("Scanner4");
        jMenuItem5.addActionListener(this);
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(52, 0, true));
        this.menuScanner.add(jMenuItem5);
        JMenuItem jMenuItem6 = new JMenuItem("5");
        jMenuItem6.setActionCommand("Scanner5");
        jMenuItem6.addActionListener(this);
        jMenuItem6.setAccelerator(KeyStroke.getKeyStroke(53, 0, true));
        this.menuScanner.add(jMenuItem6);
        JMenuItem jMenuItem7 = new JMenuItem("6");
        jMenuItem7.setActionCommand("Scanner6");
        jMenuItem7.addActionListener(this);
        jMenuItem7.setAccelerator(KeyStroke.getKeyStroke(54, 0, true));
        this.menuScanner.add(jMenuItem7);
        JMenuItem jMenuItem8 = new JMenuItem("7");
        jMenuItem8.setActionCommand("Scanner7");
        jMenuItem8.addActionListener(this);
        jMenuItem8.setAccelerator(KeyStroke.getKeyStroke(55, 0, true));
        this.menuScanner.add(jMenuItem8);
        JMenuItem jMenuItem9 = new JMenuItem("8");
        jMenuItem9.setActionCommand("Scanner8");
        jMenuItem9.addActionListener(this);
        jMenuItem9.setAccelerator(KeyStroke.getKeyStroke(56, 0, true));
        this.menuScanner.add(jMenuItem9);
        JMenuItem jMenuItem10 = new JMenuItem("9");
        jMenuItem10.setActionCommand("Scanner9");
        jMenuItem10.addActionListener(this);
        jMenuItem10.setAccelerator(KeyStroke.getKeyStroke(57, 0, true));
        this.menuScanner.add(jMenuItem10);
        JMenuItem jMenuItem11 = new JMenuItem("A");
        jMenuItem11.setActionCommand("ScannerA");
        jMenuItem11.addActionListener(this);
        jMenuItem11.setAccelerator(KeyStroke.getKeyStroke(65, 1, true));
        this.menuScanner.add(jMenuItem11);
        JMenuItem jMenuItem12 = new JMenuItem("B");
        jMenuItem12.setActionCommand("ScannerB");
        jMenuItem12.addActionListener(this);
        jMenuItem12.setAccelerator(KeyStroke.getKeyStroke(66, 1, true));
        this.menuScanner.add(jMenuItem12);
        JMenuItem jMenuItem13 = new JMenuItem("C");
        jMenuItem13.setActionCommand("ScannerC");
        jMenuItem13.addActionListener(this);
        jMenuItem13.setAccelerator(KeyStroke.getKeyStroke(67, 1, true));
        this.menuScanner.add(jMenuItem13);
        JMenuItem jMenuItem14 = new JMenuItem("D");
        jMenuItem14.setActionCommand("ScannerD");
        jMenuItem14.addActionListener(this);
        jMenuItem14.setAccelerator(KeyStroke.getKeyStroke(68, 1, true));
        this.menuScanner.add(jMenuItem14);
        JMenuItem jMenuItem15 = new JMenuItem("E");
        jMenuItem15.setActionCommand("ScannerE");
        jMenuItem15.addActionListener(this);
        jMenuItem15.setAccelerator(KeyStroke.getKeyStroke(69, 1, true));
        this.menuScanner.add(jMenuItem15);
        JMenuItem jMenuItem16 = new JMenuItem("F");
        jMenuItem16.setActionCommand("ScannerF");
        jMenuItem16.addActionListener(this);
        jMenuItem16.setAccelerator(KeyStroke.getKeyStroke(70, 1, true));
        this.menuScanner.add(jMenuItem16);
        return this.menuScanner;
    }

    private JMenu buildMenuHelp() {
        JMenu jMenu = new JMenu(this.getResource("SplitChainer.menu.help.text"));
        JMenuItem jMenuItem = new JMenuItem(this.getResource("SplitChainer.menu.help.about.text"));
        jMenuItem.setActionCommand("about");
        jMenuItem.addActionListener(this);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 128, true));
        jMenu.add(jMenuItem);
        return jMenu;
    }

    private JMenu buildMenuSquares() {
        this.menuSquares = new JMenu("0/0");
        return this.menuSquares;
    }

    private void moveToScreen() {
        Dimension dimension = this.getScreenSize();
        this.setSize(dimension.width, dimension.height);
        Dimension dimension2 = this.getOffset();
        this.setLocation(dimension2.width, dimension2.height);
    }

    public void init() {
        this.moveToScreen();
        this.setLocale(Locale.ENGLISH);
        DancersSingleton.getInstance().setAfterDeuceListener(this);
        this.startDefinitionLoop();
    }

    private String streamify(String string) {
        String string2 = string;
        string2 = string2.replaceAll("\r", "");
        string2 = string2.replaceAll("\n      ", "\n");
        string2 = string2.replaceAll("\n     ", "\n");
        string2 = string2.replaceAll("\n    ", "\n");
        string2 = string2.replaceAll("\n   ", "\n");
        string2 = string2.replaceAll("\n  ", "\n");
        string2 = string2.replaceAll("\n ", "\n");
        string2 = string2.replaceAll("\n", "");
        string2 = string2 + "\n";
        return string2;
    }

    private File askForNewFile(File file, boolean bl) {
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        File file2 = new File(preferences.get("lastExportFilename", System.getProperty("user.home")));
        File file3 = file;
        if (file == null) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setSelectedFile(file2);
            jFileChooser.setFileSelectionMode(0);
            int n = bl ? jFileChooser.showSaveDialog(this) : jFileChooser.showOpenDialog(this);
            if (n == 0) {
                file3 = jFileChooser.getSelectedFile();
                preferences.put("lastExportFilename", file3.getAbsolutePath());
            }
        }
        return file3;
    }

    private String cleanTemporary(String string) {
        String[] stringArray = new String[]{"present", "pauses", "available", "hasPaused", "squareNumberOrOUT", "partnerName", "willDance", "numSelected", "numParticipated", "wasOut", "history", "partnerHistory", "squareHistory", "actualGender", "lastGender", "displayName"};
        String string2 = string;
        for (String string3 : stringArray) {
            String string4 = "<" + string3 + ">.*</" + string3 + ">";
            string2 = string2.replaceAll(string4, "");
        }
        return string2;
    }

    private void doSave(File file) {
        File file2 = this.askForNewFile(file, true);
        if (file2 != null) {
            DancersSingleton.getInstance().setPresentFile(file2);
            this.actualFile = file2;
            this.setTitleLine("");
            DancersSingleton.getInstance().saveActual();
            if (this.licensed) {
                DancersSingleton.getInstance().savePresent();
            }
        }
    }

    private void doSave() {
        this.doSave(this.actualFile);
    }

    private void doSaveAs() {
        this.doSave(null);
    }

    private void checkForDoubleId(List<Dancer> list) {
        for (int i = 0; i < list.size(); ++i) {
            for (int j = i + 1; j < list.size(); ++j) {
                if (!list.get(i).equals(list.get(j))) continue;
                list.get(j).setId(IdSingleton.getInstance().nextVal());
                this.checkForDoubleId(list);
                return;
            }
        }
    }

    private void doOpen() {
        File file = this.askForNewFile(null, false);
        if (file != null) {
            this.actualFile = file;
            this.setTitleLine("");
            try {
                Object object;
                FileInputStream fileInputStream = new FileInputStream(file);
                char c = '-';
                StringBuilder stringBuilder = new StringBuilder();
                XStream xStream = new XStream();
                xStream.processAnnotations(Dancer.class);
                DancersSingleton.getInstance().clear();
                while ((c = (char)((char)fileInputStream.read())) != '\uffff') {
                    if (c != '\n') {
                        stringBuilder.append(c);
                        continue;
                    }
                    Object object2 = xStream.fromXML(stringBuilder.toString());
                    if (Long.class.isInstance(object2)) {
                        IdSingleton.getInstance((Long)Long.class.cast(object2));
                        stringBuilder.delete(0, stringBuilder.length());
                    }
                    if (!Dancer.class.isInstance(object2)) continue;
                    Dancer dancer = (Dancer)Dancer.class.cast(object2);
                    dancer.setPresent(Boolean.FALSE);
                    DancersSingleton.getInstance().add(dancer);
                    stringBuilder.delete(0, stringBuilder.length());
                }
                fileInputStream.close();
                int n = 0;
                for (Dancer objectArray : DancersSingleton.getInstance().getDancers()) {
                    ++n;
                    Dancer dancer = DancersSingleton.getInstance().findDancer(objectArray.getJoinedWith());
                    if (dancer == null) continue;
                    objectArray.setPartnerId(dancer.getId());
                    dancer.setPartnerId(objectArray.getId());
                    objectArray.setJoinedWith(null);
                    dancer.setJoinedWith(null);
                }
                this.checkForDoubleId(DancersSingleton.getInstance().getDancers());
                for (int i = 0; i < 2; ++i) {
                    for (Dancer dancer : DancersSingleton.getInstance().getDancers()) {
                        if (dancer.getPartnerId() == null) continue;
                        object = DancersSingleton.getInstance().findDancer(dancer.getPartnerId());
                        if (object != null && ((Dancer)object).getPartnerId() != null) {
                            if (((Dancer)object).getPartnerId().longValue() == dancer.getId().longValue()) continue;
                            dancer.setPartnerId(null);
                            dancer.setPartner(null);
                            continue;
                        }
                        dancer.setPartnerId(null);
                        dancer.setPartner(null);
                    }
                }
                DancersSingleton.getInstance().adjustDancerNames();
                if (this.licensed) {
                    File file2 = new File(file.getParent() + File.separator + "." + file.getName() + ".state");
                    if (file2.exists()) {
                        Object[] objectArray = new String[]{this.getResource("SplitChainer.popup.state_file.yes"), this.getResource("SplitChainer.popup.state_file.no")};
                        int n2 = JOptionPane.showOptionDialog(this, this.getResource("SplitChainer.popup.state_file.text"), this.getResource("SplitChainer.popup.state_file.title"), 0, 3, null, objectArray, objectArray[0]);
                        if (n2 == 0) {
                            fileInputStream = new FileInputStream(file2);
                            object = (Vector)xStream.fromXML((InputStream)fileInputStream);
                            fileInputStream.close();
                            Iterator iterator = ((Vector)object).iterator();
                            while (iterator.hasNext()) {
                                Dancer dancer = (Dancer)iterator.next();
                                DancersSingleton.getInstance().copyProperties(dancer);
                            }
                            this.adjustMenuSquares();
                        }
                    }
                    DancersSingleton.getInstance().setPresentFile(file);
                }
                this.setDisplayString(this.getResource("SplitChainer.file.loaded", n));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.logger.error("Error", (Throwable)fileNotFoundException);
                JOptionPane.showMessageDialog(this, fileNotFoundException.getMessage(), this.getResource("SplitChainer.popup.error.title"), 0);
            }
            catch (IOException iOException) {
                this.logger.error("Error", (Throwable)iOException);
                JOptionPane.showMessageDialog(this, iOException.getMessage(), this.getResource("SplitChainer.popup.error.title"), 0);
            }
            catch (Exception exception) {
                this.logger.error("Error", (Throwable)exception);
                JOptionPane.showMessageDialog(this, exception.getMessage(), this.getResource("SplitChainer.popup.error.title"), 0);
            }
        }
    }

    private void showNewDancer() {
        DancerDialog dancerDialog = new DancerDialog(this);
        dancerDialog.setDancer(null);
        dancerDialog.popup();
        this.requestFocus();
    }

    private void showListDancer() {
        ListDancersDialog listDancersDialog = new ListDancersDialog(this);
        listDancersDialog.popup();
        if (this.actualFile != null) {
            this.doSave(this.actualFile);
        }
        this.requestFocus();
    }

    private Level showLevelSelect(Level level) {
        Level[] levelArray = Level.allLevel();
        Icon icon = null;
        return (Level)((Object)JOptionPane.showInputDialog(this, null, this.getResource("SplitChainer.popup.select_level.title"), -1, icon, (Object[])levelArray, (Object)level));
    }

    private void showPreferences() {
        JButton jButton = new JButton();
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(SplitChainer.this, "Panel background", ((SplitChainer)SplitChainer.this).dataContainer.dancerPanelBackgroundColor);
                if (color != null) {
                    ((SplitChainer)SplitChainer.this).dataContainer.dancerPanelBackgroundColor = color;
                    ((Component)actionEvent.getSource()).setBackground(color);
                }
            }
        });
        jButton.setBackground(this.dataContainer.dancerPanelBackgroundColor);
        JButton jButton2 = new JButton();
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(SplitChainer.this, "Rowcolor odd", ((SplitChainer)SplitChainer.this).dataContainer.dancerBackgroundColor1);
                if (color != null) {
                    ((SplitChainer)SplitChainer.this).dataContainer.dancerBackgroundColor1 = color;
                    ((Component)actionEvent.getSource()).setBackground(color);
                }
            }
        });
        jButton2.setBackground(this.dataContainer.dancerBackgroundColor1);
        JButton jButton3 = new JButton();
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(SplitChainer.this, "Rowcolor even", ((SplitChainer)SplitChainer.this).dataContainer.dancerBackgroundColor2);
                if (color != null) {
                    ((SplitChainer)SplitChainer.this).dataContainer.dancerBackgroundColor2 = color;
                    ((Component)actionEvent.getSource()).setBackground(color);
                }
            }
        });
        jButton3.setBackground(this.dataContainer.dancerBackgroundColor2);
        JButton jButton4 = new JButton();
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(SplitChainer.this, "Same Level and OUT", ((SplitChainer)SplitChainer.this).dataContainer.dancerOutAndSameLevelForegroundColor1);
                if (color != null) {
                    ((SplitChainer)SplitChainer.this).dataContainer.dancerOutAndSameLevelForegroundColor1 = color;
                    ((Component)actionEvent.getSource()).setBackground(color);
                }
            }
        });
        jButton4.setBackground(this.dataContainer.dancerOutAndSameLevelForegroundColor1);
        JButton jButton5 = new JButton();
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(SplitChainer.this, "Popup color", ((SplitChainer)SplitChainer.this).dataContainer.popupColor);
                if (color != null) {
                    ((SplitChainer)SplitChainer.this).dataContainer.popupColor = color;
                    ((Component)actionEvent.getSource()).setBackground(color);
                }
            }
        });
        jButton5.setBackground(this.dataContainer.popupColor);
        JButton jButton6 = new JButton();
        jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(SplitChainer.this, "Definition highlight", ((SplitChainer)SplitChainer.this).dataContainer.definitionHighlightColor);
                if (color != null) {
                    ((SplitChainer)SplitChainer.this).dataContainer.definitionHighlightColor = color;
                    ((Component)actionEvent.getSource()).setBackground(color);
                }
            }
        });
        jButton6.setBackground(this.dataContainer.definitionHighlightColor);
        JButton jButton7 = new JButton();
        jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(SplitChainer.this, "Definition normal", ((SplitChainer)SplitChainer.this).dataContainer.definitionNormallightColor);
                if (color != null) {
                    ((SplitChainer)SplitChainer.this).dataContainer.definitionNormallightColor = color;
                    ((Component)actionEvent.getSource()).setBackground(color);
                }
            }
        });
        jButton7.setBackground(this.dataContainer.definitionNormallightColor);
        final JTextField jTextField = ComponentFactory.numberInputField();
        jTextField.setText("" + this.dataContainer.displayTime);
        final JTextField jTextField2 = ComponentFactory.numberInputField();
        jTextField2.setText("" + this.dataContainer.popupTime);
        final JTextField jTextField3 = ComponentFactory.numberInputField();
        jTextField3.setText("" + this.dataContainer.fontSize);
        final JComboBox jComboBox = new JComboBox();
        Level.fill(jComboBox);
        jComboBox.setSelectedItem((Object)this.dataContainer.defaultLevelAtStartup);
        final JTextField jTextField4 = ComponentFactory.numberInputField();
        jTextField4.setText("" + this.dataContainer.scannerTime2Restart);
        jTextField4.setToolTipText(this.getResource("SplitChainer.preferences.scannertime.tooltip.text"));
        final JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setSelected(this.dataContainer.preferDancersOut);
        jCheckBox.setToolTipText(this.getResource("SplitChainer.preferences.prefer_dancers_out.tooltip.text"));
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        ToolTipManager.sharedInstance().registerComponent(jTextField4);
        ToolTipManager.sharedInstance().registerComponent(jCheckBox);
        final JTextField jTextField5 = ComponentFactory.numberInputField();
        jTextField5.setText("" + this.dataContainer.numberOfColumns);
        final JTextField jTextField6 = ComponentFactory.numberInputField();
        jTextField6.setText("" + this.dataContainer.overviewMaxColumns);
        final JTextField jTextField7 = ComponentFactory.numberInputField();
        jTextField7.setText("" + this.dataContainer.overviewMaxRows);
        final JTextField jTextField8 = ComponentFactory.numberInputField();
        final JTextField jTextField9 = ComponentFactory.numberInputField();
        final JTextField jTextField10 = ComponentFactory.numberInputField();
        final JTextField jTextField11 = ComponentFactory.numberInputField();
        final JTextField jTextField12 = ComponentFactory.numberInputField();
        final JTextField jTextField13 = ComponentFactory.numberInputField();
        final JTextField jTextField14 = ComponentFactory.numberInputField();
        final JTextField jTextField15 = ComponentFactory.numberInputField();
        final JTextField jTextField16 = ComponentFactory.numberInputField();
        jTextField8.setText(this.dataContainer.rotateSameScancode);
        jTextField9.setText(this.dataContainer.rotateOtherScancode);
        jTextField10.setText(this.dataContainer.toMaleScancode);
        jTextField11.setText(this.dataContainer.toFemaleScancode);
        jTextField12.setText(this.dataContainer.toBothScancode);
        jTextField13.setText(this.dataContainer.toSplitScancode);
        jTextField14.setText(this.dataContainer.toJoinScancode);
        jTextField15.setText(this.dataContainer.toLevelUpScancode);
        jTextField16.setText(this.dataContainer.toLevelDownScancode);
        MyDocumentListener myDocumentListener = new MyDocumentListener(jTextField8, jTextField9, jTextField10, jTextField11, jTextField12, jTextField13, jTextField14, jTextField15, jTextField16);
        jTextField8.getDocument().addDocumentListener(myDocumentListener);
        jTextField9.getDocument().addDocumentListener(myDocumentListener);
        jTextField10.getDocument().addDocumentListener(myDocumentListener);
        jTextField11.getDocument().addDocumentListener(myDocumentListener);
        jTextField12.getDocument().addDocumentListener(myDocumentListener);
        jTextField13.getDocument().addDocumentListener(myDocumentListener);
        jTextField14.getDocument().addDocumentListener(myDocumentListener);
        jTextField15.getDocument().addDocumentListener(myDocumentListener);
        jTextField16.getDocument().addDocumentListener(myDocumentListener);
        final JRadioButton jRadioButton = new JRadioButton("1");
        jRadioButton.setSelected(this.dataContainer.soundFile == 1);
        JRadioButton jRadioButton2 = new JRadioButton("2");
        jRadioButton2.setSelected(this.dataContainer.soundFile == 2);
        final JRadioButton jRadioButton3 = new JRadioButton("Extern");
        jRadioButton3.setSelected(this.dataContainer.soundFile == 3);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        CellConstraints cellConstraints = new CellConstraints();
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("pref, 1dlu, pref, 1dlu, pref", "pref"));
        panelBuilder.add((Component)jRadioButton, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)jRadioButton2, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)jRadioButton3, cellConstraints.xy(5, 1));
        final JTextField jTextField17 = new JTextField(this.dataContainer.externSoundfile);
        jTextField17.setEditable(false);
        JButton jButton8 = new JButton("O");
        jButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setSelectedFile(new File(((SplitChainer)SplitChainer.this).dataContainer.externSoundfile));
                jFileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        if (file.isDirectory()) {
                            return true;
                        }
                        return file.getName().endsWith(".wav");
                    }

                    @Override
                    public String getDescription() {
                        return "WAV Soundfiles";
                    }
                });
                int n = jFileChooser.showOpenDialog(SplitChainer.this);
                if (n == 0) {
                    ((SplitChainer)SplitChainer.this).dataContainer.externSoundfile = jFileChooser.getSelectedFile().getAbsolutePath();
                    jTextField17.setText(((SplitChainer)SplitChainer.this).dataContainer.externSoundfile);
                }
            }
        });
        PanelBuilder panelBuilder2 = new PanelBuilder(new FormLayout("45dlu, 1dlu, pref", "pref"));
        panelBuilder2.add((Component)jTextField17, cellConstraints.xy(1, 1));
        panelBuilder2.add((Component)jButton8, cellConstraints.xy(3, 1));
        final JCheckBox jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(this.dataContainer.playSound);
        final JCheckBox jCheckBox3 = new JCheckBox();
        jCheckBox3.setSelected(this.dataContainer.displayDefinitions);
        final JComboBox<String> jComboBox2 = new JComboBox<String>(new String[]{"Bigon", "Normal", "Hexagon"});
        jComboBox2.setSelectedIndex(this.dataContainer.couples / 2 - 1);
        final JComboBox<String> jComboBox3 = new JComboBox<String>(new String[]{"Start", this.getResource("SplitChainer.menu.dancer.overview.text"), this.getResource("SplitChainer.menu.dancer.present.text")});
        jComboBox3.setSelectedIndex(this.dataContainer.defaultScreen);
        final JCheckBox jCheckBox4 = new JCheckBox();
        jCheckBox4.setSelected(this.dataContainer.autoSplit);
        final JDialog jDialog = new JDialog(this, this.getResource("SplitChainer.preferences.title"), true);
        String string = "pref, 2dlu, 60dlu:grow";
        int n = 12;
        int n2 = 2;
        StringBuilder stringBuilder = new StringBuilder("fill:" + n + "dlu");
        for (int i = 1; i < 20; ++i) {
            stringBuilder.append(", ").append(n2).append("dlu, fill:").append(n).append("dlu");
        }
        PanelBuilder panelBuilder3 = new PanelBuilder(new FormLayout(string, stringBuilder.toString()));
        panelBuilder3.addLabel(this.getResource("SplitChainer.preferences.startuplevel"));
        panelBuilder3.nextColumn(2);
        panelBuilder3.add(jComboBox);
        panelBuilder3.nextColumn(-2);
        panelBuilder3.nextRow(2);
        panelBuilder3.addLabel(this.getResource("SplitChainer.preferences.panelbackground"));
        panelBuilder3.nextColumn(2);
        panelBuilder3.add((Component)jButton);
        panelBuilder3.nextColumn(-2);
        panelBuilder3.nextRow(2);
        panelBuilder3.addLabel(this.getResource("SplitChainer.preferences.rowcolorodd"));
        panelBuilder3.nextColumn(2);
        panelBuilder3.add((Component)jButton2);
        panelBuilder3.nextColumn(-2);
        panelBuilder3.nextRow(2);
        panelBuilder3.addLabel(this.getResource("SplitChainer.preferences.rowcoloreven"));
        panelBuilder3.nextColumn(2);
        panelBuilder3.add((Component)jButton3);
        panelBuilder3.nextColumn(-2);
        panelBuilder3.nextRow(2);
        panelBuilder3.addLabel(this.getResource("SplitChainer.preferences.foregroundSameLevelOUT"));
        panelBuilder3.nextColumn(2);
        panelBuilder3.add((Component)jButton4);
        panelBuilder3.nextColumn(-2);
        panelBuilder3.nextRow(2);
        panelBuilder3.addLabel(this.getResource("SplitChainer.preferences.popupcolor"));
        panelBuilder3.nextColumn(2);
        panelBuilder3.add((Component)jButton5);
        panelBuilder3.nextColumn(-2);
        panelBuilder3.nextRow(2);
        panelBuilder3.addLabel(this.getResource("SplitChainer.preferences.definitionhighlight"));
        panelBuilder3.nextColumn(2);
        panelBuilder3.add((Component)jButton6);
        panelBuilder3.nextColumn(-2);
        panelBuilder3.nextRow(2);
        panelBuilder3.addLabel(this.getResource("SplitChainer.preferences.definitionnormal"));
        panelBuilder3.nextColumn(2);
        panelBuilder3.add((Component)jButton7);
        panelBuilder3.nextColumn(-2);
        panelBuilder3.nextRow(2);
        panelBuilder3.addLabel(this.getResource("SplitChainer.preferences.displaytime"));
        panelBuilder3.nextColumn(2);
        panelBuilder3.add((Component)jTextField);
        panelBuilder3.nextColumn(-2);
        panelBuilder3.nextRow(2);
        panelBuilder3.addLabel(this.getResource("SplitChainer.preferences.popuptime"));
        panelBuilder3.nextColumn(2);
        panelBuilder3.add((Component)jTextField2);
        panelBuilder3.nextColumn(-2);
        panelBuilder3.nextRow(2);
        panelBuilder3.addLabel(this.getResource("SplitChainer.preferences.fontsize"));
        panelBuilder3.nextColumn(2);
        panelBuilder3.add((Component)jTextField3);
        panelBuilder3.nextColumn(-2);
        panelBuilder3.nextRow(2);
        panelBuilder3.addLabel(this.getResource("SplitChainer.preferences.sc_rotatesame"));
        panelBuilder3.nextColumn(2);
        panelBuilder3.add((Component)jTextField8);
        panelBuilder3.nextColumn(-2);
        panelBuilder3.nextRow(2);
        panelBuilder3.addLabel(this.getResource("SplitChainer.preferences.sc_rotate_other"));
        panelBuilder3.nextColumn(2);
        panelBuilder3.add((Component)jTextField9);
        panelBuilder3.nextColumn(-2);
        panelBuilder3.nextRow(2);
        panelBuilder3.addLabel(this.getResource("SplitChainer.preferences.sc_tobeau"));
        panelBuilder3.nextColumn(2);
        panelBuilder3.add((Component)jTextField10);
        panelBuilder3.nextColumn(-2);
        panelBuilder3.nextRow(2);
        panelBuilder3.addLabel(this.getResource("SplitChainer.preferences.sc_tobelle"));
        panelBuilder3.nextColumn(2);
        panelBuilder3.add((Component)jTextField11);
        panelBuilder3.nextColumn(-2);
        panelBuilder3.nextRow(2);
        panelBuilder3.addLabel(this.getResource("SplitChainer.preferences.sc_tobeauandbelle"));
        panelBuilder3.nextColumn(2);
        panelBuilder3.add((Component)jTextField12);
        panelBuilder3.nextColumn(-2);
        panelBuilder3.nextRow(2);
        panelBuilder3.addLabel(this.getResource("SplitChainer.preferences.sc_split"));
        panelBuilder3.nextColumn(2);
        panelBuilder3.add((Component)jTextField14);
        panelBuilder3.nextColumn(-2);
        panelBuilder3.nextRow(2);
        panelBuilder3.addLabel(this.getResource("SplitChainer.preferences.sc_chain"));
        panelBuilder3.nextColumn(2);
        panelBuilder3.add((Component)jTextField13);
        panelBuilder3.nextColumn(-2);
        panelBuilder3.nextRow(2);
        panelBuilder3.addLabel(this.getResource("SplitChainer.preferences.sc_uplevel"));
        panelBuilder3.nextColumn(2);
        panelBuilder3.add((Component)jTextField15);
        panelBuilder3.nextColumn(-2);
        panelBuilder3.nextRow(2);
        panelBuilder3.addLabel(this.getResource("SplitChainer.preferences.sc_dolevel"));
        panelBuilder3.nextColumn(2);
        panelBuilder3.add((Component)jTextField16);
        PanelBuilder panelBuilder4 = new PanelBuilder(new FormLayout(string, stringBuilder.toString()));
        panelBuilder4.addLabel(this.getResource("SplitChainer.preferences.scannersettletime"));
        panelBuilder4.nextColumn(2);
        panelBuilder4.add((Component)jTextField4);
        panelBuilder4.nextColumn(-2);
        panelBuilder4.nextRow(2);
        panelBuilder4.addLabel(this.getResource("SplitChainer.preferences.preferdancersout"));
        panelBuilder4.nextColumn(2);
        panelBuilder4.add((Component)jCheckBox);
        panelBuilder4.nextColumn(-2);
        panelBuilder4.nextRow(2);
        panelBuilder4.addLabel(this.getResource("SplitChainer.preferences.numberofcolumns"));
        panelBuilder4.nextColumn(2);
        panelBuilder4.add((Component)jTextField5);
        panelBuilder4.nextColumn(-2);
        panelBuilder4.nextRow(2);
        panelBuilder4.addLabel(this.getResource("SplitChainer.preferences.overviewnumberofcolumns"));
        panelBuilder4.nextColumn(2);
        panelBuilder4.add((Component)jTextField6);
        panelBuilder4.nextColumn(-2);
        panelBuilder4.nextRow(2);
        panelBuilder4.addLabel(this.getResource("SplitChainer.preferences.overviewnumberofrows"));
        panelBuilder4.nextColumn(2);
        panelBuilder4.add((Component)jTextField7);
        panelBuilder4.nextColumn(-2);
        panelBuilder4.nextRow(2);
        panelBuilder4.addLabel(this.getResource("SplitChainer.preferences.playsound"));
        panelBuilder4.nextColumn(2);
        panelBuilder4.add((Component)jCheckBox2);
        panelBuilder4.nextColumn(-2);
        panelBuilder4.nextRow(2);
        panelBuilder4.addLabel(this.getResource("SplitChainer.preferences.sound"));
        panelBuilder4.nextColumn(2);
        panelBuilder4.add((Component)panelBuilder.getPanel());
        panelBuilder4.nextColumn(-2);
        panelBuilder4.nextRow(2);
        panelBuilder4.addLabel(this.getResource("SplitChainer.preferences.soundfile"));
        panelBuilder4.nextColumn(2);
        panelBuilder4.add((Component)panelBuilder2.getPanel());
        panelBuilder4.nextColumn(-2);
        panelBuilder4.nextRow(2);
        panelBuilder4.addLabel(this.getResource("SplitChainer.preferences.displayDefinitions"));
        panelBuilder4.nextColumn(2);
        panelBuilder4.add((Component)jCheckBox3);
        panelBuilder4.nextColumn(-2);
        panelBuilder4.nextRow(2);
        panelBuilder4.addLabel(this.getResource("SplitChainer.preferences.mode"));
        panelBuilder4.nextColumn(2);
        panelBuilder4.add(jComboBox2);
        panelBuilder4.nextColumn(-2);
        panelBuilder4.nextRow(2);
        panelBuilder4.addLabel(this.getResource("SplitChainer.preferences.defaultScreen"));
        panelBuilder4.nextColumn(2);
        panelBuilder4.add(jComboBox3);
        panelBuilder4.nextColumn(-2);
        panelBuilder4.nextRow(2);
        panelBuilder4.addLabel(this.getResource("SplitChainer.preferences.autoSplit"));
        panelBuilder4.nextColumn(2);
        panelBuilder4.add((Component)jCheckBox4);
        PanelBuilder panelBuilder5 = new PanelBuilder(new FormLayout("4dlu, pref, 4dlu", "4dlu, pref, 4dlu"));
        panelBuilder5.add((Component)panelBuilder4.getPanel(), cellConstraints.xy(2, 2));
        PanelBuilder panelBuilder6 = new PanelBuilder(new FormLayout("pref", "pref"));
        panelBuilder6.add((Component)panelBuilder3.getPanel(), cellConstraints.xy(1, 1));
        PanelBuilder panelBuilder7 = new PanelBuilder(new FormLayout("4dlu, 20dlu:grow, pref, 20dlu:grow, 4dlu", "4dlu, pref, 8dlu, pref, 4dlu"));
        JTabbedPane jTabbedPane = new JTabbedPane();
        panelBuilder7.add((Component)jTabbedPane, cellConstraints.xyw(2, 2, 3));
        jTabbedPane.add(this.getResource("SplitChainer.preferences.general"), panelBuilder6.getPanel());
        jTabbedPane.add(this.getResource("SplitChainer.preferences.advanced"), panelBuilder5.getPanel());
        JButton jButton9 = new JButton("OK");
        jButton9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string = jTextField.getText();
                    ((SplitChainer)SplitChainer.this).dataContainer.displayTime = Integer.parseInt(string);
                    string = jTextField2.getText();
                    ((SplitChainer)SplitChainer.this).dataContainer.popupTime = Integer.parseInt(string);
                    string = jTextField3.getText();
                    ((SplitChainer)SplitChainer.this).dataContainer.fontSize = Integer.parseInt(string);
                    string = jTextField4.getText();
                    ((SplitChainer)SplitChainer.this).dataContainer.scannerTime2Restart = Integer.parseInt(string);
                    string = jTextField5.getText();
                    ((SplitChainer)SplitChainer.this).dataContainer.numberOfColumns = Math.max(1, Integer.parseInt(string));
                    string = jTextField6.getText();
                    ((SplitChainer)SplitChainer.this).dataContainer.overviewMaxColumns = Math.max(1, Integer.parseInt(string));
                    string = jTextField7.getText();
                    ((SplitChainer)SplitChainer.this).dataContainer.overviewMaxRows = Math.max(1, Integer.parseInt(string));
                    ((SplitChainer)SplitChainer.this).dataContainer.preferDancersOut = jCheckBox.isSelected();
                    ((SplitChainer)SplitChainer.this).dataContainer.defaultLevelAtStartup = (Level)((Object)Level.class.cast(jComboBox.getSelectedItem()));
                    ((SplitChainer)SplitChainer.this).dataContainer.rotateSameScancode = jTextField8.getText().trim();
                    ((SplitChainer)SplitChainer.this).dataContainer.rotateOtherScancode = jTextField9.getText().trim();
                    ((SplitChainer)SplitChainer.this).dataContainer.toMaleScancode = jTextField10.getText().trim();
                    ((SplitChainer)SplitChainer.this).dataContainer.toFemaleScancode = jTextField11.getText().trim();
                    ((SplitChainer)SplitChainer.this).dataContainer.toBothScancode = jTextField12.getText().trim();
                    ((SplitChainer)SplitChainer.this).dataContainer.toSplitScancode = jTextField13.getText().trim();
                    ((SplitChainer)SplitChainer.this).dataContainer.toJoinScancode = jTextField14.getText().trim();
                    ((SplitChainer)SplitChainer.this).dataContainer.toLevelUpScancode = jTextField15.getText().trim();
                    ((SplitChainer)SplitChainer.this).dataContainer.toLevelDownScancode = jTextField16.getText().trim();
                    ((SplitChainer)SplitChainer.this).dataContainer.playSound = jCheckBox2.isSelected();
                    ((SplitChainer)SplitChainer.this).dataContainer.soundFile = jRadioButton.isSelected() ? 1 : (jRadioButton3.isSelected() ? 3 : 2);
                    ((SplitChainer)SplitChainer.this).dataContainer.displayDefinitions = jCheckBox3.isSelected();
                    ((SplitChainer)SplitChainer.this).dataContainer.couples = 2 * (jComboBox2.getSelectedIndex() + 1);
                    ((SplitChainer)SplitChainer.this).dataContainer.defaultScreen = jComboBox3.getSelectedIndex();
                    ((SplitChainer)SplitChainer.this).dataContainer.autoSplit = jCheckBox4.isSelected();
                    SplitChainer.this.dataContainer.save(SplitChainer.this);
                    jDialog.setVisible(false);
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(SplitChainer.this, SplitChainer.this.getResource("SplitChainer.preferences.error.popup.text"), SplitChainer.this.getResource("SplitChainer.popup.error.title"), 0);
                }
                ToolTipManager.sharedInstance().unregisterComponent(jTextField4);
                ToolTipManager.sharedInstance().unregisterComponent(jCheckBox);
            }
        });
        panelBuilder7.add((Component)jButton9, cellConstraints.xyw(3, 4, 1));
        jDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        jDialog.setContentPane(panelBuilder7.getPanel());
        jDialog.pack();
        jDialog.setLocationRelativeTo(this);
        jDialog.setVisible(true);
        this.requestFocus();
    }

    private void showLicenseDialog() {
        LicenseManager licenseManager = new LicenseManager(this.useLicenseParam);
        LicenseWizard licenseWizard = new LicenseWizard(licenseManager);
        licenseWizard.showModalDialog(this);
        this.requestFocus();
    }

    private void showAbout() {
        JLabel jLabel = new JLabel(this.getResource("SplitChainer.popup.about.text", VERSION));
        Image image = this.bImage.getScaledInstance(100, 100, 4);
        JOptionPane.showMessageDialog(this, jLabel, this.getResource("SplitChainer.popup.about.title"), 1, new ImageIcon(image));
    }

    private void checkLicense(JFrame jFrame, boolean bl) {
        block3: {
            int n = 6;
            LicenseManager licenseManager = new LicenseManager(this.useLicenseParam);
            try {
                LicenseContent licenseContent = licenseManager.verify();
                this.licensed = true;
                X500PrincipalHelper x500PrincipalHelper = new X500PrincipalHelper(licenseContent.getHolder());
                this.licensee = x500PrincipalHelper.getCN();
                this.logger.info("License for {} is valid until {}", (Object)this.licensee, (Object)licenseContent.getNotAfter());
                String string = x500PrincipalHelper.getSTREET();
                if (string != null && string.length() > 0) {
                    this.licensedFunctions = new LicensedFunctions(Long.parseLong(string));
                    this.logger.info("Licensetext: {}", (Object)this.licensee);
                }
            }
            catch (Exception exception) {
                this.licensed = false;
                this.licensed = true;
                if (this.globalLicenseCounter < n) break block3;
                JOptionPane.showMessageDialog(jFrame, this.getResource("SplitChainer.licensePopup.exit.text", n), this.getResource("SplitChainer.licensePopup.title"), 1);
                this.showAbout();
                System.exit(0);
            }
        }
    }

    public void handleEndDisplay() {
        switch (this.dataContainer.defaultScreen) {
            default: {
                this.stopDisplayLoop();
                this.startDefinitionLoop();
                break;
            }
            case 1: {
                this.showOverview();
                break;
            }
            case 2: {
                this.showPresent();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        int n;
        String string2 = actionEvent.getActionCommand();
        this.logger.info("actionCommand: " + string2 + " " + actionEvent.getSource());
        if ("exit".equalsIgnoreCase(string2)) {
            System.exit(0);
        }
        if ("open".equalsIgnoreCase(string2)) {
            this.doOpen();
            string2 = "overview";
        }
        if ("save".equalsIgnoreCase(string2)) {
            this.doSave();
            return;
        }
        if ("saveAs".equalsIgnoreCase(string2)) {
            this.doSaveAs();
            return;
        }
        if ("preferences".equalsIgnoreCase(string2)) {
            this.showPreferences();
            return;
        }
        if ("newDancer".equalsIgnoreCase(string2)) {
            this.showNewDancer();
            return;
        }
        if ("listDancer".equalsIgnoreCase(string2)) {
            this.showListDancer();
            return;
        }
        if ("rotate".equalsIgnoreCase(string2)) {
            this.doRotateSame();
            return;
        }
        if ("srotate".equalsIgnoreCase(string2)) {
            this.doRotateOther();
            return;
        }
        if ("startDisplay".equalsIgnoreCase(string2)) {
            this.disableAll();
            Toolkit.getDefaultToolkit().beep();
            this.startShowDancers();
            this.enableRotate();
            this.enableScanner();
            this.stopDefinitionLoop();
            this.startDisplayLoop();
            return;
        }
        if ("stopDisplay".equalsIgnoreCase(string2)) {
            this.disableAll();
            Toolkit.getDefaultToolkit().beep();
            this.switchToInputMode();
            this.enableRotate();
            this.enableScanner();
            this.handleEndDisplay();
            return;
        }
        if ("timer".equalsIgnoreCase(string2)) {
            this.handleDisplay();
            return;
        }
        if ("nextDefinition".equalsIgnoreCase(string2)) {
            this.switchToInputMode();
            return;
        }
        if ("clearInput".equalsIgnoreCase(string2)) {
            this.setPopupInvisible();
            return;
        }
        if ("license".equals(string2)) {
            this.showLicenseDialog();
            return;
        }
        if ("about".equals(string2)) {
            this.showAbout();
            return;
        }
        if ("openTip".equals(string2)) {
            this.showOpenTip();
            return;
        }
        if ("opentipTimer".equals(string2)) {
            this.showMovingOpenTip();
            return;
        }
        if ("histogram".equals(string2)) {
            this.disableAll();
            this.showHistogram();
            return;
        }
        if ("diagram".equals(string2)) {
            this.showDiagram();
            return;
        }
        if ("personInSquare".equals(string2)) {
            this.showPersonInSquare();
            return;
        }
        if ("squareToPerson".equals(string2)) {
            this.showSquareToPerson();
            return;
        }
        if ("barcode".equals(string2)) {
            this.showBarcodeDialog();
            return;
        }
        if ("overview".equals(string2)) {
            this.showOverview();
            return;
        }
        if ("present".equals(string2)) {
            this.showPresent();
            return;
        }
        for (n = 1; n < 10; ++n) {
            string = "Screen" + n;
            if (!string.equals(string2)) continue;
            this.screenNumber2Use = n - 1;
            this.moveToScreen();
            return;
        }
        for (n = 0; n < 16; ++n) {
            string = String.format("scanner%X", n);
            if (!string.equalsIgnoreCase(string2)) continue;
            this.doScannerInput(actionEvent);
            this.adjustMenuSquares();
            if (this.overviewActive) {
                this.showOverview();
            }
            return;
        }
        JOptionPane.showMessageDialog(this, "Unknown internal error: command unknown: " + string2, this.getResource("SplitChainer.popup.error.title"), 0);
    }

    public Dimension getOffset() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        Rectangle rectangle = graphicsDeviceArray[this.screenNumber2Use].getDefaultConfiguration().getBounds();
        Dimension dimension = new Dimension(rectangle.x, rectangle.y);
        return dimension;
    }

    public Dimension getScreenSize() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        this.screenNumber2Use = Math.min(this.screenNumber2Use, graphicsDeviceArray.length);
        Dimension dimension = new Dimension(graphicsDeviceArray[this.screenNumber2Use].getDisplayMode().getWidth(), graphicsDeviceArray[0].getDisplayMode().getHeight());
        return dimension;
    }

    private void showBarcodeDialog() {
        this.stopDefinitionLoop();
        this.stopDisplayLoop();
        BarcodeCreateDialog barcodeCreateDialog = new BarcodeCreateDialog(this);
        barcodeCreateDialog.pack();
        barcodeCreateDialog.setLocationRelativeTo(this);
        Dimension dimension = this.getScreenSize();
        Dimension dimension2 = this.getOffset();
        Rectangle rectangle = barcodeCreateDialog.getBounds();
        int n = (dimension.width - rectangle.width) / 2 + dimension2.width;
        int n2 = (dimension.height - rectangle.height) / 2 + dimension2.height;
        barcodeCreateDialog.setLocation(n, n2);
        barcodeCreateDialog.setVisible(true);
    }

    private void showPresent() {
        this.disableAll();
        this.overviewActive = true;
        this.enableScanner();
        this.enableRotate();
        Container container = this.removeOldScreen();
        Dimension dimension = this.getScreenSize();
        int n = Math.max(1, this.dataContainer.overviewMaxColumns);
        int n2 = this.dataContainer.overviewMaxRows;
        int n3 = (dimension.width - 20) / n;
        int n4 = dimension.height / n2;
        StringBuilder stringBuilder = new StringBuilder("10px, ");
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(" fill:" + n3 + "px, ");
        }
        Font font = new Font("Courier", 0, n4 - 2);
        stringBuilder.append(" 10px");
        StringBuilder stringBuilder2 = new StringBuilder("10px, ");
        for (int i = 0; i < n2; ++i) {
            stringBuilder2.append(" fill:" + n4 + "px, ");
        }
        stringBuilder2.append(" 10px");
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout(stringBuilder.toString(), stringBuilder2.toString()));
        int n5 = 0;
        int n6 = 0;
        boolean bl = System.getProperty("showGender") != null;
        panelBuilder.nextColumn();
        panelBuilder.nextRow();
        List<Dancer> list = DancersSingleton.getInstance().getPresentDancers();
        int n7 = list.size();
        int n8 = Math.min(n2, (n7 + n - 1) / n);
        for (Dancer dancer : list) {
            if (n5 >= n2 || n6 >= n) continue;
            JLabel jLabel = dancer.createPresentLabel(bl);
            jLabel.setFont(font);
            jLabel.setOpaque(false);
            panelBuilder.add((Component)jLabel);
            panelBuilder.nextRow();
            if (++n5 < n8) continue;
            n5 = 0;
            panelBuilder.nextRow(-n8);
            panelBuilder.nextColumn();
            ++n6;
        }
        panelBuilder.getPanel().setBackground(this.dataContainer.dancerPanelBackgroundColor);
        panelBuilder.getPanel().setName(this.panelName);
        container.add((Component)panelBuilder.getPanel(), "Center");
        this.validate();
        this.repaint();
    }

    private void showOverview() {
        this.disableAll();
        this.overviewActive = true;
        this.enableScanner();
        this.enableRotate();
        Container container = this.removeOldScreen();
        boolean bl = System.getProperty("showGender") != null;
        Dimension dimension = this.getScreenSize();
        int n = this.dataContainer.overviewMaxColumns;
        int n2 = this.dataContainer.overviewMaxRows;
        int n3 = (dimension.width - 20) / n;
        int n4 = dimension.height / n2;
        StringBuilder stringBuilder = new StringBuilder("10px, ");
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(" fill:" + n3 + "px, ");
        }
        Font font = new Font("Courier", 0, n4 - 2);
        stringBuilder.append(" 10px");
        StringBuilder stringBuilder2 = new StringBuilder("10px, ");
        for (int i = 0; i < n2; ++i) {
            stringBuilder2.append(" fill:" + n4 + "px, ");
        }
        stringBuilder2.append(" 10px");
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout(stringBuilder.toString(), stringBuilder2.toString()));
        int n5 = 0;
        int n6 = 0;
        panelBuilder.nextColumn();
        panelBuilder.nextRow();
        List<Dancer> list = DancersSingleton.getInstance().getOverviewDancers();
        int n7 = list.size();
        int n8 = Math.min(n2, (n7 + n - 1) / n);
        for (Dancer dancer : list) {
            if (n5 >= n2 || n6 >= n) continue;
            JLabel jLabel = dancer.createOverviewLabel(Color.decode("#00FF00"), Color.decode("#FF0000"), Color.decode("#0000FF"), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DancersSingleton.getInstance().handleScanner(actionEvent.getActionCommand(), SplitChainer.this.licensed);
                    SplitChainer.this.adjustMenuSquares();
                }
            }, bl);
            jLabel.setFont(font);
            jLabel.setOpaque(false);
            panelBuilder.add((Component)jLabel);
            panelBuilder.nextRow();
            if (++n5 < n8) continue;
            n5 = 0;
            panelBuilder.nextRow(-n8);
            panelBuilder.nextColumn();
            ++n6;
        }
        panelBuilder.getPanel().setBackground(this.dataContainer.dancerPanelBackgroundColor);
        panelBuilder.getPanel().setName(this.panelName);
        container.add((Component)panelBuilder.getPanel(), "Center");
        this.validate();
        this.repaint();
    }

    private void showHistogram() {
        Dancer dancer2;
        this.disableAll();
        this.enableScanner();
        this.enableRotate();
        Container container = this.removeOldScreen();
        Dimension dimension = this.getScreenSize();
        List<Dancer> list = DancersSingleton.getInstance().getPresentDancers();
        int n = list.size() / 8 + 1;
        StringBuilder stringBuilder = new StringBuilder("10px, ");
        for (int i = 0; i < 8; ++i) {
            stringBuilder.append(" fill:320px, 5px, ");
        }
        stringBuilder.append(" 10px");
        StringBuilder stringBuilder2 = new StringBuilder("10px, ");
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(" fill:240px, 5px, ");
        }
        stringBuilder2.append(" 10px");
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout(stringBuilder.toString(), stringBuilder2.toString()));
        panelBuilder.nextColumn();
        panelBuilder.nextRow();
        int n2 = 0;
        int n3 = 0;
        for (Dancer dancer2 : list) {
            if (n3 >= n) continue;
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < dancer2.getPartnerHistory().size(); ++i) {
                Dancer dancer3;
                String string = dancer2.getPartnerHistory().get(i);
                Long l = null;
                if (string != null && string.length() > 0) {
                    l = Long.valueOf(string);
                }
                if ((dancer3 = DancersSingleton.getInstance().findDancer(l)) != null) {
                    vector.add(dancer3.getDisplayName());
                    continue;
                }
                vector.add("");
            }
            panelBuilder.add((Component)new JHistogram(dancer2.getDisplayName(), vector));
            panelBuilder.nextColumn(2);
            if (++n2 != 8) continue;
            ++n3;
            panelBuilder.nextRow(2);
            panelBuilder.nextColumn(-16);
            n2 = 0;
        }
        panelBuilder.getPanel().setBackground(this.dataContainer.dancerPanelBackgroundColor);
        JScrollPane jScrollPane = new JScrollPane(panelBuilder.getPanel());
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        dancer2 = new PanelBuilder(new FormLayout("" + dimension.width + "px", "" + dimension.height + "px"));
        dancer2.getPanel().setName(this.panelName);
        dancer2.add(jScrollPane);
        container.add((Component)dancer2.getPanel(), "Center");
        this.validate();
        this.repaint();
    }

    private void showDiagram() {
        Dancer dancer2;
        this.disableAll();
        this.enableScanner();
        this.enableRotate();
        Container container = this.removeOldScreen();
        Dimension dimension = this.getScreenSize();
        List<Dancer> list = DancersSingleton.getInstance().getPresentDancers();
        int n = list.size() / 8 + 1;
        StringBuilder stringBuilder = new StringBuilder("10px, ");
        for (int i = 0; i < 8; ++i) {
            stringBuilder.append(" fill:320px, 5px, ");
        }
        stringBuilder.append(" 10px");
        StringBuilder stringBuilder2 = new StringBuilder("10px, ");
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(" fill:240px, 5px, ");
        }
        stringBuilder2.append(" 10px");
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout(stringBuilder.toString(), stringBuilder2.toString()));
        panelBuilder.nextColumn();
        panelBuilder.nextRow();
        int n2 = 0;
        int n3 = 0;
        for (Dancer dancer2 : list) {
            if (n3 >= n) continue;
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < dancer2.getPartnerHistory().size(); ++i) {
                Dancer dancer3;
                String string = dancer2.getPartnerHistory().get(i);
                Long l = null;
                if (string != null && string.length() > 0) {
                    l = Long.valueOf(string);
                }
                if ((dancer3 = DancersSingleton.getInstance().findDancer(l)) != null) {
                    vector.add(dancer3.getDisplayName());
                    continue;
                }
                vector.add("");
            }
            panelBuilder.add((Component)new JDiagram(dancer2.getDisplayName(), vector));
            panelBuilder.nextColumn(2);
            if (++n2 != 8) continue;
            ++n3;
            panelBuilder.nextRow(2);
            panelBuilder.nextColumn(-16);
            n2 = 0;
        }
        panelBuilder.getPanel().setBackground(this.dataContainer.dancerPanelBackgroundColor);
        JScrollPane jScrollPane = new JScrollPane(panelBuilder.getPanel());
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        dancer2 = new PanelBuilder(new FormLayout("" + dimension.width + "px", "" + dimension.height + "px"));
        dancer2.getPanel().setName(this.panelName);
        dancer2.add(jScrollPane);
        container.add((Component)dancer2.getPanel(), "Center");
        this.validate();
        this.repaint();
    }

    private void showSquareToPerson() {
        Dancer dancer2;
        this.disableAll();
        this.enableScanner();
        this.enableRotate();
        Container container = this.removeOldScreen();
        Dimension dimension = this.getScreenSize();
        List<Dancer> list = DancersSingleton.getInstance().getPresentDancers();
        int n = list.size() / 8 + 1;
        StringBuilder stringBuilder = new StringBuilder("10px, ");
        for (int i = 0; i < 8; ++i) {
            stringBuilder.append(" fill:320px, 5px, ");
        }
        stringBuilder.append(" 10px");
        StringBuilder stringBuilder2 = new StringBuilder("10px, ");
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(" fill:240px, 5px, ");
        }
        stringBuilder2.append(" 10px");
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout(stringBuilder.toString(), stringBuilder2.toString()));
        panelBuilder.nextColumn();
        panelBuilder.nextRow();
        int n2 = 0;
        int n3 = 0;
        for (Dancer dancer2 : list) {
            if (n3 >= n) continue;
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < dancer2.getPartnerHistory().size(); ++i) {
                Dancer dancer3;
                String string = dancer2.getPartnerHistory().get(i);
                Long l = null;
                if (string != null && string.length() > 0) {
                    l = Long.valueOf(string);
                }
                if ((dancer3 = DancersSingleton.getInstance().findDancer(l)) != null) {
                    vector.add(dancer3.getDisplayName());
                    continue;
                }
                vector.add("");
            }
            panelBuilder.add((Component)new JDiagram(dancer2.getDisplayName(), vector));
            panelBuilder.nextColumn(2);
            if (++n2 != 8) continue;
            ++n3;
            panelBuilder.nextRow(2);
            panelBuilder.nextColumn(-16);
            n2 = 0;
        }
        panelBuilder.getPanel().setBackground(this.dataContainer.dancerPanelBackgroundColor);
        JScrollPane jScrollPane = new JScrollPane(panelBuilder.getPanel());
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        dancer2 = new PanelBuilder(new FormLayout("" + dimension.width + "px", "" + dimension.height + "px"));
        dancer2.getPanel().setName(this.panelName);
        dancer2.add(jScrollPane);
        container.add((Component)dancer2.getPanel(), "Center");
        this.validate();
        this.repaint();
    }

    private void showPersonInSquare() {
        Dancer dancer2;
        this.disableAll();
        this.enableScanner();
        this.enableRotate();
        Container container = this.removeOldScreen();
        Dimension dimension = this.getScreenSize();
        List<Dancer> list = DancersSingleton.getInstance().getPresentDancers();
        int n = list.size() / 8 + 1;
        StringBuilder stringBuilder = new StringBuilder("10px, ");
        for (int i = 0; i < 8; ++i) {
            stringBuilder.append(" fill:320px, 5px, ");
        }
        stringBuilder.append(" 10px");
        StringBuilder stringBuilder2 = new StringBuilder("10px, ");
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(" fill:240px, 5px, ");
        }
        stringBuilder2.append(" 10px");
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout(stringBuilder.toString(), stringBuilder2.toString()));
        panelBuilder.nextColumn();
        panelBuilder.nextRow();
        int n2 = 0;
        int n3 = 0;
        for (Dancer dancer2 : list) {
            if (n3 >= n) continue;
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < dancer2.getSquareHistory().size(); ++i) {
                String string = dancer2.getSquareHistory().get(i);
                vector.add(string);
            }
            panelBuilder.add((Component)new JDiagram(dancer2.getDisplayName(), vector));
            panelBuilder.nextColumn(2);
            if (++n2 != 8) continue;
            ++n3;
            panelBuilder.nextRow(2);
            panelBuilder.nextColumn(-16);
            n2 = 0;
        }
        panelBuilder.getPanel().setBackground(this.dataContainer.dancerPanelBackgroundColor);
        JScrollPane jScrollPane = new JScrollPane(panelBuilder.getPanel());
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        dancer2 = new PanelBuilder(new FormLayout("" + dimension.width + "px", "" + dimension.height + "px"));
        dancer2.getPanel().setName(this.panelName);
        dancer2.add(jScrollPane);
        container.add((Component)dancer2.getPanel(), "Center");
        this.validate();
        this.repaint();
    }

    private synchronized void adjustMenuSquares() {
        String[] stringArray = new String[]{"Bigon", "Normal", "Hexagon"};
        String string = this.getResource("SplitChainer.preferences.mode");
        int n = DancersSingleton.getInstance().getAvailable();
        int n2 = this.dataContainer.couples * 2;
        int n3 = n / n2;
        int n4 = n - n3 * n2;
        int n5 = DancersSingleton.getInstance().getAllPresent(Gender.Beau);
        int n6 = DancersSingleton.getInstance().getAllPresent(Gender.Belle);
        int n7 = DancersSingleton.getInstance().getAllPresent(Gender.BeauAndBelle);
        this.menuSquares.setText("" + DancersSingleton.getInstance().getPresent() + ":  " + n3 + "/" + n4 + "    /=" + n5 + "    +=" + n6 + "    #=" + n7 + "      " + string + "=" + stringArray[this.dataContainer.couples / 2 - 1]);
        this.menuSquares.setToolTipText("<html>Present: " + DancersSingleton.getInstance().getPresent() + "<br/>Squares/Rest: " + n3 + "/" + n4 + "<br/>Beaus(/): " + n5 + "<br/>Belles(+): " + n6 + "<br/>Beaus&Belles(#): " + n7 + "<br/>" + string + ": " + stringArray[this.dataContainer.couples2Index()] + "</html>");
    }

    private void doRotateOther() {
        if (this.licensed) {
            PreferLevel preferLevel = new PreferLevel(this.preferSameLevelDancer, this.licensed, this.globalLevel);
            RotateDialog rotateDialog = new RotateDialog((Frame)this, this, preferLevel);
            if ((preferLevel = rotateDialog.getResult()) != null) {
                Level level = preferLevel.getLevel();
                this.preferSameLevelDancer = preferLevel.isPrefer();
                if (level != null) {
                    this.globalLevel = level;
                    this.lastIndex = 0;
                    this.disableAll();
                    this.checkLicense(this, true);
                    try {
                        this.sendRotateEvent(DancersSingleton.getInstance().getTotalDeuces() + 1, this.globalLevel);
                        DancersSingleton.getInstance().rotate(this.globalLevel, this.dataContainer.preferDancersOut, this.preferSameLevelDancer, this.dataContainer.couples, this.dataContainer.autoSplit);
                        this.playSound();
                        this.startShowDancers();
                    }
                    catch (Exception exception) {
                        this.logger.error("Oh my god", (Throwable)exception);
                        JOptionPane.showMessageDialog(this, exception.getMessage(), this.getResource("SplitChainer.popup.error.title"), 0);
                    }
                    this.enableScanner();
                    this.enableRotate();
                }
            }
        } else {
            this.doRotateSame();
        }
    }

    private void playSound() {
        if (this.dataContainer.playSound.booleanValue()) {
            new PlaySound().start();
        }
    }

    private void doRotateSame() {
        this.checkLicense(this, true);
        this.lastIndex = 0;
        try {
            PreferLevel preferLevel = new PreferLevel(this.preferSameLevelDancer, this.licensed);
            RotateDialog rotateDialog = new RotateDialog((Frame)this, this, preferLevel);
            preferLevel = rotateDialog.getResult();
            if (preferLevel != null) {
                this.disableAll();
                this.sendRotateEvent(DancersSingleton.getInstance().getTotalDeuces() + 1, this.globalLevel);
                this.preferSameLevelDancer = preferLevel.isPrefer();
                DancersSingleton.getInstance().rotate(this.globalLevel, this.dataContainer.preferDancersOut, this.preferSameLevelDancer, this.dataContainer.couples, this.dataContainer.autoSplit);
                this.playSound();
                this.startShowDancers();
            }
        }
        catch (Exception exception) {
            this.logger.error("Oh my god", (Throwable)exception);
            JOptionPane.showMessageDialog(this, exception.getMessage(), this.getResource("SplitChainer.popup.error.title"), 0);
        }
        finally {
            this.enableScanner();
            this.enableRotate();
        }
    }

    private void doScannerInput(ActionEvent actionEvent) {
        if (actionEvent.getWhen() - this.lastWhen > (long)this.dataContainer.scannerTime2Restart.intValue()) {
            this.code = new StringBuilder();
        }
        this.lastWhen = actionEvent.getWhen();
        String string = actionEvent.getActionCommand();
        this.code.append(string.replaceAll("Scanner", ""));
        String string2 = DancersSingleton.getInstance().handleScanner(this.code.toString(), this.licensed);
        if (!string2.startsWith("--")) {
            if (!string2.startsWith("++")) {
                this.setDisplayString(string2);
            } else {
                if ("++rotateSame".equalsIgnoreCase(string2)) {
                    this.doRotateSame();
                }
                if ("++rotateOther".equalsIgnoreCase(string2)) {
                    this.doRotateOther();
                }
            }
        }
    }

    private void disableScanner() {
        this.menuScanner.setEnabled(false);
    }

    private void disableRotate() {
        this.menuRotate.setEnabled(false);
    }

    private void disableOpenTip() {
        if (this.openTipTimer != null) {
            this.openTipTimer.stop();
            this.openTipTimer = null;
        }
    }

    private void disableDancersDisplay() {
        this.stopDisplayLoop();
    }

    private void disableAll() {
        this.overviewActive = false;
        this.disableScanner();
        this.disableRotate();
        this.disableDancersDisplay();
        this.disableOpenTip();
        this.stopDisplayLoop();
        this.stopDefinitionLoop();
    }

    private void enableScanner() {
        this.menuScanner.setEnabled(true);
    }

    private void enableRotate() {
        this.menuRotate.setEnabled(true);
    }

    private Container removeOldScreen() {
        this.adjustMenuSquares();
        Container container = this.getContentPane();
        for (Component component : container.getComponents()) {
            if (!"displayPanel".equals(component.getName())) continue;
            container.remove(component);
        }
        return container;
    }

    @Override
    public void deuceComplete(Level level, Integer n) {
        this.globalLicenseCounter = n;
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
        String string = this.getResource("SplitChainer.title.last_was.text");
        String string2 = this.getResource("SplitChainer.title.first_tip.text");
        this.setTitleLine("     " + this.getResource("SplitChainer.title", new Object[]{n, simpleDateFormat.format(date), level.getName(), this.lastLevel != null ? string + " " + this.lastLevel.getName() : string2}));
        this.lastLevel = level;
        this.startShowDancers();
    }

    private void startShowDancers() {
        this.startDisplayLoop();
        this.displayCounter = 60;
        this.handleDisplay();
    }

    private void showMovingOpenTip() {
        Container container = this.removeOldScreen();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        Point point = this.getLocationOnScreen();
        if (Math.abs(point.x) < 5) {
            point.x = 0;
        }
        if (Math.abs(point.y) < 5) {
            point.y = 0;
        }
        this.logger.trace(point.toString());
        Dimension dimension = this.getScreenSize();
        this.logger.trace(dimension.toString());
        for (GraphicsDevice graphicsDevice : graphicsDeviceArray) {
            Rectangle rectangle = graphicsDevice.getDefaultConfiguration().getBounds();
            this.logger.trace(rectangle.toString());
            if (!rectangle.contains(point)) continue;
            dimension = new Dimension(rectangle.width, rectangle.height);
        }
        Random random = new Random();
        int n = this.getResourceInt("SplitChainer.opentip.width", 480);
        int n2 = this.getResourceInt("SplitChainer.opentip.height", 80);
        int n3 = dimension.height - n2 - 40;
        int n4 = random.nextInt(n3);
        int n5 = dimension.width - n;
        int n6 = random.nextInt(n5);
        String string = "" + n6 + "px:grow, " + n + "px, " + (n5 - n6) + "px:grow";
        String string2 = "" + n4 + "px:grow, " + n2 + "px, " + (n3 - n4) + "px:grow";
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout(string, string2));
        panelBuilder.getPanel().setName("displayPanel");
        panelBuilder.getPanel().setBackground(this.dataContainer.popupColor);
        panelBuilder.nextRow();
        panelBuilder.nextColumn();
        JLabel jLabel = new JLabel(this.getResource("SplitChainer.opentip.text"));
        jLabel.setIcon(new ImageIcon(this.bImage.getScaledInstance(n2, n2, 4)));
        jLabel.setBackground(this.dataContainer.popupColor);
        jLabel.setForeground(this.dataContainer.dancerPanelBackgroundColor);
        Font font = new Font("Dialog", 1, n2);
        panelBuilder.getPanel().setFont(font);
        jLabel.setFont(font);
        panelBuilder.add((Component)jLabel);
        container.add((Component)panelBuilder.getPanel(), "Center");
        this.validate();
        this.repaint();
    }

    private void showOpenTip() {
        this.disableAll();
        this.enableScanner();
        this.enableRotate();
        this.showMovingOpenTip();
        this.openTipTimer = new Timer(2000, this);
        this.openTipTimer.setActionCommand("opentipTimer");
        this.openTipTimer.setRepeats(true);
        this.openTipTimer.start();
    }

    private void sendViaUDP(String string) {
        try {
            DatagramSocket datagramSocket = new DatagramSocket(59876);
            datagramSocket.setBroadcast(true);
            DatagramPacket datagramPacket = new DatagramPacket(string.getBytes(), string.length());
            datagramPacket.setAddress(InetAddress.getByName(Constants.UDP_BROADCAST_ADDRESS_0));
            datagramPacket.setPort(Constants.UPD_SERVER_PORT);
            datagramSocket.send(datagramPacket);
            datagramPacket = new DatagramPacket(string.getBytes(), string.length());
            datagramPacket.setAddress(InetAddress.getByName(Constants.UDP_BROADCAST_ADDRESS_1));
            datagramPacket.setPort(Constants.UPD_SERVER_PORT);
            datagramSocket.send(datagramPacket);
            datagramSocket.close();
        }
        catch (UnknownHostException unknownHostException) {
            this.logger.error("Exception", (Throwable)unknownHostException);
        }
        catch (SocketException socketException) {
            this.logger.error("Exception", (Throwable)socketException);
        }
        catch (IOException iOException) {
            this.logger.error("Exception", (Throwable)iOException);
        }
        catch (Exception exception) {
            this.logger.error("Exception", (Throwable)exception);
        }
    }

    private void sendRotateEvent(Integer n, Level level) {
        XStream xStream = new XStream();
        xStream.processAnnotations(RotationEvent.class);
        RotationEvent rotationEvent = new RotationEvent(n, level);
        this.sendViaUDP(xStream.toXML((Object)rotationEvent));
    }

    private void sendDancerListViaUDP() {
        try {
            XStream xStream = new XStream();
            xStream.processAnnotations(Dancer.class);
            for (Dancer object : DancersSingleton.getInstance().getDisplayList()) {
                object.setJoinedWith(object.getPartner() != null ? "" + object.getPartner().getId() : "");
            }
            String string = xStream.toXML(DancersSingleton.getInstance().getDisplayList());
            for (Dancer dancer : DancersSingleton.getInstance().getDisplayList()) {
                dancer.setJoinedWith(null);
            }
            this.sendViaUDP(string);
        }
        catch (Exception exception) {
            this.logger.error("Exception", (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void handleDisplay() {
        Serializable serializable;
        Object object;
        Object object2;
        this.logger.info("handleDisplay");
        this.logger.info("display things");
        this.sendDancerListViaUDP();
        Container container = this.removeOldScreen();
        Vector<DisplayObject> vector = new Vector<DisplayObject>();
        for (Dancer graphicsDeviceArray2 : DancersSingleton.getInstance().getDisplayList()) {
            void n;
            object2 = "" + graphicsDeviceArray2.getDisplayName();
            object = graphicsDeviceArray2.getPartner() != null ? "" + graphicsDeviceArray2.getPartner().getDisplayName() : null;
            Object var7_9 = null;
            if ("OUT".equals(graphicsDeviceArray2.getSquareNumberOrOUT()) && graphicsDeviceArray2.getLevel().equals((Object)this.lastLevel)) {
                Color color = this.dataContainer.dancerOutAndSameLevelForegroundColor1;
            }
            DisplayObject displayObject = new DisplayObject((String)object2, (String)object, graphicsDeviceArray2.getSquareNumberOrOUT(), (Color)n);
            vector.add(displayObject);
        }
        Collections.sort(vector);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        object2 = this.getLocationOnScreen();
        if (Math.abs(((Point)object2).x) < 5) {
            ((Point)object2).x = 0;
        }
        if (Math.abs(((Point)object2).y) < 5) {
            ((Point)object2).y = 0;
        }
        this.logger.trace(((Point)object2).toString());
        object = this.getScreenSize();
        this.logger.trace(((Dimension)object).toString());
        for (GraphicsDevice graphicsDevice : graphicsDeviceArray) {
            serializable = graphicsDevice.getDefaultConfiguration().getBounds();
            this.logger.trace(serializable.toString());
            if (!serializable.contains((Point)object2)) continue;
            object = new Dimension(serializable.width, serializable.height);
        }
        this.logger.trace(((Dimension)object).toString());
        if (((Dimension)object).width / ((Dimension)object).height > 2) {
            ((Dimension)object).width /= 2;
        }
        int n = ((Dimension)object).height - 30;
        int n2 = ((Dimension)object).width - 20;
        int n3 = this.dataContainer.fontSize;
        int n4 = n / (n3 + 20);
        serializable = new Font("Courier", 1, n3);
        int n5 = (n2 - 10 - 10 * (this.dataContainer.numberOfColumns - 1)) / this.dataContainer.numberOfColumns;
        String string = "5px";
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.dataContainer.numberOfColumns; ++i) {
            stringBuilder.append(string).append(", ").append(n5).append("px:grow");
            string = ", 10px";
        }
        stringBuilder.append(", 5px");
        StringBuilder stringBuilder2 = new StringBuilder("5px");
        for (int i = 0; i < n4; ++i) {
            stringBuilder2.append(", " + (n3 + 20) + "px");
        }
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout(stringBuilder.toString(), stringBuilder2.toString()));
        panelBuilder.getPanel().setFont((Font)serializable);
        panelBuilder.getPanel().setName("displayPanel");
        panelBuilder.nextRow();
        panelBuilder.nextColumn();
        int n6 = n5 * 85 / 100;
        int n7 = n5 * 15 / 100;
        int n8 = 0;
        for (DisplayObject displayObject : vector) {
            if (n8 >= this.lastIndex && n8 < this.lastIndex + (panelBuilder.getRowCount() - 2) * this.dataContainer.numberOfColumns) {
                String string2 = displayObject.format();
                String string3 = displayObject.getSquare();
                PanelBuilder panelBuilder2 = new PanelBuilder(new FormLayout("l:" + n6 + "px:grow, r:" + n7 + "px", "" + (n3 + 20) + "px"));
                Color color = panelBuilder.getRow() % 2 == 0 ? this.dataContainer.dancerBackgroundColor1 : this.dataContainer.dancerBackgroundColor2;
                panelBuilder2.getPanel().setBackground(color);
                JLabel jLabel = new JLabel(string2);
                jLabel.setFont((Font)serializable);
                jLabel.setForeground(displayObject.getForeground());
                panelBuilder2.add((Component)jLabel);
                panelBuilder2.nextColumn();
                JLabel jLabel2 = new JLabel(string3);
                jLabel2.setFont((Font)serializable);
                panelBuilder2.add((Component)jLabel2);
                panelBuilder.add((Component)panelBuilder2.getPanel());
                if (panelBuilder.getRow() == panelBuilder.getRowCount() - 1) {
                    panelBuilder.nextRow(-panelBuilder.getRowCount() + 2);
                    panelBuilder.nextColumn(2);
                }
                panelBuilder.nextRow();
            }
            ++n8;
        }
        panelBuilder.getPanel().setBackground(this.dataContainer.dancerPanelBackgroundColor);
        container.add((Component)panelBuilder.getPanel(), "Center");
        this.validate();
        this.repaint();
        this.lastIndex = Math.min(n8, this.lastIndex + (panelBuilder.getRowCount() - 2) * this.dataContainer.numberOfColumns);
        if (this.lastIndex >= vector.size()) {
            this.lastIndex = 0;
        }
        if (this.lastIndex == 0 && this.displayCounter > 0) {
            --this.displayCounter;
            this.logger.info("counter=" + this.displayCounter);
            if (this.displayCounter == 0) {
                this.handleEndDisplay();
            }
        }
    }

    public static void main(String[] stringArray) {
        SplitChainer splitChainer = new SplitChainer();
        splitChainer.init();
        splitChainer.showMe();
    }

    private class DisplayObject
    implements Comparable<DisplayObject> {
        private String name;
        private String partner;
        private String square;
        private Color foreground = Color.black;

        public DisplayObject(String string, String string2, String string3, Color color) {
            this.setName(string);
            this.setPartner(string2);
            this.setSquare(string3);
            if (color != null) {
                this.foreground = color;
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getPartner() {
            return this.partner;
        }

        public void setPartner(String string) {
            this.partner = string;
        }

        public String getSquare() {
            return this.square;
        }

        public void setSquare(String string) {
            this.square = string;
        }

        private Color getForeground() {
            return this.foreground;
        }

        private void setForeground(Color color) {
            this.foreground = color;
        }

        @Override
        public int compareTo(DisplayObject displayObject) {
            return this.getName().compareTo(displayObject.getName());
        }

        public String format() {
            if (this.getPartner() != null && this.getPartner().length() > 0) {
                return this.getName() + " & " + this.getPartner();
            }
            return this.getName();
        }
    }

    private class PlaySound
    extends Thread
    implements LineListener {
        private boolean playCompleted;

        private PlaySound() {
        }

        @Override
        public void run() {
            String string = "/RotateSound" + ((SplitChainer)SplitChainer.this).dataContainer.soundFile + ".wav";
            try {
                Object object;
                URL uRL = null;
                if (((SplitChainer)SplitChainer.this).dataContainer.soundFile == 3) {
                    uRL = new File(((SplitChainer)SplitChainer.this).dataContainer.externSoundfile).toURI().toURL();
                } else {
                    uRL = this.getClass().getResource(string);
                    if (uRL == null) {
                        uRL = this.getClass().getResource("splitchainer.png");
                    }
                    SplitChainer.this.logger.trace("Resource is {}", (Object)uRL);
                    if (uRL.toString().startsWith("jar:")) {
                        object = ImagePathUtils.convert(uRL, string);
                        uRL = ((File)object).toURI().toURL();
                    }
                }
                object = AudioSystem.getAudioInputStream(uRL);
                AudioFormat audioFormat = ((AudioInputStream)object).getFormat();
                DataLine.Info info = new DataLine.Info(Clip.class, audioFormat);
                Clip clip = (Clip)AudioSystem.getLine(info);
                clip.addLineListener(this);
                clip.open((AudioInputStream)object);
                clip.start();
                while (!this.playCompleted) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                clip.close();
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                System.out.println("The specified audio file is not supported.");
                unsupportedAudioFileException.printStackTrace();
            }
            catch (LineUnavailableException lineUnavailableException) {
                System.out.println("Audio line for playing back is unavailable.");
                lineUnavailableException.printStackTrace();
            }
            catch (IOException iOException) {
                System.out.println("Error playing the audio file.");
                iOException.printStackTrace();
            }
        }

        @Override
        public void update(LineEvent lineEvent) {
            LineEvent.Type type = lineEvent.getType();
            if (type == LineEvent.Type.START) {
                SplitChainer.this.logger.trace("Playback started.");
            } else if (type == LineEvent.Type.STOP) {
                this.playCompleted = true;
                SplitChainer.this.logger.trace("Playback completed.");
            }
        }
    }

    private class MyDocumentListener
    implements DocumentListener {
        private JTextField textField1 = null;
        private JTextField textField2 = null;
        private JTextField textField3 = null;
        private JTextField textField4 = null;
        private JTextField textField5 = null;
        private JTextField textField6 = null;
        private JTextField textField7 = null;
        private JTextField textField8 = null;
        private JTextField textField9 = null;

        private MyDocumentListener(JTextField jTextField, JTextField jTextField2, JTextField jTextField3, JTextField jTextField4, JTextField jTextField5, JTextField jTextField6, JTextField jTextField7, JTextField jTextField8, JTextField jTextField9) {
            this.textField1 = jTextField;
            this.textField2 = jTextField2;
            this.textField3 = jTextField3;
            this.textField4 = jTextField4;
            this.textField5 = jTextField5;
            this.textField6 = jTextField6;
            this.textField7 = jTextField7;
            this.textField8 = jTextField8;
            this.textField9 = jTextField9;
        }

        private void doCheck(JTextField jTextField, JTextField[] jTextFieldArray) {
            if (jTextField.getText() != null) {
                String string = jTextField.getText().trim();
                for (JTextField jTextField2 : jTextFieldArray) {
                    if (jTextField2.getText() == null || !string.equals(jTextField2.getText())) continue;
                    jTextField.setBackground(Color.red);
                    jTextField2.setBackground(Color.red);
                }
            }
        }

        private void doCheck() {
            this.textField1.setBackground(Color.WHITE);
            this.textField2.setBackground(Color.WHITE);
            this.textField3.setBackground(Color.WHITE);
            this.textField4.setBackground(Color.WHITE);
            this.textField5.setBackground(Color.WHITE);
            this.textField5.setBackground(Color.WHITE);
            this.textField6.setBackground(Color.WHITE);
            this.textField7.setBackground(Color.WHITE);
            this.textField8.setBackground(Color.WHITE);
            this.textField9.setBackground(Color.WHITE);
            this.doCheck(this.textField1, new JTextField[]{this.textField2, this.textField3, this.textField4, this.textField5, this.textField6, this.textField7, this.textField8, this.textField9});
            this.doCheck(this.textField2, new JTextField[]{this.textField1, this.textField3, this.textField4, this.textField5, this.textField6, this.textField7, this.textField8, this.textField9});
            this.doCheck(this.textField3, new JTextField[]{this.textField1, this.textField2, this.textField4, this.textField5, this.textField6, this.textField7, this.textField8, this.textField9});
            this.doCheck(this.textField4, new JTextField[]{this.textField1, this.textField2, this.textField3, this.textField5, this.textField6, this.textField7, this.textField8, this.textField9});
            this.doCheck(this.textField5, new JTextField[]{this.textField1, this.textField2, this.textField3, this.textField4, this.textField6, this.textField7, this.textField8, this.textField9});
            this.doCheck(this.textField6, new JTextField[]{this.textField1, this.textField2, this.textField3, this.textField4, this.textField5, this.textField7, this.textField8, this.textField9});
            this.doCheck(this.textField7, new JTextField[]{this.textField1, this.textField2, this.textField3, this.textField4, this.textField5, this.textField6, this.textField8, this.textField9});
            this.doCheck(this.textField8, new JTextField[]{this.textField1, this.textField2, this.textField3, this.textField4, this.textField5, this.textField6, this.textField7, this.textField9});
            this.doCheck(this.textField9, new JTextField[]{this.textField1, this.textField2, this.textField3, this.textField4, this.textField5, this.textField6, this.textField7, this.textField8});
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.doCheck();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.doCheck();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.doCheck();
        }
    }
}

