/*
 * Decompiled with CFR 0.152.
 */
package de.ready.splitchainer.business;

import com.thoughtworks.xstream.XStream;
import de.ready.splitchainer.business.ComponentFactory;
import de.ready.splitchainer.business.Dancer;
import de.ready.splitchainer.business.DancerClassmemberRenderer;
import de.ready.splitchainer.business.DancerVisibleRenderer;
import de.ready.splitchainer.business.DancersStateRenderer;
import de.ready.splitchainer.business.DataContainer;
import de.ready.splitchainer.business.Gender;
import de.ready.splitchainer.business.IdSingleton;
import de.ready.splitchainer.business.Level;
import de.ready.splitchainer.business.Pair;
import de.ready.splitchainer.business.Square;
import de.ready.splitchainer.interfaces.AfterDeuceListener;
import de.ready.splitchainer.interfaces.Deuceable;
import de.ready.splitchainer.util.Matrix;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DancersSingleton
implements TableModelListener,
Deuceable {
    private final Logger logger = LoggerFactory.getLogger(DancersSingleton.class);
    private Vector<Dancer> dancers = new Vector();
    private Vector<Dancer> displayList = new Vector();
    private static DancersSingleton instance = null;
    private DancerTableModel tableModel = null;
    private AfterDeuceListener afterDeuceListener = null;
    private Integer totalDeuces = 0;
    private String rotateSameScancode = "999999";
    private String rotateOtherScancode = "999998";
    private String toMaleScancode = "999997";
    private String toFemaleScancode = "999996";
    private String toBothScancode = "999995";
    private String toJoinScancode = "999994";
    private String toSplitScancode = "999993";
    private String toLevelUpScancode = "999992";
    private String toLevelDownScancode = "999991";
    private File presentFile = null;
    private File actualFile = null;
    private Integer defaultShortcutNumber = 900000;
    private final int PRESENT_COL = 0;
    private final int NAME_COL = 1;
    private final int SUR_NAME_COL = 2;
    private final int CLUB_NAME_COL = 3;
    private final int LEVEL_COL = 4;
    private final int GENDER_COL = 5;
    private final int JOINED_COL = 6;
    private final int SCANCODE_COL = 7;
    private final int VISIBLE_COL = 8;
    private final int CLASSMEMBER_COL = 9;
    private ResourceBundle resources = ResourceBundle.getBundle("de.ready.splitchainer.business.DancersSingleton");
    private final int DEFAULT = 0;
    private final int TOMALE = 1;
    private final int TOFEMALE = 2;
    private final int TOBOTH = 3;
    private final int JOIN1 = 5;
    private Dancer join1Dancer = null;
    private final int JOIN2 = 6;
    private final int SPLIT = 7;
    private final int LEVELUP = 8;
    private final int LEVELDOWN = 9;
    private int commandCode = 0;

    private DancersSingleton() {
    }

    public DancersSingleton(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        this();
        this.rotateSameScancode = string;
        this.rotateOtherScancode = string2;
        this.toMaleScancode = string3;
        this.toFemaleScancode = string4;
        this.toBothScancode = string5;
        this.toJoinScancode = string6;
        this.toSplitScancode = string7;
        this.toLevelUpScancode = string8;
        this.toLevelDownScancode = string9;
    }

    public static DancersSingleton getInstance() {
        if (instance == null) {
            instance = new DancersSingleton();
        }
        return instance;
    }

    public static DancersSingleton getInstance(DataContainer dataContainer) {
        if (instance == null) {
            instance = new DancersSingleton(dataContainer.rotateSameScancode, dataContainer.rotateOtherScancode, dataContainer.toMaleScancode, dataContainer.toFemaleScancode, dataContainer.toBothScancode, dataContainer.toSplitScancode, dataContainer.toJoinScancode, dataContainer.toLevelUpScancode, dataContainer.toLevelDownScancode);
        }
        return instance;
    }

    public void clear() {
        this.dancers.clear();
    }

    public void setPresentFile(File file) {
        this.actualFile = file;
        this.presentFile = new File(file.getParent() + File.separator + "." + file.getName() + ".state");
    }

    private String streamify(String string) {
        String string2 = string;
        string2 = string2.replaceAll("\r", "");
        string2 = string2.replaceAll("\n      ", "\n");
        string2 = string2.replaceAll("\n     ", "\n");
        string2 = string2.replaceAll("\n    ", "\n");
        string2 = string2.replaceAll("\n   ", "\n");
        string2 = string2.replaceAll("\n  ", "\n");
        string2 = string2.replaceAll("\n ", "\n");
        string2 = string2.replaceAll("\n", "");
        string2 = string2 + "\n";
        return string2;
    }

    private String cleanTemporary(String string) {
        String[] stringArray = new String[]{"present", "pauses", "available", "hasPaused", "squareNumberOrOUT", "partnerName", "willDance", "numSelected", "numParticipated", "wasOut", "history", "partnerHistory", "squareHistory", "actualGender", "lastGender", "displayName"};
        String string2 = string;
        for (String string3 : stringArray) {
            String string4 = "<" + string3 + ">.*</" + string3 + ">";
            string2 = string2.replaceAll(string4, "");
        }
        return string2;
    }

    public void saveActual() {
        if (this.actualFile != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.actualFile);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "ISO-8859-1");
                XStream xStream = new XStream();
                xStream.processAnnotations(Dancer.class);
                String string = xStream.toXML((Object)IdSingleton.getInstance().getIdCounter());
                outputStreamWriter.write(this.streamify(string));
                for (Dancer dancer : DancersSingleton.getInstance().getDancers()) {
                    string = xStream.toXML((Object)dancer);
                    string = this.cleanTemporary(this.streamify(string));
                    outputStreamWriter.write(string);
                }
                ((Writer)outputStreamWriter).close();
                this.logger.info("File saved:  {}", (Object)this.actualFile.getAbsolutePath());
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.logger.error("Exception", (Throwable)fileNotFoundException);
            }
            catch (IOException iOException) {
                this.logger.error("Exception", (Throwable)iOException);
            }
            catch (Exception exception) {
                this.logger.error("Exception", (Throwable)exception);
            }
        }
    }

    public void savePresent() {
        if (this.presentFile != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.presentFile);
                XStream xStream = new XStream();
                xStream.processAnnotations(Dancer.class);
                String string = xStream.toXML(DancersSingleton.getInstance().getPresentDancers());
                fileOutputStream.write(string.getBytes());
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                this.logger.error("When writing presentFile");
            }
        }
    }

    public void saveAllFiles() {
        this.saveActual();
        this.savePresent();
    }

    public void setAfterDeuceListener(AfterDeuceListener afterDeuceListener) {
        this.afterDeuceListener = afterDeuceListener;
    }

    private void informListener(Level level, Integer n) {
        if (this.afterDeuceListener != null) {
            this.afterDeuceListener.deuceComplete(level, n);
        }
    }

    private boolean checkReserved(String string) {
        if (this.rotateSameScancode.equals(string)) {
            return false;
        }
        if (this.rotateOtherScancode.equals(string)) {
            return false;
        }
        if (this.toMaleScancode.equals(string)) {
            return false;
        }
        if (this.toFemaleScancode.equals(string)) {
            return false;
        }
        if (this.toBothScancode.equals(string)) {
            return false;
        }
        if (this.toJoinScancode.equals(string)) {
            return false;
        }
        if (this.toSplitScancode.equals(string)) {
            return false;
        }
        if (this.toLevelUpScancode.equals(string)) {
            return false;
        }
        return !this.toLevelDownScancode.equals(string);
    }

    public boolean isNameUsed(String string, Dancer dancer) {
        if (!this.checkReserved(string)) {
            return false;
        }
        Long l = -1L;
        if (dancer != null) {
            l = dancer.getId();
        }
        for (Dancer dancer2 : this.dancers) {
            if (dancer2.getId() == l || !dancer2.getGivenName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isShortCutUsed(String string, Dancer dancer) {
        if (!this.checkReserved(string)) {
            return false;
        }
        Long l = -1L;
        if (dancer != null) {
            l = dancer.getId();
        }
        for (Dancer dancer2 : this.dancers) {
            if (dancer2.getId() == l || !dancer2.getShortCut().equals(string)) continue;
            return true;
        }
        return false;
    }

    private void adjustDancerId(Dancer dancer) {
        if (dancer.getId() == null) {
            dancer.setId(IdSingleton.getInstance().nextVal());
            this.logger.trace("Initiing  " + dancer);
        }
        for (Dancer dancer2 : this.getDancers()) {
            if (dancer2.getId().longValue() != dancer.getId().longValue()) continue;
            this.logger.trace("Adjusting " + dancer);
            dancer.setId(IdSingleton.getInstance().nextVal());
            this.logger.trace("Adjusted  " + dancer);
            this.adjustDancerId(dancer);
            return;
        }
    }

    public void add(Dancer dancer) {
        if (!this.isNameUsed(dancer.getCompleteName(), dancer)) {
            if (dancer.getShortCut().length() == 0) {
                DancersSingleton dancersSingleton = this;
                Integer n = dancersSingleton.defaultShortcutNumber;
                Integer n2 = dancersSingleton.defaultShortcutNumber = Integer.valueOf(dancersSingleton.defaultShortcutNumber - 1);
                dancer.setShortCut("" + n);
            }
            this.adjustDancerId(dancer);
            this.dancers.add(dancer);
            Collections.sort(this.dancers);
            if (this.tableModel != null) {
                int n = this.dancers.indexOf(dancer);
                this.tableModel.fireTableRowsInserted(n, n);
            }
        }
    }

    public List<Dancer> getDancers() {
        return this.dancers;
    }

    public List<Dancer> getOverviewDancers() {
        Vector<Dancer> vector = new Vector<Dancer>();
        for (Dancer dancer : this.getDancers()) {
            if (!dancer.getAlwaysVisible().booleanValue() && !dancer.isPauses().booleanValue() && !dancer.isPresent().booleanValue()) continue;
            vector.add(dancer);
        }
        return vector;
    }

    public List<Dancer> getDisplayList() {
        return this.displayList;
    }

    public void fillAllDancerNames(JComboBox jComboBox) {
        jComboBox.removeAllItems();
        jComboBox.addItem(null);
        for (Dancer dancer : this.getDancers()) {
            jComboBox.addItem(new CBItem(dancer));
        }
        assert (jComboBox.getItemCount() == this.getDancers().size() + 1);
    }

    public void commit() {
        this.tableModel = null;
    }

    public JTable createTable() {
        String[] stringArray = new String[]{"table.header.present.size", "table.header.name.size", "table.header.surName.size", "table.header.clubName.size", "table.header.can_dance.size", "table.header.gender.size", "table.header.partner.size", "table.header.scancode.size", "table.header.visible.size", "table.header.classmember.size"};
        int[] nArray = new int[stringArray.length];
        int n = 0;
        for (String object2 : stringArray) {
            nArray[n++] = Integer.parseInt(DancersSingleton.getInstance().getResource(object2));
        }
        this.tableModel = new DancerTableModel();
        this.tableModel.addTableModelListener(this);
        JTable jTable = new JTable(this.tableModel);
        jTable.setRowSorter(new TableRowSorter<DancerTableModel>(this.tableModel));
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(nArray[0]);
        tableColumn.setCellRenderer(new DancersStateRenderer(this.getDancers()));
        tableColumn.setCellEditor(new DancerPresentEditor(new JCheckBox()));
        tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(nArray[1]);
        tableColumn = jTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(nArray[2]);
        tableColumn = jTable.getColumnModel().getColumn(3);
        tableColumn.setPreferredWidth(nArray[3]);
        tableColumn = jTable.getColumnModel().getColumn(6);
        JComboBox jComboBox = new JComboBox();
        DancersSingleton.getInstance().fillAllDancerNames(jComboBox);
        tableColumn.setCellEditor(new DisplayFittingGenderEditor(jComboBox));
        tableColumn.setPreferredWidth(nArray[6]);
        tableColumn = jTable.getColumnModel().getColumn(4);
        tableColumn.setPreferredWidth(nArray[4]);
        JComboBox jComboBox2 = new JComboBox();
        Level.fill(jComboBox2);
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox2));
        tableColumn = jTable.getColumnModel().getColumn(5);
        tableColumn.setPreferredWidth(nArray[5]);
        JComboBox jComboBox3 = new JComboBox();
        Gender.fill(jComboBox3);
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox3));
        tableColumn = jTable.getColumnModel().getColumn(7);
        tableColumn.setPreferredWidth(nArray[7]);
        tableColumn.setCellEditor(new DefaultCellEditor(ComponentFactory.hexadecimalInputField()));
        tableColumn = jTable.getColumnModel().getColumn(8);
        tableColumn.setPreferredWidth(nArray[8]);
        tableColumn.setCellRenderer(new DancerVisibleRenderer(this.getDancers()));
        tableColumn.setCellEditor(new DancerVisibleEditor(new JCheckBox()));
        tableColumn = jTable.getColumnModel().getColumn(9);
        tableColumn.setPreferredWidth(nArray[9]);
        tableColumn.setCellRenderer(new DancerClassmemberRenderer(this.getDancers()));
        tableColumn.setCellEditor(new DancerClassmemberEditor(new JCheckBox()));
        return jTable;
    }

    public void copyProperties(Dancer dancer) {
        for (Dancer dancer2 : this.dancers) {
            if (!dancer2.equals(dancer)) continue;
            Integer n = dancer2.copyProperties(dancer);
            this.totalDeuces = Math.max(this.totalDeuces, n != null ? n : 0);
        }
    }

    public void dancerChanged(Dancer dancer) {
        if (this.tableModel != null) {
            this.logger.trace("tableModel");
            this.tableModel.dancerChanged(dancer);
        }
    }

    public void removeDancer(int n) {
        Dancer dancer;
        Dancer dancer2 = this.dancers.get(n);
        String string = dancer2.getJoinedWith();
        if (string != null && string.length() > 0 && (dancer = this.findDancer(string)) != null) {
            dancer.setJoinedWith("");
        }
        this.dancers.remove(n);
        if (this.tableModel != null) {
            this.tableModel.fireTableRowsDeleted(n, n);
        }
        this.saveAllFiles();
    }

    public Dancer findDancer(int n) {
        return this.dancers.get(n);
    }

    public Dancer findDancer(String string) {
        for (Dancer dancer : this.getDancers()) {
            if (!dancer.getGivenName().equals(string)) continue;
            return dancer;
        }
        return null;
    }

    public Dancer findDancer(Long l) {
        if (l != null) {
            for (Dancer dancer : this.getDancers()) {
                if (dancer.getId().longValue() != l.longValue()) continue;
                return dancer;
            }
        }
        return null;
    }

    public int getAllPresent(Gender gender) {
        int n = 0;
        for (Dancer dancer : this.getDancers()) {
            if (dancer.isPresent() == null || !dancer.isPresent().booleanValue() || !gender.equals(dancer.getWishedGender())) continue;
            ++n;
        }
        return n;
    }

    public int getPresent() {
        int n = 0;
        for (Dancer dancer : this.getDancers()) {
            if (dancer.isPresent() == null || !dancer.isPresent().booleanValue()) continue;
            ++n;
        }
        return n;
    }

    public int getAvailable() {
        int n = 0;
        for (Dancer dancer : this.getDancers()) {
            if (dancer.isPresent() == null || !dancer.isPresent().booleanValue() || dancer.isPauses().booleanValue()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
    }

    private List<Dancer> getMatchingGender(Gender gender, Level level, Boolean bl) {
        Vector<Dancer> vector = new Vector<Dancer>();
        for (Dancer dancer : this.getDancers()) {
            if (!dancer.isMatching(level, gender, bl)) continue;
            vector.add(dancer);
        }
        return vector;
    }

    private List<Dancer> getMale(Level level) {
        return this.getMatchingGender(Gender.Beau, level, false);
    }

    private List<Dancer> getFemale(Level level) {
        return this.getMatchingGender(Gender.Belle, level, false);
    }

    private List<Dancer> getOnlyMale(Level level) {
        return this.getMatchingGender(Gender.Beau, level, true);
    }

    private List<Dancer> getOnlyFemale(Level level) {
        return this.getMatchingGender(Gender.Belle, level, true);
    }

    private List<Dancer> getOnlyBoth(Level level) {
        return this.getMatchingGender(Gender.BeauAndBelle, level, true);
    }

    private Dancer getClassmember(List<Dancer> list, Random random) {
        Dancer dancer = null;
        ArrayList<Dancer> arrayList = new ArrayList<Dancer>();
        for (Dancer dancer2 : list) {
            if (!dancer2.isClassmember()) continue;
            arrayList.add(dancer2);
        }
        if (arrayList.size() > 0 && arrayList.size() != list.size()) {
            dancer = (Dancer)arrayList.get(random.nextInt(arrayList.size()));
            list.remove(dancer);
        }
        return dancer;
    }

    private Dancer getOutDancer(List<Dancer> list, Random random) {
        Dancer dancer = null;
        ArrayList<Dancer> arrayList = new ArrayList<Dancer>();
        for (Dancer dancer2 : list) {
            if (!dancer2.isWasOut().booleanValue()) continue;
            arrayList.add(dancer2);
        }
        if (arrayList.size() > 0 && arrayList.size() != list.size()) {
            dancer = (Dancer)arrayList.get(random.nextInt(arrayList.size()));
            list.remove(dancer);
        }
        return dancer;
    }

    private Dancer getPriviligedDancer(List<Dancer> list, Random random) {
        Dancer dancer = this.getClassmember(list, random);
        if (dancer == null) {
            dancer = this.getOutDancer(list, random);
        }
        return dancer;
    }

    private Dancer deuce(List<Dancer> list, Double d, boolean bl, Level level, boolean bl2) {
        Random random = new Random(System.currentTimeMillis());
        Dancer dancer = this.getPriviligedDancer(list, random);
        if (dancer == null) {
            Double d2 = 0.0;
            Vector<DoubleRange> vector = new Vector<DoubleRange>();
            for (Dancer dancer2 : list) {
                Double d3 = dancer2.getWeight(d, bl, level, bl2);
                Double d4 = d2 + d3;
                DoubleRange doubleRange = new DoubleRange(d2, d4);
                vector.add(doubleRange);
                d2 = d2 + d3;
            }
            double d5 = (double)random.nextFloat() * d2;
            for (int i = 0; i < vector.size(); ++i) {
                if (!((DoubleRange)vector.get(i)).matches(d5)) continue;
                dancer = list.remove(i);
                break;
            }
        }
        if (dancer == null) {
            this.logger.trace("Did not find a dancer");
            int n = random.nextInt(list.size());
            dancer = list.remove(n);
        }
        dancer.setNotAvailable();
        this.logger.trace("Selected " + dancer);
        return dancer;
    }

    private Pair deuce(List<Pair> list) {
        Random random = new Random();
        random.setSeed(System.currentTimeMillis());
        int n = random.nextInt(list.size());
        return list.remove(n);
    }

    private Square ensureSquare(List<Square> list, int n) {
        Square square;
        if (list.size() == 0) {
            list.add(new Square(list.size() + 1, n));
        }
        if ((square = list.get(list.size() - 1)).isFull()) {
            list.add(new Square(list.size() + 1, n));
        }
        square = list.get(list.size() - 1);
        return square;
    }

    public List<Dancer> getPresentDancers() {
        Vector<Dancer> vector = new Vector<Dancer>();
        for (Dancer dancer : this.getDancers()) {
            if (dancer.isPresent() == null || !dancer.isPresent().booleanValue()) continue;
            vector.add(dancer);
        }
        return vector;
    }

    public void rotate(Level level, boolean bl, boolean bl2, int n, boolean bl3) {
        List<Dancer> list;
        int n2;
        Object object;
        boolean bl4;
        Object object222;
        List<Dancer> list3;
        Object object3;
        List<Dancer> list4;
        this.totalDeuces = this.totalDeuces + 1;
        Integer n3 = this.beforeDeuce(level);
        Integer n4 = n3 - n3 % (n * 2);
        List<Dancer> list5 = this.getOnlyMale(level);
        List<Dancer> list6 = this.getOnlyFemale(level);
        Random random = new Random(System.currentTimeMillis());
        while ((list4 = this.getOnlyBoth(level)).size() > 0) {
            int n5 = random.nextInt(list4.size());
            object3 = list4.remove(n5);
            int n6 = list5.size() - list6.size();
            ((Dancer)object3).changeGender(n6, random);
            if (((Dancer)object3).getGender().equals(Gender.Beau)) {
                list5.add((Dancer)object3);
                continue;
            }
            list6.add((Dancer)object3);
        }
        Vector<Object> vector = new Vector<Object>();
        object3 = new Vector();
        Vector<Pair> vector2 = new Vector<Pair>();
        Integer n7 = list5.size();
        Integer n8 = n7 - n7 % n;
        double d = n8.doubleValue() / n7.doubleValue();
        Integer n9 = list6.size();
        Integer n10 = n9 - n9 % n;
        double d2 = n10.doubleValue() / n9.doubleValue();
        while (this.getMale(level).size() > 0 && this.getFemale(level).size() > 0 && vector.size() + object3.size() < n4) {
            Dancer dancer = this.deuce(this.getMale(level), d, bl, level, bl2);
            vector.add(dancer);
            list3 = this.getFemale(level);
            if (list3.size() <= 0) continue;
            object222 = this.deuce(list3, d2, bl, level, bl2);
            this.logger.trace("Selected " + dancer.getDisplayName() + " and " + ((Dancer)object222).getDisplayName());
            object3.add(object222);
        }
        block2: do {
            bl4 = false;
            for (Object object222 : vector) {
                object = this.findDancer(((Dancer)object222).getPartnerId());
                if (object == null || object == null) continue;
                this.logger.trace("{} is chained with {}", (Object)((Dancer)object222).getDisplayName(), (Object)((Dancer)object).getDisplayName());
                if (!((Dancer)object).isPresent().booleanValue() || ((Dancer)object).isPauses().booleanValue() || object3.contains(object)) continue;
                this.logger.trace("{} is present but not dancing", (Object)((Dancer)object).getDisplayName());
                if (this.getMale(level).size() > 0) {
                    List<Dancer> list22 = this.getMale(level);
                    n2 = random.nextInt(list22.size());
                    list = list22.get(n2);
                    this.logger.trace("replacing {} with {}", (Object)((Dancer)object222).getDisplayName(), (Object)((Dancer)((Object)list)).getDisplayName());
                    vector.remove(object222);
                    vector.add(list);
                    bl4 = true;
                    continue block2;
                }
                this.logger.trace("Not enough males to replace {}", (Object)((Dancer)object222).getDisplayName());
            }
        } while (bl4);
        block4: do {
            bl4 = false;
            list3 = object3.iterator();
            while (list3.hasNext()) {
                object222 = (Dancer)list3.next();
                object = this.findDancer(((Dancer)object222).getPartnerId());
                if (object == null || object == null) continue;
                this.logger.trace("{} is chained with {}", (Object)((Dancer)object222).getDisplayName(), (Object)((Dancer)object).getDisplayName());
                if (!((Dancer)object).isPresent().booleanValue() || ((Dancer)object).isPauses().booleanValue() || vector.contains(object)) continue;
                this.logger.trace("{} is present but not dancing", (Object)((Dancer)object).getDisplayName());
                if (this.getFemale(level).size() > 0) {
                    List<Dancer> list2 = this.getFemale(level);
                    n2 = random.nextInt(list2.size());
                    list = list2.get(n2);
                    this.logger.trace("replacing {} with {}", (Object)((Dancer)object222).getDisplayName(), (Object)((Dancer)((Object)list)).getDisplayName());
                    object3.remove(object222);
                    object3.add(list);
                    bl4 = true;
                    continue block4;
                }
                this.logger.trace("Not enough females to replace {}", (Object)((Dancer)object222).getDisplayName());
            }
        } while (bl4);
        boolean bl5 = true;
        while (bl5) {
            object222 = null;
            bl5 = false;
            for (Dancer dancer : vector) {
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    list = (Dancer)iterator.next();
                    if (!((Dancer)((Object)list)).isJoinedWith(dancer, level)) continue;
                    object222 = new Pair(dancer, (Dancer)((Object)list));
                    break;
                }
                if (object222 == null) continue;
                break;
            }
            if (object222 == null) continue;
            vector2.add((Pair)object222);
            vector.remove(((Pair)object222).getDancerOne());
            object3.remove(((Pair)object222).getDancerTwo());
            bl5 = true;
        }
        int n11 = object3.size();
        object = new Matrix<Dancer, Integer>();
        while (vector.size() > 0) {
            int n5 = random.nextInt(vector.size());
            Dancer dancer = (Dancer)vector.remove(n5);
            list = object3.iterator();
            while (list.hasNext()) {
                Dancer dancer2 = (Dancer)list.next();
                ((Matrix)object).add(dancer, dancer2, dancer2.getWeight(dancer, n11));
            }
        }
        ((Matrix)object).maximize();
        for (Dancer dancer : ((Matrix)object).getKeys()) {
            list = ((Matrix)object).getMaximized(dancer);
            if (list.size() > 1) {
                System.out.println("This is an internal Error: Please contact bugs@SplitChainer.com and send this information " + list);
                System.exit(-1);
            }
            vector2.add(new Pair(dancer, (Dancer)list.get(0)));
        }
        Vector<Square> vector3 = new Vector<Square>();
        while (vector2.size() > 0) {
            Square square = this.ensureSquare(vector3, n);
            list = this.deuce(vector2);
            square.add((Pair)((Object)list));
        }
        Vector<Square> vector4 = new Vector<Square>();
        for (Square square : vector3) {
            if (square.isFull()) continue;
            vector4.add(square);
        }
        for (Square square : vector4) {
            this.logger.trace("removing not full square " + square.getSquareNumber());
            for (Pair pair : square.getTheSquare()) {
                for (Dancer dancer : pair.getDancers()) {
                    dancer.setSquareNumberOrOUT("OUT");
                }
            }
            vector3.remove(square);
        }
        for (Dancer dancer : this.getPresentDancers()) {
            this.displayList.add(dancer);
        }
        this.afterDeuce();
        if (bl3) {
            for (Dancer dancer : this.getPresentDancers()) {
                if (dancer.getPartnerId() == null) continue;
                Dancer dancer3 = this.findDancer(dancer.getPartnerId());
                if (dancer3 != null) {
                    dancer3.setPartnerId(null);
                }
                dancer.setPartnerId(null);
            }
        }
        this.savePresent();
        this.informListener(level, this.totalDeuces);
    }

    @Override
    public void afterDeuce() {
        for (Dancer dancer : this.dancers) {
            dancer.afterDeuce();
            if (!dancer.isPresent().booleanValue()) continue;
            this.logger.trace("after deuce {}", (Object)dancer.toString());
        }
    }

    @Override
    public Integer beforeDeuce(Level level) {
        Integer n = 0;
        this.displayList = new Vector();
        for (Dancer dancer : this.dancers) {
            n = n + dancer.beforeDeuce(level);
        }
        return n;
    }

    @Override
    public void deuce(Float f) {
        for (Dancer dancer : this.dancers) {
            dancer.deuce(f);
        }
    }

    private String getResource(String string) {
        return this.resources.getString(string);
    }

    private String getResource(String string, Object object) {
        return MessageFormat.format(this.resources.getString(string), object);
    }

    private String getResource(String string, Object object, Object object2) {
        return MessageFormat.format(this.resources.getString(string), object, object2);
    }

    public String handleScanner(String string, boolean bl) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("working on " + string);
        }
        if (this.rotateSameScancode.equals(string)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("returning \"++rotateSame\"");
            }
            return "++rotateSame";
        }
        if (this.rotateOtherScancode.equals(string)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("returning \"++rotateOther\"");
            }
            return "++rotateOther";
        }
        if (this.toMaleScancode.equals(string)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("returning \"--ChangeToMale\"");
            }
            this.commandCode = 1;
            return this.getResource("Advice.ChangeToBeau");
        }
        if (this.toFemaleScancode.equals(string)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("returning \"--ChangeToFemale\"");
            }
            this.commandCode = 2;
            return this.getResource("Advice.ChangeToBelle");
        }
        if (this.toBothScancode.equals(string)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("returning \"--ChangeToBoth\"");
            }
            this.commandCode = 3;
            return this.getResource("Advice.ChangeToBeauAndBelle");
        }
        if (this.toJoinScancode.equals(string)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("returning \"--ChangeToJoin\"");
            }
            this.commandCode = 5;
            return this.getResource("Advice.Chain1");
        }
        if (this.toSplitScancode.equals(string)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("returning \"--ChangeToSplit\"");
            }
            this.commandCode = 7;
            return this.getResource("Advice.Split");
        }
        if (this.toLevelUpScancode.equals(string)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("returning \"--ChangeToLevelUp\"");
            }
            this.commandCode = 8;
            return this.getResource("Advice.ChangeLevelUp");
        }
        if (this.toLevelDownScancode.equals(string)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("returning \"--ChangeToLevelDown\"");
            }
            this.commandCode = 9;
            return this.getResource("Advice.ChangeLevelDown");
        }
        String string2 = "-- Unknown: " + string;
        for (Dancer dancer : this.getDancers()) {
            if (!string.equalsIgnoreCase(dancer.getShortCut())) continue;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("found dancer " + dancer.getCompleteName());
            }
            switch (this.commandCode) {
                case 0: {
                    string2 = dancer.circulateThru();
                    this.dancerChanged(dancer);
                    this.savePresent();
                    break;
                }
                case 1: {
                    dancer.setGender(Gender.Beau);
                    string2 = this.getResource("Dancer.beau", dancer.getDisplayName());
                    this.saveActual();
                    this.commandCode = 0;
                    break;
                }
                case 2: {
                    dancer.setGender(Gender.Belle);
                    string2 = this.getResource("Dancer.belle", dancer.getDisplayName());
                    this.saveActual();
                    this.commandCode = 0;
                    break;
                }
                case 3: {
                    dancer.setGender(Gender.BeauAndBelle);
                    string2 = this.getResource("Dancer.beaubelle", dancer.getDisplayName());
                    this.saveActual();
                    this.commandCode = 0;
                    break;
                }
                case 5: {
                    this.join1Dancer = dancer;
                    string2 = this.getResource("Advice.Chain2");
                    this.commandCode = 6;
                    break;
                }
                case 6: {
                    if (!this.join1Dancer.getWishedGender().fits(dancer.getWishedGender())) {
                        string2 = this.getResource("Dancer.join.noFit.Gender", this.join1Dancer.getDisplayName(), dancer.getDisplayName());
                    } else {
                        Dancer dancer2;
                        if (dancer.equals(this.join1Dancer)) {
                            this.join1Dancer = null;
                            string2 = this.getResource("Dancer.join.same");
                            return string2;
                        }
                        if (dancer.getPartnerId() != null) {
                            dancer2 = this.findDancer(dancer.getPartnerId());
                            if (dancer2 != null) {
                                dancer2.setPartnerId(null);
                            }
                            dancer.setPartnerId(null);
                        }
                        if (this.join1Dancer.getPartner() != null) {
                            dancer2 = this.findDancer(this.join1Dancer.getPartnerId());
                            if (dancer2 != null) {
                                dancer2.setPartnerId(null);
                            }
                            this.join1Dancer.setPartnerId(null);
                        }
                        dancer.setPartnerId(this.join1Dancer.getId());
                        this.join1Dancer.setPartnerId(dancer.getId());
                        string2 = this.getResource("Dancer.joined", this.join1Dancer.getDisplayName(), dancer.getDisplayName());
                        this.saveActual();
                    }
                    this.commandCode = 0;
                    break;
                }
                case 7: {
                    if (dancer.getPartner() == null) {
                        string2 = this.getResource("Split.notJoined", dancer.getDisplayName());
                    } else {
                        string2 = this.getResource("Dancer.splitted", dancer.getDisplayName(), dancer.getPartner().getDisplayName());
                        dancer.getPartner().setPartner(null);
                        dancer.getPartner().setPartnerId(null);
                        dancer.setPartner(null);
                        dancer.setPartnerId(null);
                    }
                    this.saveActual();
                    this.commandCode = 0;
                    break;
                }
                case 8: {
                    dancer.setLevel(dancer.increaseLevel(bl));
                    string2 = this.getResource("Dancer.Level", dancer.getDisplayName(), (Object)dancer.getLevel());
                    this.saveActual();
                    this.commandCode = 0;
                    break;
                }
                case 9: {
                    dancer.setLevel(dancer.decreaseLevel(bl));
                    string2 = this.getResource("Dancer.Level", dancer.getDisplayName(), (Object)dancer.getLevel());
                    this.saveActual();
                    this.commandCode = 0;
                }
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("return " + string2);
        }
        return string2;
    }

    private List<Dancer> findDancers(List<Dancer> list, String string) {
        Vector<Dancer> vector = new Vector<Dancer>();
        for (Dancer dancer : list) {
            if (!string.equals(dancer.getDisplayName())) continue;
            vector.add(dancer);
        }
        return vector;
    }

    private void lengthenDisplayName(Dancer dancer) {
        String string = dancer.getDisplayName().replace(".", "");
        string = string + dancer.getCompleteName().replace(string, "").charAt(0);
        dancer.setDisplayName(string);
    }

    private boolean adjustNames(List<Dancer> list) {
        if (list.size() > 1) {
            for (int i = 0; i < list.size(); ++i) {
                this.lengthenDisplayName(list.get(i));
            }
            return true;
        }
        return false;
    }

    public void adjustDancerNames() {
        this.adjustDancerNames(this.getDancers());
    }

    public void adjustDancerNames(List<Dancer> list) {
        for (Dancer object : list) {
            object.setDisplayName(null);
        }
        boolean bl = true;
        block1: while (bl) {
            bl = false;
            for (Dancer dancer : list) {
                List<Dancer> list2 = this.findDancers(list, dancer.getDisplayName());
                if (!this.adjustNames(list2)) continue;
                bl = true;
                continue block1;
            }
        }
    }

    public Integer getTotalDeuces() {
        return this.totalDeuces;
    }

    private class DoubleRange {
        private Double lowerRange;
        private Double upperRange;
        private Double range;

        public DoubleRange(Double d, Double d2) {
            this.lowerRange = d;
            this.upperRange = d2;
            this.range = this.upperRange - this.lowerRange;
        }

        public boolean matches(Double d) {
            return this.lowerRange.compareTo(d) <= 0 && this.upperRange.compareTo(d) > 0;
        }

        public String toString() {
            return "lower=" + this.lowerRange + " upper=" + this.upperRange + " range=" + this.range;
        }
    }

    private class DancerClassmemberEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 20120120171600L;
        private final JCheckBox checkBox;

        public DancerClassmemberEditor(JCheckBox jCheckBox) {
            super(jCheckBox);
            this.checkBox = jCheckBox;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            int n3 = jTable.getRowSorter().convertRowIndexToModel(n);
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            Dancer dancer = DancersSingleton.getInstance().getDancers().get(n3);
            if (dancer.getClassmember() != null && dancer.getClassmember().booleanValue()) {
                this.checkBox.setBackground(Color.GREEN.darker().darker());
                this.checkBox.setForeground(Color.GREEN.darker().darker());
            } else {
                this.checkBox.setBackground(Color.RED.darker().darker());
                this.checkBox.setForeground(Color.RED.darker().darker());
            }
            return component;
        }

        @Override
        public Object getCellEditorValue() {
            return super.getCellEditorValue();
        }
    }

    private class DancerVisibleEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 20120120171600L;
        private final JCheckBox checkBox;

        public DancerVisibleEditor(JCheckBox jCheckBox) {
            super(jCheckBox);
            this.checkBox = jCheckBox;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            int n3 = jTable.getRowSorter().convertRowIndexToModel(n);
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            Dancer dancer = DancersSingleton.getInstance().getDancers().get(n3);
            if (dancer.getAlwaysVisible().booleanValue()) {
                this.checkBox.setBackground(Color.GREEN.darker().darker());
                this.checkBox.setForeground(Color.GREEN.darker().darker());
            } else {
                this.checkBox.setBackground(Color.RED.darker().darker());
                this.checkBox.setForeground(Color.RED.darker().darker());
            }
            return component;
        }

        @Override
        public Object getCellEditorValue() {
            return super.getCellEditorValue();
        }
    }

    private class DancerPresentEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 20120120171600L;
        private final JCheckBox checkBox;

        public DancerPresentEditor(JCheckBox jCheckBox) {
            super(jCheckBox);
            this.checkBox = jCheckBox;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            int n3 = jTable.getRowSorter().convertRowIndexToModel(n);
            Component component = super.getTableCellEditorComponent(jTable, false, false, n, n2);
            Dancer dancer = DancersSingleton.getInstance().getDancers().get(n3);
            if (dancer.isPauses().booleanValue()) {
                this.checkBox.setBackground(Color.BLUE.darker().darker());
                this.checkBox.setForeground(Color.BLUE.darker().darker());
            } else if (dancer.isPresent().booleanValue()) {
                this.checkBox.setBackground(Color.GREEN.darker().darker());
                this.checkBox.setForeground(Color.GREEN.darker().darker());
            } else {
                this.checkBox.setBackground(Color.RED.darker().darker());
                this.checkBox.setForeground(Color.RED.darker().darker());
            }
            return component;
        }

        @Override
        public Object getCellEditorValue() {
            return super.getCellEditorValue();
        }
    }

    private class DisplayFittingGenderEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 20120120171600L;
        private final JComboBox comboBox;

        public DisplayFittingGenderEditor(JComboBox jComboBox) {
            super(jComboBox);
            this.comboBox = jComboBox;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            int n3 = jTable.getRowSorter().convertRowIndexToModel(n);
            this.comboBox.removeAllItems();
            this.comboBox.addItem(null);
            Dancer dancer = (Dancer)DancersSingleton.this.dancers.get(n3);
            int n4 = 0;
            for (Dancer dancer2 : DancersSingleton.this.dancers) {
                if (n4 != n3 && dancer.getWishedGender().fits(dancer2.getWishedGender())) {
                    CBItem cBItem = new CBItem(dancer2);
                    this.comboBox.addItem(cBItem);
                    if (dancer2.equals(object)) {
                        this.comboBox.setSelectedItem(cBItem);
                    }
                }
                ++n4;
            }
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }
    }

    private class DancerTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 201201201733000L;
        private String[] headers = new String[]{"table.header.present.text", "table.header.name.text", "table.header.surName.text", "table.header.clubName.text", "table.header.can_dance.text", "table.header.gender.text", "table.header.partner.text", "table.header.scancode.text", "table.header.visible.text", "table.header.classmember.text"};

        public DancerTableModel() {
            int n = 0;
            for (String string : this.headers) {
                this.headers[n++] = DancersSingleton.getInstance().getResource(string);
            }
        }

        public void dancerChanged(Dancer dancer) {
            int n = this.findRow(dancer);
            DancersSingleton.this.logger.trace("dancerChanged " + n);
            this.fireTableRowsUpdated(n, n);
        }

        @Override
        public String getColumnName(int n) {
            return this.headers[n];
        }

        @Override
        public int getColumnCount() {
            return this.headers.length;
        }

        @Override
        public int getRowCount() {
            return DancersSingleton.this.dancers.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Dancer dancer = (Dancer)DancersSingleton.this.dancers.get(n);
            switch (n2) {
                case 0: {
                    return Boolean.FALSE;
                }
                case 1: {
                    return dancer.getGivenName();
                }
                case 2: {
                    return dancer.getSurName();
                }
                case 3: {
                    return dancer.getClubName();
                }
                case 4: {
                    return dancer.getLevel();
                }
                case 5: {
                    return dancer.getWishedGender();
                }
                case 6: {
                    if (dancer.getPartnerId() != null) {
                        DancersSingleton.this.logger.trace("partner : " + DancersSingleton.this.findDancer(dancer.getPartnerId()));
                    }
                    return dancer.getPartnerId() != null ? DancersSingleton.this.findDancer(dancer.getPartnerId()).getDisplayName() : "";
                }
                case 7: {
                    return dancer.getShortCut();
                }
                case 8: {
                    return dancer.getAlwaysVisible();
                }
                case 9: {
                    return dancer.getClassmember();
                }
            }
            return null;
        }

        private int findRow(Dancer dancer) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!((Dancer)DancersSingleton.this.dancers.get(i)).equals(dancer)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Dancer dancer = (Dancer)DancersSingleton.this.dancers.get(n);
            switch (n2) {
                case 0: {
                    dancer.circulateThru();
                    DancersSingleton.this.savePresent();
                    break;
                }
                case 1: {
                    dancer.setGivenName((String)object);
                    if (dancer.getPartnerId() == null) break;
                    this.fireTableCellUpdated(this.findRow(DancersSingleton.this.findDancer(dancer.getPartnerId())), 6);
                    break;
                }
                case 2: {
                    dancer.setSurName((String)object);
                    break;
                }
                case 3: {
                    dancer.setClubName((String)object);
                    break;
                }
                case 4: {
                    dancer.setLevel((Level)((Object)object));
                    break;
                }
                case 5: {
                    dancer.setWishedGender((Gender)object);
                    break;
                }
                case 6: {
                    Dancer dancer2;
                    if (object == null) {
                        Dancer dancer3 = DancersSingleton.this.findDancer(dancer.getPartnerId());
                        if (dancer3 != null) {
                            dancer3.setPartnerId(null);
                            this.fireTableCellUpdated(this.findRow(dancer3), 6);
                        }
                        dancer.setPartnerId(null);
                        break;
                    }
                    if (dancer.equals(((CBItem)object).getDancer())) break;
                    Dancer dancer4 = ((CBItem)object).getDancer();
                    DancersSingleton.this.logger.trace("Dancer o=" + dancer4);
                    if (dancer4 != null && dancer4.getPartnerId() != null) {
                        DancersSingleton.this.logger.trace("o has partner, id=" + dancer4.getPartnerId());
                        dancer2 = DancersSingleton.this.findDancer(dancer4.getPartnerId());
                        DancersSingleton.this.logger.trace("o's partner is " + dancer2);
                        if (dancer2 != null) {
                            dancer2.setPartnerId(null);
                            this.fireTableCellUpdated(this.findRow(dancer2), 6);
                        }
                        dancer4.setPartnerId(null);
                        this.fireTableCellUpdated(this.findRow(dancer4), 6);
                    }
                    if (dancer.getPartnerId() != null) {
                        dancer2 = DancersSingleton.this.findDancer(dancer.getPartnerId());
                        if (dancer2 != null) {
                            dancer2.setPartnerId(null);
                            this.fireTableCellUpdated(this.findRow(dancer2), 6);
                        }
                        dancer.setPartnerId(null);
                        this.fireTableCellUpdated(this.findRow(dancer), 6);
                    }
                    if (dancer4 == null) break;
                    DancersSingleton.this.logger.trace("Joining " + dancer + " with " + dancer4);
                    dancer.setPartnerId(dancer4.getId());
                    dancer4.setPartnerId(dancer.getId());
                    this.fireTableCellUpdated(this.findRow(dancer4), 6);
                    break;
                }
                case 7: {
                    dancer.setShortCut((String)object);
                    break;
                }
                case 8: {
                    dancer.setAlwaysVisible((Boolean)object);
                    break;
                }
                case 9: {
                    dancer.setClassmember((Boolean)object);
                }
            }
            this.fireTableChanged(new TableModelEvent(this, n, n, n2));
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            boolean bl = true;
            return bl;
        }
    }

    private class CBItem {
        private Dancer dancer;

        private CBItem(Dancer dancer) {
            this.dancer = dancer;
        }

        private Dancer getDancer() {
            return this.dancer;
        }

        public String toString() {
            return this.dancer.getDisplayName();
        }
    }
}

