/*
 * Decompiled with CFR 0.152.
 */
package de.ready.splitchainer.gui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.ready.splitchainer.business.ComponentFactory;
import de.ready.splitchainer.business.Dancer;
import de.ready.splitchainer.business.DancersSingleton;
import de.ready.splitchainer.business.Gender;
import de.ready.splitchainer.business.IdSingleton;
import de.ready.splitchainer.business.Level;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.NumberFormat;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;

public class DancerDialog
extends JDialog
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = 20120114171233L;
    private JFrame frame = null;
    private final JTextField dancersGivenName = ComponentFactory.inputField();
    private final JTextField dancersSurName = ComponentFactory.inputField();
    private final JTextField dancersClubname = ComponentFactory.inputField();
    private JTextField dancersShortCut = ComponentFactory.hexadecimalInputField();
    private JComboBox genderCB = new JComboBox();
    private JComboBox levelCB = new JComboBox();
    private JRadioButton alwaysVisible = new JRadioButton();
    private JRadioButton classmember = new JRadioButton();
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private final String okCommand = "okCommand";
    private final String cancelCommand = "cancelCommand";
    private Dancer actualDancer = null;
    private ResourceBundle resources = ResourceBundle.getBundle(DancerDialog.class.getName());

    public DancerDialog(JFrame jFrame) {
        super(jFrame, "A Dancer", true);
        this.frame = jFrame;
        this.initialize();
    }

    private void initialize() {
        MyDocumentListener myDocumentListener = new MyDocumentListener();
        AbstractDocument abstractDocument = (AbstractDocument)this.dancersGivenName.getDocument();
        abstractDocument.addDocumentListener(myDocumentListener);
        abstractDocument = (AbstractDocument)this.dancersShortCut.getDocument();
        abstractDocument.addDocumentListener(myDocumentListener);
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setGroupingUsed(false);
        numberFormat.setMaximumFractionDigits(0);
        numberFormat.setMinimumIntegerDigits(6);
        this.dancersShortCut.setText(numberFormat.format(IdSingleton.getInstance().nextVal()));
        this.okButton.setText(this.resources.getString("ok.text"));
        this.okButton.setActionCommand("okCommand");
        this.okButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton.setText(this.resources.getString("cancel.text"));
        this.cancelButton.setActionCommand("cancelCommand");
        this.cancelButton.addActionListener(this);
        this.dancersGivenName.addFocusListener(this);
        Gender.fill(this.genderCB);
        Level.fill(this.levelCB);
        this.alwaysVisible.setSelected(true);
        this.classmember.setSelected(false);
        this.setTitle(this.resources.getString("dialog.title"));
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("fill:100dlu, 4dlu, fill:100dlu:grow", "fill:pref, 2dlu, fill:pref, 2dlu, fill:pref, 2dlu, fill:pref, 2dlu, fill:pref, 2dlu, fill:pref, 2dlu, fill:pref, 2dlu, fill:pref"));
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        String string = this.resources.getString("givenName.text");
        panelBuilder.add((Component)new JLabel(string), cellConstraints.xywh(1, n, 1, 1));
        panelBuilder.add((Component)this.dancersGivenName, cellConstraints.xywh(3, n, 1, 1));
        string = this.resources.getString("surName.text");
        panelBuilder.add((Component)new JLabel(string), cellConstraints.xywh(1, n += 2, 1, 1));
        panelBuilder.add((Component)this.dancersSurName, cellConstraints.xywh(3, n, 1, 1));
        string = this.resources.getString("club.text");
        panelBuilder.add((Component)new JLabel(string), cellConstraints.xywh(1, n += 2, 1, 1));
        panelBuilder.add((Component)this.dancersClubname, cellConstraints.xywh(3, n, 1, 1));
        string = this.resources.getString("shortcut.text");
        panelBuilder.add((Component)new JLabel(string), cellConstraints.xywh(1, n += 2, 1, 1));
        panelBuilder.add((Component)this.dancersShortCut, cellConstraints.xywh(3, n, 1, 1));
        string = this.resources.getString("gender.text");
        panelBuilder.add((Component)new JLabel(string), cellConstraints.xywh(1, n += 2, 1, 1));
        panelBuilder.add((Component)this.genderCB, cellConstraints.xywh(3, n, 1, 1));
        string = this.resources.getString("level.text");
        panelBuilder.add((Component)new JLabel(string), cellConstraints.xywh(1, n += 2, 1, 1));
        panelBuilder.add((Component)this.levelCB, cellConstraints.xywh(3, n, 1, 1));
        string = this.resources.getString("visible.text");
        panelBuilder.add((Component)new JLabel(string), cellConstraints.xywh(1, n += 2, 1, 1));
        panelBuilder.add((Component)this.alwaysVisible, cellConstraints.xywh(3, n, 1, 1));
        string = this.resources.getString("classmember.text");
        panelBuilder.add((Component)new JLabel(string), cellConstraints.xywh(1, n += 2, 1, 1));
        panelBuilder.add((Component)this.classmember, cellConstraints.xywh(3, n, 1, 1));
        n += 2;
        PanelBuilder panelBuilder2 = new PanelBuilder(new FormLayout("4dlu:grow, fill:100dlu, 4dlu, fill:100dlu, 4dlu:grow", "10dlu, fill:pref"));
        panelBuilder2.add((Component)this.okButton, cellConstraints.xy(2, 2));
        panelBuilder2.add((Component)this.cancelButton, cellConstraints.xy(4, 2));
        PanelBuilder panelBuilder3 = new PanelBuilder(new FormLayout("10dlu,pref:grow,10dlu", "10dlu,fill:pref:grow, pref,10dlu"));
        panelBuilder3.nextLine();
        panelBuilder3.nextColumn();
        panelBuilder3.add((Component)panelBuilder.getPanel());
        panelBuilder3.nextLine();
        panelBuilder3.nextColumn();
        panelBuilder3.add((Component)panelBuilder2.getPanel());
        this.setContentPane(panelBuilder3.getPanel());
    }

    public void setDancer(Dancer dancer) {
        this.actualDancer = dancer;
        if (dancer == null) {
            this.dancersGivenName.setText("");
            this.genderCB.setSelectedIndex(0);
            this.levelCB.setSelectedIndex(0);
        } else {
            this.dancersGivenName.setText(dancer.getGivenName());
            this.dancersSurName.setText(dancer.getSurName());
            this.dancersClubname.setText(dancer.getClubName());
            this.dancersShortCut.setText(dancer.getShortCut());
            if (dancer.getWishedGender() != null) {
                this.genderCB.setSelectedIndex(dancer.getWishedGender().getGender() - 1);
            } else {
                this.genderCB.setSelectedIndex(0);
            }
            if (dancer.getLevel() != null) {
                this.levelCB.setSelectedIndex(dancer.getLevel().getCode() - 1);
            } else {
                this.levelCB.setSelectedIndex(0);
            }
            this.alwaysVisible.setSelected(dancer.getAlwaysVisible());
            if (dancer.getClassmember() != null) {
                this.classmember.setSelected(dancer.getClassmember());
            }
        }
    }

    public void popup() {
        this.pack();
        this.setLocationRelativeTo(this.frame);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("okCommand".equalsIgnoreCase(string)) {
            boolean bl = false;
            if (this.actualDancer == null) {
                this.actualDancer = new Dancer();
                bl = true;
            }
            this.actualDancer.setGivenName(this.dancersGivenName.getText().trim());
            this.actualDancer.setSurName(this.dancersSurName.getText().trim());
            this.actualDancer.setClubName(this.dancersClubname.getText().trim());
            this.actualDancer.setShortCut(this.dancersShortCut.getText().trim());
            this.actualDancer.setGender((Gender)this.genderCB.getSelectedItem());
            this.actualDancer.setLevel((Level)((Object)this.levelCB.getSelectedItem()));
            if (this.actualDancer.getId() == null) {
                this.actualDancer.setId(IdSingleton.getInstance().nextVal());
            }
            this.actualDancer.setAlwaysVisible(this.alwaysVisible.isSelected());
            if (bl) {
                DancersSingleton.getInstance().add(this.actualDancer);
            }
            DancersSingleton.getInstance().saveActual();
        }
        if ("cancelCommand".equalsIgnoreCase(string)) {
            // empty if block
        }
        this.dispose();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (DancersSingleton.getInstance().isNameUsed(this.dancersGivenName.getText(), this.actualDancer)) {
            this.dancersGivenName.setBackground(Color.RED);
        } else {
            this.dancersGivenName.setBackground(Color.WHITE);
        }
    }

    private class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        private void doCheck(DocumentEvent documentEvent) {
            String string;
            String string2 = DancerDialog.this.dancersGivenName.getText();
            if (string2 != null) {
                string2 = string2.trim();
            }
            if ((string = DancerDialog.this.dancersShortCut.getText()) != null) {
                string = string.trim();
            }
            if (string != null && string.length() > 0) {
                if (DancersSingleton.getInstance().isShortCutUsed(string, DancerDialog.this.actualDancer)) {
                    DancerDialog.this.dancersShortCut.setBackground(Color.RED);
                    DancerDialog.this.okButton.setEnabled(false);
                } else {
                    DancerDialog.this.dancersShortCut.setBackground(Color.WHITE);
                    DancerDialog.this.okButton.setEnabled(true);
                }
            } else {
                DancerDialog.this.dancersShortCut.setBackground(Color.RED);
                DancerDialog.this.okButton.setEnabled(false);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.doCheck(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.doCheck(documentEvent);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.doCheck(documentEvent);
        }
    }
}

