/*
 * Decompiled with CFR 0.152.
 */
package com.nexes.wizard;

import com.nexes.wizard.WizardController;
import com.nexes.wizard.WizardModel;
import com.nexes.wizard.WizardPanelDescriptor;
import de.schlichtherle.swing.EnhancedButton;
import de.schlichtherle.swing.EnhancedDialog;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public class Wizard
implements PropertyChangeListener {
    public static final int FINISH_RETURN_CODE = 0;
    public static final int CANCEL_RETURN_CODE = 1;
    public static final int ERROR_RETURN_CODE = 2;
    public static final String NEXT_BUTTON_ACTION_COMMAND = "NextButtonActionCommand";
    public static final String BACK_BUTTON_ACTION_COMMAND = "BackButtonActionCommand";
    public static final String CANCEL_BUTTON_ACTION_COMMAND = "CancelButtonActionCommand";
    private static final ResourceBundle resources = ResourceBundle.getBundle("com/nexes/wizard/Resources");
    public static final String DEFAULT_BACK_BUTTON_TEXT = resources.getString("backButton");
    public static final String DEFAULT_NEXT_BUTTON_TEXT = resources.getString("nextButton");
    public static final String DEFAULT_FINISH_BUTTON_TEXT = resources.getString("finishButton");
    public static final String DEFAULT_CANCEL_BUTTON_TEXT = resources.getString("cancelButton");
    private WizardModel wizardModel;
    private WizardController wizardController;
    private EnhancedDialog wizardDialog;
    private int returnCode;
    private JPanel cardPanel;
    private CardLayout cardLayout;
    private EnhancedButton backButton;
    private EnhancedButton nextButton;
    private EnhancedButton cancelButton;

    public Wizard() {
        this(new WizardModel(), (Frame)null);
    }

    public Wizard(Dialog dialog) {
        this(new WizardModel(), dialog);
    }

    public Wizard(Frame frame) {
        this(new WizardModel(), frame);
    }

    public Wizard(WizardModel wizardModel, Dialog dialog) {
        this.wizardDialog = new EnhancedDialog(dialog);
        this.wizardModel = wizardModel;
        this.initComponents();
    }

    public Wizard(WizardModel wizardModel, Frame frame) {
        this.wizardDialog = new EnhancedDialog(frame);
        this.wizardModel = wizardModel;
        this.initComponents();
    }

    public JDialog getDialog() {
        return this.wizardDialog;
    }

    public Component getOwner() {
        return this.wizardDialog.getOwner();
    }

    public void setTitle(String string) {
        this.wizardDialog.setTitle(string);
    }

    public String getTitle() {
        return this.wizardDialog.getTitle();
    }

    public void setModal(boolean bl) {
        this.wizardDialog.setModal(bl);
    }

    public boolean isModal() {
        return this.wizardDialog.isModal();
    }

    public int showModalDialog(JFrame jFrame) {
        this.wizardDialog.setLocationRelativeTo(jFrame);
        this.wizardDialog.setModal(true);
        this.wizardDialog.setVisible(true);
        return this.returnCode;
    }

    public WizardModel getModel() {
        return this.wizardModel;
    }

    public void registerWizardPanel(Object object, WizardPanelDescriptor wizardPanelDescriptor) {
        this.cardPanel.add(wizardPanelDescriptor.getPanelComponent(), object);
        wizardPanelDescriptor.setWizard(this);
        this.wizardModel.registerPanel(object, wizardPanelDescriptor);
        this.getDialog().pack();
    }

    public void setCurrentPanel(Object object) {
        WizardPanelDescriptor wizardPanelDescriptor;
        if (null == object) {
            this.close(2);
        }
        if (null != (wizardPanelDescriptor = this.wizardModel.getCurrentPanelDescriptor())) {
            wizardPanelDescriptor.aboutToHidePanel();
        }
        this.wizardModel.setCurrentPanel(object);
        this.wizardModel.getCurrentPanelDescriptor().aboutToDisplayPanel();
        this.cardLayout.show(this.cardPanel, object.toString());
        this.wizardModel.getCurrentPanelDescriptor().displayingPanel();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("currentPanelDescriptorProperty")) {
            this.wizardController.resetButtonsToPanelRules();
        } else if (propertyChangeEvent.getPropertyName().equals("nextButtonTextProperty")) {
            this.nextButton.setText(propertyChangeEvent.getNewValue().toString());
        } else if (propertyChangeEvent.getPropertyName().equals("backButtonTextProperty")) {
            this.backButton.setText(propertyChangeEvent.getNewValue().toString());
        } else if (propertyChangeEvent.getPropertyName().equals("cancelButtonTextProperty")) {
            this.cancelButton.setText(propertyChangeEvent.getNewValue().toString());
        } else if (propertyChangeEvent.getPropertyName().equals("nextButtonEnabledProperty")) {
            this.nextButton.setEnabled((Boolean)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getPropertyName().equals("backButtonEnabledProperty")) {
            this.backButton.setEnabled((Boolean)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getPropertyName().equals("cancelButtonEnabledProperty")) {
            this.cancelButton.setEnabled((Boolean)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getPropertyName().equals("nextButtonIconProperty")) {
            this.nextButton.setIcon((Icon)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getPropertyName().equals("backButtonIconProperty")) {
            this.backButton.setIcon((Icon)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getPropertyName().equals("cancelButtonIconProperty")) {
            this.cancelButton.setIcon((Icon)propertyChangeEvent.getNewValue());
        }
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    void close(int n) {
        this.returnCode = n;
        this.wizardDialog.setVisible(false);
    }

    private void initComponents() {
        this.wizardModel.addPropertyChangeListener(this);
        this.wizardController = new WizardController(this);
        this.wizardDialog.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JSeparator jSeparator = new JSeparator();
        Box box = new Box(2);
        this.cardPanel = new JPanel();
        this.cardPanel.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        this.cardLayout = new CardLayout();
        this.cardPanel.setLayout(this.cardLayout);
        this.backButton = new EnhancedButton();
        this.nextButton = new EnhancedButton();
        this.cancelButton = new EnhancedButton();
        this.backButton.setActionCommand(BACK_BUTTON_ACTION_COMMAND);
        this.nextButton.setActionCommand(NEXT_BUTTON_ACTION_COMMAND);
        this.cancelButton.setActionCommand(CANCEL_BUTTON_ACTION_COMMAND);
        this.backButton.addActionListener(this.wizardController);
        this.nextButton.addActionListener(this.wizardController);
        this.cancelButton.addActionListener(this.wizardController);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jSeparator, "North");
        box.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        box.add(this.backButton);
        box.add(Box.createHorizontalStrut(10));
        box.add(this.nextButton);
        box.add(Box.createHorizontalStrut(30));
        box.add(this.cancelButton);
        if (this.wizardModel.getBackButtonText() == null) {
            this.wizardModel.setBackButtonText(DEFAULT_BACK_BUTTON_TEXT);
        }
        if (this.wizardModel.getNextButtonText() == null) {
            this.wizardModel.setNextButtonText(DEFAULT_NEXT_BUTTON_TEXT);
        }
        if (this.wizardModel.getCancelButtonText() == null) {
            this.wizardModel.setCancelButtonText(DEFAULT_CANCEL_BUTTON_TEXT);
        }
        jPanel.add((Component)box, "East");
        this.wizardDialog.getContentPane().add((Component)jPanel, "South");
        this.wizardDialog.getContentPane().add((Component)this.cardPanel, "Center");
        this.wizardDialog.setDefaultButton(this.nextButton);
    }
}

