/*
 * Decompiled with CFR 0.152.
 */
package de.ready.barcode;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.Barcode;
import com.itextpdf.text.pdf.Barcode128;
import com.itextpdf.text.pdf.Barcode39;
import com.itextpdf.text.pdf.BarcodeCodabar;
import com.itextpdf.text.pdf.BarcodeDatamatrix;
import com.itextpdf.text.pdf.BarcodeEAN;
import com.itextpdf.text.pdf.BarcodeEANSUPP;
import com.itextpdf.text.pdf.BarcodeInter25;
import com.itextpdf.text.pdf.BarcodePDF417;
import com.itextpdf.text.pdf.BarcodePostnet;
import com.itextpdf.text.pdf.BarcodeQRCode;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BarCode {
    private float scaleToMatch(Image image, float f, float f2) {
        float f3 = 1.0f;
        float f4 = image.getWidth();
        float f5 = image.getHeight();
        f3 = Math.min(f2 / f5, f / f4);
        return f3 * 100.0f;
    }

    public void createA4(float f, float f2, float f3, float f4, float f5, float f6, int n, String string, String string2, String string3) throws DocumentException, IOException {
        this.createPage(PageSize.A4, f, f2, f3, f4, f5, f6, n, string, string2, string3);
    }

    public void createA3(float f, float f2, float f3, float f4, float f5, float f6, int n, String string, String string2, String string3) throws DocumentException, IOException {
        this.createPage(PageSize.A3, f, f2, f3, f4, f5, f6, n, string, string2, string3);
    }

    public void createA5(float f, float f2, float f3, float f4, float f5, float f6, int n, String string, String string2, String string3) throws DocumentException, IOException {
        this.createPage(PageSize.A5, f, f2, f3, f4, f5, f6, n, string, string2, string3);
    }

    public void createLetter(float f, float f2, float f3, float f4, float f5, float f6, int n, String string, String string2, String string3) throws DocumentException, IOException {
        this.createPage(PageSize.LETTER, f, f2, f3, f4, f5, f6, n, string, string2, string3);
    }

    public void createLetterLandscape(float f, float f2, float f3, float f4, float f5, float f6, int n, String string, String string2, String string3) throws DocumentException, IOException {
        this.createPage(PageSize.LETTER_LANDSCAPE, f, f2, f3, f4, f5, f6, n, string, string2, string3);
    }

    private void createPage(Rectangle rectangle, float f, float f2, float f3, float f4, float f5, float f6, int n, String string, String string2, String string3) throws DocumentException, IOException {
        Document document = new Document(rectangle);
        PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(string));
        document.open();
        PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
        float f7 = f2;
        float f8 = f;
        float f9 = f7;
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                document.newPage();
            }
            float f10 = PageSize.A4.getHeight() - f8;
            while (f10 > f) {
                Barcode128 barcode128 = new Barcode128();
                String string4 = string2 + String.format(string3, n2);
                barcode128.setCode(string4.toUpperCase());
                Image image = barcode128.createImageWithBarcode(pdfContentByte, null, null);
                float f11 = this.scaleToMatch(image, f3, f4);
                image.scaleAbsoluteHeight(f4);
                image.scaleAbsoluteWidth(f3);
                if (f10 - image.getScaledHeight() > f6) {
                    image.setAbsolutePosition(f9, f10 - image.getScaledHeight());
                    document.add((Element)image);
                    ++n2;
                }
                if (!((f9 += image.getScaledWidth() + f5) + image.getScaledWidth() + f5 > PageSize.A4.getWidth())) continue;
                f9 = f7;
                f10 -= image.getScaledHeight() + f6;
            }
        }
        document.close();
    }

    private static void createA4Template() throws DocumentException, IOException {
        Image image;
        BarcodeInter25 barcodeInter25;
        Document document = new Document(new Rectangle(PageSize.A4));
        PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream("A4Pdf.pdf"));
        document.open();
        PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
        float f = 30.0f;
        float f2 = PageSize.A4.getHeight() - 30.0f;
        int n = 1;
        while (f2 > 0.0f) {
            barcodeInter25 = new BarcodeInter25();
            barcodeInter25.setCode(String.format("%06d", n));
            image = barcodeInter25.createImageWithBarcode(pdfContentByte, null, null);
            image.scalePercent(88.0f);
            if (f2 - image.getScaledHeight() > 18.0f) {
                image.setAbsolutePosition(f, f2 - image.getScaledHeight());
                document.add((Element)image);
                ++n;
            }
            if (!((f += image.getScaledWidth() + 20.0f) + image.getScaledWidth() + 20.0f > PageSize.A4.getWidth())) continue;
            f = 30.0f;
            f2 -= image.getScaledHeight() + 18.0f;
        }
        document.newPage();
        f = 30.0f;
        f2 = PageSize.A4.getHeight() - 30.0f;
        while (f2 > 0.0f) {
            barcodeInter25 = new BarcodeInter25();
            barcodeInter25.setCode(String.format("%06d", n));
            image = barcodeInter25.createImageWithBarcode(pdfContentByte, null, null);
            image.scalePercent(88.0f);
            if (f2 - image.getScaledHeight() > 18.0f) {
                image.setAbsolutePosition(f, f2 - image.getScaledHeight());
                document.add((Element)image);
                ++n;
            }
            if (!((f += image.getScaledWidth() + 20.0f) + image.getScaledWidth() + 20.0f > PageSize.A4.getWidth())) continue;
            f = 30.0f;
            f2 -= image.getScaledHeight() + 18.0f;
        }
        document.close();
    }

    private static void createBarcodes() throws DocumentException, IOException {
        Document document = new Document(new Rectangle(340.0f, 842.0f));
        PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream("myPdf.pdf"));
        document.open();
        PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
        document.add((Element)new Paragraph("Barcode EAN.UCC-13"));
        BarcodeEAN barcodeEAN = new BarcodeEAN();
        barcodeEAN.setCode("4512345678906");
        document.add((Element)new Paragraph("default:"));
        document.add((Element)barcodeEAN.createImageWithBarcode(pdfContentByte, null, null));
        barcodeEAN.setGuardBars(false);
        document.add((Element)new Paragraph("without guard bars:"));
        document.add((Element)barcodeEAN.createImageWithBarcode(pdfContentByte, null, null));
        barcodeEAN.setBaseline(-1.0f);
        barcodeEAN.setGuardBars(true);
        document.add((Element)new Paragraph("text above:"));
        document.add((Element)barcodeEAN.createImageWithBarcode(pdfContentByte, null, null));
        barcodeEAN.setBaseline(barcodeEAN.getSize());
        document.add((Element)new Paragraph("Barcode UCC-12 (UPC-A)"));
        barcodeEAN.setCodeType(3);
        barcodeEAN.setCode("785342304749");
        document.add((Element)barcodeEAN.createImageWithBarcode(pdfContentByte, null, null));
        document.add((Element)new Paragraph("Barcode EAN.UCC-8"));
        barcodeEAN.setCodeType(2);
        barcodeEAN.setBarHeight(barcodeEAN.getSize() * 1.5f);
        barcodeEAN.setCode("34569870");
        document.add((Element)barcodeEAN.createImageWithBarcode(pdfContentByte, null, null));
        document.add((Element)new Paragraph("Barcode UPC-E"));
        barcodeEAN.setCodeType(4);
        barcodeEAN.setCode("03456781");
        document.add((Element)barcodeEAN.createImageWithBarcode(pdfContentByte, null, null));
        barcodeEAN.setBarHeight(barcodeEAN.getSize() * 3.0f);
        document.add((Element)new Paragraph("Bookland"));
        document.add((Element)new Paragraph("ISBN 0-321-30474-8"));
        barcodeEAN.setCodeType(1);
        barcodeEAN.setCode("9781935182610");
        BarcodeEAN barcodeEAN2 = new BarcodeEAN();
        barcodeEAN2.setCodeType(6);
        barcodeEAN2.setCode("55999");
        barcodeEAN2.setBaseline(-2.0f);
        BarcodeEANSUPP barcodeEANSUPP = new BarcodeEANSUPP((Barcode)barcodeEAN, (Barcode)barcodeEAN2);
        document.add((Element)barcodeEANSUPP.createImageWithBarcode(pdfContentByte, null, BaseColor.BLUE));
        document.add((Element)new Paragraph("Barcode 128"));
        Barcode128 barcode128 = new Barcode128();
        barcode128.setCode("0123456789 hello");
        document.add((Element)barcode128.createImageWithBarcode(pdfContentByte, null, null));
        barcode128.setCode("0123456789\uffffMy Raw Barcode (0 - 9)");
        barcode128.setCodeType(11);
        document.add((Element)barcode128.createImageWithBarcode(pdfContentByte, null, null));
        String string = "24132399420058289";
        String string2 = "3700000050";
        String string3 = "422356";
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('\u00ca');
        stringBuffer.append(string2);
        stringBuffer.append('\u00ca');
        stringBuffer.append(string3);
        Barcode128 barcode1282 = new Barcode128();
        barcode1282.setX(0.75f);
        barcode1282.setN(1.5f);
        barcode1282.setSize(10.0f);
        barcode1282.setTextAlignment(1);
        barcode1282.setBaseline(10.0f);
        barcode1282.setBarHeight(50.0f);
        barcode1282.setCode(stringBuffer.toString());
        document.add((Element)barcode1282.createImageWithBarcode(pdfContentByte, BaseColor.BLACK, BaseColor.BLUE));
        Barcode128 barcode1283 = new Barcode128();
        barcode1283.setCodeType(10);
        barcode1283.setCode("(01)00000090311314(10)ABC123(15)060916");
        document.add((Element)barcode1283.createImageWithBarcode(pdfContentByte, BaseColor.BLUE, BaseColor.BLACK));
        barcode1283.setCode("0191234567890121310100035510ABC123");
        document.add((Element)barcode1283.createImageWithBarcode(pdfContentByte, BaseColor.BLUE, BaseColor.RED));
        barcode1283.setCode("(01)28880123456788");
        document.add((Element)barcode1283.createImageWithBarcode(pdfContentByte, BaseColor.BLUE, BaseColor.BLACK));
        document.add((Element)new Paragraph("Barcode Interleaved 2 of 5"));
        BarcodeInter25 barcodeInter25 = new BarcodeInter25();
        barcodeInter25.setGenerateChecksum(true);
        barcodeInter25.setCode("41-1200076041-001");
        document.add((Element)barcodeInter25.createImageWithBarcode(pdfContentByte, null, null));
        barcodeInter25.setCode("411200076041001");
        document.add((Element)barcodeInter25.createImageWithBarcode(pdfContentByte, null, null));
        barcodeInter25.setCode("0611012345678");
        barcodeInter25.setChecksumText(true);
        document.add((Element)barcodeInter25.createImageWithBarcode(pdfContentByte, null, null));
        document.add((Element)new Paragraph("Barcode Postnet"));
        BarcodePostnet barcodePostnet = new BarcodePostnet();
        document.add((Element)new Paragraph("ZIP"));
        barcodePostnet.setCode("01234");
        document.add((Element)barcodePostnet.createImageWithBarcode(pdfContentByte, null, null));
        document.add((Element)new Paragraph("ZIP+4"));
        barcodePostnet.setCode("012345678");
        document.add((Element)barcodePostnet.createImageWithBarcode(pdfContentByte, null, null));
        document.add((Element)new Paragraph("ZIP+4 and dp"));
        barcodePostnet.setCode("01234567890");
        document.add((Element)barcodePostnet.createImageWithBarcode(pdfContentByte, null, null));
        document.add((Element)new Paragraph("Barcode Planet"));
        BarcodePostnet barcodePostnet2 = new BarcodePostnet();
        barcodePostnet2.setCode("01234567890");
        barcodePostnet2.setCodeType(8);
        document.add((Element)barcodePostnet2.createImageWithBarcode(pdfContentByte, null, null));
        document.add((Element)new Paragraph("Barcode 3 of 9"));
        Barcode39 barcode39 = new Barcode39();
        barcode39.setCode("ITEXT IN ACTION");
        document.add((Element)barcode39.createImageWithBarcode(pdfContentByte, null, null));
        document.add((Element)new Paragraph("Barcode 3 of 9 extended"));
        Barcode39 barcode392 = new Barcode39();
        barcode392.setCode("iText in Action");
        barcode392.setStartStopText(false);
        barcode392.setExtended(true);
        document.add((Element)barcode392.createImageWithBarcode(pdfContentByte, null, null));
        document.add((Element)new Paragraph("Codabar"));
        BarcodeCodabar barcodeCodabar = new BarcodeCodabar();
        barcodeCodabar.setCode("A123A");
        barcodeCodabar.setStartStopText(true);
        document.add((Element)barcodeCodabar.createImageWithBarcode(pdfContentByte, null, null));
        document.add((Element)new Paragraph("Barcode PDF417"));
        BarcodePDF417 barcodePDF417 = new BarcodePDF417();
        String string4 = "Call me Ishmael. Some years ago--never mind how long precisely --having little or no money in my purse, and nothing particular to interest me on shore, I thought I would sail about a little and see the watery part of the world.";
        barcodePDF417.setText(string4);
        Image image = barcodePDF417.getImage();
        image.scalePercent(50.0f, 50.0f * barcodePDF417.getYHeight());
        document.add((Element)image);
        document.add((Element)new Paragraph("Barcode Datamatrix"));
        BarcodeDatamatrix barcodeDatamatrix = new BarcodeDatamatrix();
        barcodeDatamatrix.generate(string4);
        image = barcodeDatamatrix.createImage();
        document.add((Element)image);
        document.add((Element)new Paragraph("Barcode QRCode"));
        BarcodeQRCode barcodeQRCode = new BarcodeQRCode("Moby Dick by Herman Melville", 1, 1, null);
        image = barcodeQRCode.getImage();
        document.add((Element)image);
        document.close();
    }

    private static void createHelloWorld() throws DocumentException, IOException {
        Document document = new Document();
        PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream("HelloWorld.pdf"));
        document.open();
        document.add((Element)new Paragraph("Hello World!"));
        document.close();
    }

    public static void main(String[] stringArray) throws DocumentException, IOException {
        BarCode.createHelloWorld();
        BarCode.createBarcodes();
        BarCode.createA4Template();
    }
}

