/*
 * Decompiled with CFR 0.152.
 */
package de.ready.callerdisplay;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import ca.odell.glazedlists.swing.DefaultEventComboBoxModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.FormLayout;
import de.ready.callerdisplay.business.CallerDisplayData;
import de.ready.splitchainer.business.DisplayPerson;
import de.ready.splitchainer.business.DisplayTypeEnum;
import de.ready.splitchainer.business.ImageTools;
import de.ready.splitchainer.gui.PatternFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class DisplayPersonDialog
extends JDialog
implements ActionListener {
    private ResourceBundle resources;
    private CallerDisplayData cdData;
    private DisplayPerson displayPerson;
    private JComboBox searchDatabaseComboBox;
    private ComboBoxModel comboBoxModel;
    private JTextField personNameText;
    private JTextField descriptionText;
    private JCheckBox descriptionButton;
    private JCheckBox nameButton;
    private JCheckBox symbolButton;
    private JToggleButton verticalButton;
    private JToggleButton horizontalButton;
    private JButton colorPicker;
    private JToggleButton crossButton;
    private boolean resultOK = false;

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("colorPicker".equals(string)) {
            this.colorPicker.setBackground(JColorChooser.showDialog(this, "Choose Color", this.colorPicker.getBackground()));
        }
        if ("comboBox".equals(string)) {
            this.displayPerson = (DisplayPerson)this.searchDatabaseComboBox.getSelectedItem();
            this.showPerson();
            System.out.println("Person: " + this.displayPerson + " " + this.displayPerson.getGender());
        }
        if ("clearButton".equals(string)) {
            this.displayPerson = new DisplayPerson();
            this.showPerson();
        }
        if ("okButton".equals(string)) {
            try {
                if (this.displayPerson.getPersonId() < 0L) {
                    this.displayPerson.setPersonId(this.cdData.newGlobalIdCounter());
                }
                boolean bl = this.nameButton.isSelected();
                boolean bl2 = this.descriptionButton.isSelected();
                boolean bl3 = this.symbolButton.isSelected();
                if (bl && !bl2 && !bl3) {
                    this.displayPerson.setDisplayType(DisplayTypeEnum.DISPLAY_NAME);
                }
                if (bl && bl2 && !bl3) {
                    this.displayPerson.setDisplayType(DisplayTypeEnum.DISPLAY_NAME_DESCRIPTION);
                }
                if (bl && bl2 && bl3) {
                    this.displayPerson.setDisplayType(DisplayTypeEnum.DISPLAY_NAME_DESCRIPTION_SYMBOLS);
                }
                if (bl && !bl2 && bl3) {
                    this.displayPerson.setDisplayType(DisplayTypeEnum.DISPLAY_NAME_SYMBOLS);
                }
                if (!bl && !bl2 && bl3) {
                    this.displayPerson.setDisplayType(DisplayTypeEnum.DISPLAY_SYMBOLS);
                }
                if (!bl && bl2 && !bl3) {
                    this.displayPerson.setDisplayType(DisplayTypeEnum.DISPLAY_DESCRIPTION);
                }
                if (!bl && bl2 && bl3) {
                    this.displayPerson.setDisplayType(DisplayTypeEnum.DISPLAY_DESCRIPTION_SYMBOLS);
                }
                if (!this.cdData.listen2Network.booleanValue()) {
                    this.displayPerson.setPersonName(this.personNameText.getText());
                }
                this.displayPerson.setPersonDescription(this.descriptionText.getText());
                this.displayPerson.setBackground(this.colorPicker.getBackground());
                BufferedImage bufferedImage = ImageTools.resize(ImageTools.getImage(PatternFactory.class, "vertical.png"), 15);
                BufferedImage bufferedImage2 = ImageTools.resize(ImageTools.getImage(PatternFactory.class, "horizontal.png"), 15);
                BufferedImage bufferedImage3 = ImageTools.combineImages(bufferedImage, bufferedImage2);
                if (this.verticalButton.isSelected()) {
                    this.displayPerson.setImageOne(bufferedImage);
                }
                if (this.horizontalButton.isSelected()) {
                    this.displayPerson.setImageOne(bufferedImage2);
                }
                if (this.crossButton.isSelected()) {
                    this.displayPerson.setImageOne(bufferedImage3);
                }
                this.displayPerson.persist(this.cdData.getFilename());
            }
            catch (Exception exception) {
                StringWriter stringWriter = new StringWriter();
                stringWriter.write("Unkown internal error: ");
                PrintWriter printWriter = new PrintWriter(stringWriter);
                exception.printStackTrace(printWriter);
                JOptionPane.showMessageDialog(this, stringWriter.getBuffer().toString(), "Error", 0);
            }
            this.setVisible(false);
            this.resultOK = true;
        }
        if ("cancelButton".equals(string)) {
            this.setVisible(false);
            this.resultOK = false;
        }
    }

    public boolean isResultOK() {
        return this.resultOK;
    }

    public DisplayPerson getDisplayPerson() {
        return this.displayPerson;
    }

    private void showPerson() {
        this.colorPicker.setBackground(this.displayPerson.getBackground());
        this.personNameText.setText(this.displayPerson.getPersonName());
        this.nameButton.setSelected(this.displayPerson.getDisplayType().equals((Object)DisplayTypeEnum.DISPLAY_NAME) || this.displayPerson.getDisplayType().equals((Object)DisplayTypeEnum.DISPLAY_NAME_DESCRIPTION) || this.displayPerson.getDisplayType().equals((Object)DisplayTypeEnum.DISPLAY_NAME_DESCRIPTION_SYMBOLS) || this.displayPerson.getDisplayType().equals((Object)DisplayTypeEnum.DISPLAY_NAME_SYMBOLS));
        this.descriptionButton.setSelected(this.displayPerson.getDisplayType().equals((Object)DisplayTypeEnum.DISPLAY_DESCRIPTION) || this.displayPerson.getDisplayType().equals((Object)DisplayTypeEnum.DISPLAY_NAME_DESCRIPTION) || this.displayPerson.getDisplayType().equals((Object)DisplayTypeEnum.DISPLAY_NAME_DESCRIPTION_SYMBOLS) || this.displayPerson.getDisplayType().equals((Object)DisplayTypeEnum.DISPLAY_DESCRIPTION_SYMBOLS));
        this.descriptionText.setText(this.displayPerson.getPersonDescription());
        this.symbolButton.setSelected(this.displayPerson.getDisplayType().equals((Object)DisplayTypeEnum.DISPLAY_SYMBOLS) || this.displayPerson.getDisplayType().equals((Object)DisplayTypeEnum.DISPLAY_NAME_SYMBOLS) || this.displayPerson.getDisplayType().equals((Object)DisplayTypeEnum.DISPLAY_NAME_DESCRIPTION_SYMBOLS) || this.displayPerson.getDisplayType().equals((Object)DisplayTypeEnum.DISPLAY_DESCRIPTION_SYMBOLS));
    }

    private JPanel createSymbolPanel() {
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("fill:pref, 1dlu, fill:pref, 1dlu, fill:pref, 1dlu, fill:pref, 1dlu:grow", "fill:pref"));
        try {
            this.colorPicker = new JButton();
            this.colorPicker.setActionCommand("colorPicker");
            this.colorPicker.addActionListener(this);
            panelBuilder.add((Component)this.colorPicker);
            panelBuilder.nextColumn(2);
            ButtonGroup buttonGroup = new ButtonGroup();
            BufferedImage bufferedImage = ImageTools.resize(PatternFactory.getImage(PatternFactory.Pattern.VERTICAL), 19);
            this.verticalButton = new JToggleButton(new ImageIcon(bufferedImage));
            buttonGroup.add(this.verticalButton);
            panelBuilder.add((Component)this.verticalButton);
            panelBuilder.nextColumn(2);
            BufferedImage bufferedImage2 = ImageTools.resize(PatternFactory.getImage(PatternFactory.Pattern.HORIZONTAL), 19);
            this.horizontalButton = new JToggleButton(new ImageIcon(bufferedImage2));
            buttonGroup.add(this.horizontalButton);
            panelBuilder.add((Component)this.horizontalButton);
            panelBuilder.nextColumn(2);
            BufferedImage bufferedImage3 = ImageTools.combineImages(bufferedImage, bufferedImage2);
            this.crossButton = new JToggleButton(new ImageIcon(bufferedImage3));
            buttonGroup.add(this.crossButton);
            panelBuilder.add((Component)this.crossButton);
            panelBuilder.nextColumn(2);
        }
        catch (Exception exception) {
            StringWriter stringWriter = new StringWriter();
            stringWriter.write("Unknown internal error: ");
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            JOptionPane.showMessageDialog(this, stringWriter.getBuffer().toString(), "Error", 0);
        }
        return panelBuilder.getPanel();
    }

    private JPanel createPersonPanel() {
        String string = "fill:pref, 5dlu, fill:pref:grow, 5dlu";
        String string2 = "fill:pref, 5dlu, fill:pref, 5dlu, fill:pref, 5dlu";
        if (!this.cdData.listen2Network.booleanValue()) {
            string2 = string2 + ", fill:pref, 5dlu";
        }
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout(string, string2));
        if (!this.cdData.listen2Network.booleanValue()) {
            BasicEventList basicEventList;
            ArrayList<DisplayPerson> arrayList = new ArrayList<DisplayPerson>();
            File file = new File(this.cdData.pathToData);
            for (File file2 : basicEventList = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.toLowerCase().endsWith(".xml");
                }
            })) {
                DisplayPerson displayPerson = new DisplayPerson();
                displayPerson.load(file2);
                arrayList.add(displayPerson);
            }
            BasicEventList basicEventList2 = new BasicEventList(arrayList);
            DefaultEventComboBoxModel defaultEventComboBoxModel = new DefaultEventComboBoxModel((EventList)basicEventList2);
            this.searchDatabaseComboBox = new JComboBox(defaultEventComboBoxModel);
            this.searchDatabaseComboBox.setActionCommand("comboBox");
            this.searchDatabaseComboBox.addActionListener(this);
            AutoCompleteSupport autoCompleteSupport = AutoCompleteSupport.install((JComboBox)this.searchDatabaseComboBox, (EventList)basicEventList2);
            autoCompleteSupport.setFilterMode(0);
            panelBuilder.nextColumn(2);
            panelBuilder.add((Component)this.searchDatabaseComboBox);
            panelBuilder.nextLine(2);
        }
        this.nameButton = new JCheckBox("Name");
        panelBuilder.add((Component)this.nameButton);
        panelBuilder.nextColumn(2);
        if (this.cdData.listen2Network.booleanValue()) {
            panelBuilder.add((Component)new JLabel(this.displayPerson.getPersonName()));
        } else {
            this.personNameText = new JTextField();
            panelBuilder.add((Component)this.personNameText);
        }
        panelBuilder.nextLine(2);
        this.descriptionButton = new JCheckBox("Description");
        panelBuilder.add((Component)this.descriptionButton);
        panelBuilder.nextColumn(2);
        this.descriptionText = new JTextField(20);
        panelBuilder.add((Component)this.descriptionText);
        panelBuilder.nextLine(2);
        this.symbolButton = new JCheckBox("Symbols");
        panelBuilder.add((Component)this.symbolButton);
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.createSymbolPanel());
        return panelBuilder.getPanel();
    }

    private String getResource(String string) {
        return this.resources.getString(string);
    }

    private JPanel createButtonPanel() {
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("5dlu:grow(0.5), fill:pref, 5dlu, fill:pref, 5dlu, fill:pref, 5dlu:grow(0.5)", "fill:pref"));
        panelBuilder.nextColumn();
        JButton jButton = new JButton(this.getResource("CallerDisplay.clear.text"));
        jButton.setActionCommand("clearButton");
        jButton.addActionListener(this);
        panelBuilder.add((Component)jButton);
        panelBuilder.nextColumn(2);
        JButton jButton2 = new JButton(this.getResource("CallerDisplay.cancel.text"));
        jButton2.setActionCommand("cancelButton");
        jButton2.addActionListener(this);
        panelBuilder.add((Component)jButton2);
        panelBuilder.nextColumn(2);
        JButton jButton3 = new JButton(this.getResource("CallerDisplay.ok.text"));
        jButton3.setActionCommand("okButton");
        jButton3.addActionListener(this);
        panelBuilder.add((Component)jButton3);
        this.getRootPane().setDefaultButton(jButton3);
        return panelBuilder.getPanel();
    }

    private void init() {
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("5dlu, fill:10dlu:grow, 5dlu", "5dlu, fill:pref, 5dlu:grow, fill:pref, 5dlu"));
        panelBuilder.nextLine();
        panelBuilder.nextColumn();
        panelBuilder.add((Component)this.createPersonPanel());
        panelBuilder.nextLine(2);
        panelBuilder.nextColumn();
        panelBuilder.add((Component)this.createButtonPanel());
        this.setContentPane(panelBuilder.getPanel());
        this.setSize(new Dimension(700, this.cdData.listen2Network != false ? 200 : 250));
        this.setAlwaysOnTop(true);
    }

    public DisplayPersonDialog(ResourceBundle resourceBundle, DisplayPerson displayPerson, CallerDisplayData callerDisplayData) {
        this.resources = resourceBundle;
        this.displayPerson = displayPerson;
        this.cdData = callerDisplayData;
        this.init();
        this.showPerson();
    }
}

