/*
 * Decompiled with CFR 0.152.
 */
package de.ready.license;

import de.ready.splitchainer.business.LicensedFunctions;
import de.ready.splitchainer.util.X500PrincipalHelper;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseManager;
import de.schlichtherle.license.LicenseParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseChecker {
    private static Logger logger = LoggerFactory.getLogger(LicenseChecker.class);
    public static LicensedFunctions licensedFunctions;

    public static boolean checkLicense(LicenseParam licenseParam) throws Exception {
        try {
            LicenseManager licenseManager = new LicenseManager(licenseParam);
            LicenseContent licenseContent = licenseManager.verify();
            X500PrincipalHelper x500PrincipalHelper = new X500PrincipalHelper(licenseContent.getHolder());
            logger.info("License for {} is valid until {}", (Object)x500PrincipalHelper.getCN(), (Object)licenseContent.getNotAfter());
            String string = x500PrincipalHelper.getSTREET();
            if (string != null && string.length() > 0) {
                licensedFunctions = new LicensedFunctions(Long.parseLong(string));
                logger.info("Licensetext: {}", (Object)x500PrincipalHelper.getCN());
            }
            return true;
        }
        catch (Exception exception) {
            licensedFunctions = new LicensedFunctions();
            return true;
        }
    }
}

