/*
 * Decompiled with CFR 0.152.
 */
package de.ready.splitchainer.business;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import de.ready.splitchainer.business.DancersSingleton;
import de.ready.splitchainer.business.Gender;
import de.ready.splitchainer.business.Level;
import de.ready.splitchainer.gui.DancerDialog;
import de.ready.splitchainer.interfaces.Deuceable;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="de.ready.splitchainer.business.Dancer")
public class Dancer
implements Deuceable,
Comparable<Dancer>,
MouseListener {
    @XStreamOmitField
    private static final Logger logger = LoggerFactory.getLogger(Dancer.class);
    @XStreamAlias(value="id")
    private Long id;
    @XStreamAlias(value="gender")
    private Gender gender;
    @XStreamAlias(value="name")
    private String givenName;
    @XStreamAlias(value="surName")
    private String surName;
    @XStreamAlias(value="clubName")
    private String clubName;
    @XStreamAlias(value="level")
    private Level level;
    @XStreamAlias(value="shortCut")
    private String shortCut;
    @XStreamAlias(value="joinedWith")
    private String joinedWith;
    @XStreamAlias(value="partnerId")
    private Long partnerId;
    @XStreamAlias(value="classmember")
    private Boolean classmember;
    private String displayName;
    @XStreamOmitField
    private Dancer partner;
    private Boolean present;
    private Boolean available;
    private Boolean pauses;
    private String squareNumberOrOUT;
    private Boolean wasOut;
    private Integer numSelected = 0;
    private Integer numParticipated = 0;
    private StringBuilder history = new StringBuilder();
    private Vector<String> partnerHistory = new Vector();
    private Vector<String> squareHistory = new Vector();
    @XStreamOmitField
    private ResourceBundle resources = ResourceBundle.getBundle(Dancer.class.getName());
    private Gender actualGender;
    private Gender lastGender;
    private Boolean alwaysVisible;
    @XStreamOmitField
    private ActionListener actionListener;
    @XStreamOmitField
    private Color presentColor = null;
    @XStreamOmitField
    private Color absentColor = null;
    @XStreamOmitField
    private Color pauseColor = null;
    private static final double SPEEDUP = 40.0;

    @Override
    public int compareTo(Dancer dancer) {
        return this.getGivenName().compareTo(dancer.getGivenName());
    }

    public Integer copyProperties(Dancer dancer) {
        if (this.equals(dancer)) {
            this.present = dancer.isPresent();
            this.pauses = dancer.pauses;
            this.wasOut = dancer.wasOut;
            this.numSelected = dancer.numSelected;
            this.numParticipated = dancer.numParticipated;
            this.history = dancer.history;
            this.partnerHistory = dancer.partnerHistory;
            this.lastGender = dancer.lastGender;
            this.actualGender = dancer.actualGender;
            this.squareHistory = dancer.squareHistory;
            this.classmember = dancer.classmember;
        }
        return dancer.numParticipated;
    }

    public boolean equals(Object object) {
        if (Dancer.class.isInstance(object)) {
            Dancer dancer = (Dancer)Dancer.class.cast(object);
            return this.getId().longValue() == dancer.getId().longValue();
        }
        return super.equals(object);
    }

    public String toString() {
        return "Dancer [givenName=" + this.givenName + ", surname=" + this.surName + ", clubname=" + this.clubName + ", gender=" + this.gender + ", actualGender=" + this.actualGender + ", id=" + this.id + ", joinedWith=" + this.joinedWith + ", level=" + (Object)((Object)this.level) + ", present=" + this.present + ", shortCut=" + this.shortCut + ", numSelected=" + this.numSelected + ", numParticipated=" + this.numParticipated + " history=" + this.getHistory() + " partnerHistory=" + this.partnerHistory + "]";
    }

    private void setForegroundColor(JLabel jLabel, boolean bl) {
        Color color = this.isPresent().booleanValue() ? (this.isPauses().booleanValue() ? this.pauseColor : this.presentColor) : this.absentColor;
        jLabel.setForeground(bl ? color.darker() : color);
        jLabel.setBackground(color.brighter().brighter());
    }

    private void setForegroundColor(JLabel jLabel) {
        this.setForegroundColor(jLabel, false);
    }

    public JLabel createOverviewLabel(Color color, Color color2, Color color3, ActionListener actionListener, boolean bl) {
        String string = this.getDisplayName().trim();
        String string2 = "";
        if (bl) {
            if (Gender.Beau.equals(this.getWishedGender())) {
                string2 = "/";
            }
            if (Gender.BeauAndBelle.equals(this.getWishedGender())) {
                string2 = "#";
            }
            if (Gender.Belle.equals(this.getWishedGender())) {
                string2 = "+";
            }
        }
        JLabel jLabel = new JLabel(string2 + string);
        jLabel.setToolTipText(this.getCompleteName());
        this.presentColor = color;
        this.absentColor = color2;
        this.pauseColor = color3;
        this.setForegroundColor(jLabel);
        jLabel.addMouseListener(this);
        this.actionListener = actionListener;
        if (this.classmember != null && this.classmember.booleanValue()) {
            this.presentColor.brighter().brighter();
        }
        return jLabel;
    }

    public JLabel createPresentLabel(boolean bl) {
        String string = "";
        if (bl) {
            if (Gender.Beau.equals(this.getWishedGender())) {
                string = "/";
            }
            if (Gender.BeauAndBelle.equals(this.getWishedGender())) {
                string = "#";
            }
            if (Gender.Belle.equals(this.getWishedGender())) {
                string = "+";
            }
        }
        String string2 = this.getDisplayName().trim();
        JLabel jLabel = new JLabel(string + this.getLevel().getName().replace(Level.MAINSTREAM.getName(), "MS") + " " + string2);
        jLabel.setToolTipText(this.getCompleteName());
        jLabel.setForeground(Color.decode("#00FF00"));
        return jLabel;
    }

    public void setSelected() {
        this.numSelected = this.getNumSelected() + 1;
        this.wasOut = Boolean.FALSE;
        this.getHistory().append("I");
    }

    public void setNotSelected() {
        this.squareNumberOrOUT = "OUT";
        this.setPartner(null);
        this.wasOut = Boolean.TRUE;
        this.getHistory().append("O");
    }

    public void setNotAvailable() {
        this.available = Boolean.FALSE;
    }

    private Integer getNumParticipated() {
        if (this.numParticipated == null) {
            this.numParticipated = 0;
        }
        return this.numParticipated;
    }

    private Integer getNumSelected() {
        if (this.numSelected == null) {
            this.numSelected = 0;
        }
        return this.numSelected;
    }

    public Boolean isWasOut() {
        if (this.wasOut == null) {
            this.wasOut = Boolean.FALSE;
        }
        return this.wasOut;
    }

    public boolean isClassmember() {
        return this.classmember != null && this.classmember != false;
    }

    public Double getWeight(Double d, boolean bl, Level level, boolean bl2) {
        assert (!this.isClassmember());
        assert (!this.isWasOut().booleanValue());
        Double d2 = 1.0;
        if (this.getNumParticipated() > 0 && this.getNumSelected() > 0) {
            double d3 = d * (1.0 - this.getNumSelected().doubleValue() / this.getNumParticipated().doubleValue());
            double d4 = (d3 *= 40.0) > 0.0 ? 1.0 : -1.0;
            d3 *= d3;
            d3 *= d3;
            double d5 = bl ? (this.isWasOut().booleanValue() ? 1600.0 : 1.0) : 1.0;
            d2 = new Double(1.0 + d5 * Math.max(-1.0, d3 *= d4));
            d2 = d2 * this.getLevel().preferFactor(level, bl2);
        }
        logger.trace("getWeight: givenName={} weight={}", (Object)this.getGivenName(), (Object)d2);
        return d2;
    }

    public Integer getWeight(Dancer dancer, Integer n) {
        Integer n2 = 0;
        if (this.partnerHistory != null && this.partnerHistory.size() > 0) {
            int n3;
            int n4 = this.partnerHistory.size() - 1;
            for (int i = n3 = Math.max(0, n4 - (n - 1)); i <= n4; ++i) {
                if (this.partnerHistory.get(i) == null || dancer.getId().longValue() != Long.valueOf(this.partnerHistory.get(i)).longValue()) continue;
                n2 = -((int)Math.ceil(Math.pow(n - (n4 - i), Math.log(n.intValue()))));
            }
            if (logger.isTraceEnabled()) {
                logger.trace(dancer.getDisplayName() + "-" + this.getDisplayName() + "= " + n2 + " " + n + " {} {} ", (Object)n3, (Object)n4);
            }
        }
        return n2;
    }

    public boolean isMatching(Level level, Gender gender, boolean bl) {
        return this.willParticipate() && this.canDanceLevel(level) && (bl ? this.getGender().equals(gender) : this.getGender().isOf(gender));
    }

    @Override
    public void afterDeuce() {
        if (this.isPresent().booleanValue()) {
            this.numParticipated = this.getNumParticipated() + 1;
            if ("OUT".equals(this.squareNumberOrOUT)) {
                this.setNotSelected();
            } else {
                this.setSelected();
            }
        }
        if (this.isPauses().booleanValue()) {
            this.squareNumberOrOUT = "OFF";
        }
        this.pauses = Boolean.FALSE;
        if (this.partnerHistory == null) {
            this.partnerHistory = new Vector();
        }
        if (this.getPartner() != null) {
            this.partnerHistory.add(this.getPartner().getId().toString());
        } else {
            this.partnerHistory.add(null);
        }
        this.getSquareHistory().add(this.getSquareNumberOrOUT());
    }

    public boolean willParticipate() {
        return this.isPresent() != false && this.available != false;
    }

    @Override
    public Integer beforeDeuce(Level level) {
        this.setSquareNumberOrOUT("OUT");
        if (this.getClassmember() != null && this.getClassmember().booleanValue()) {
            this.numParticipated = 0;
            this.numSelected = 0;
        }
        if (this.isPresent().booleanValue()) {
            this.available = Boolean.TRUE;
        }
        if (this.isPauses().booleanValue()) {
            this.available = Boolean.FALSE;
        }
        this.setPartner(null);
        this.lastGender = this.actualGender;
        this.actualGender = !Gender.BeauAndBelle.equals(this.getWishedGender()) ? this.getGender() : null;
        if (level.lessOrEqual(this.getLevel())) {
            return this.willParticipate() ? 1 : 0;
        }
        return 0;
    }

    private ResourceBundle getResources() {
        if (this.resources == null) {
            this.resources = ResourceBundle.getBundle(Dancer.class.getName());
        }
        return this.resources;
    }

    private String getResource(String string, Object object) {
        return MessageFormat.format(this.getResources().getString(string), object);
    }

    private String getResource(String string, Object object, Object object2) {
        return MessageFormat.format(this.getResources().getString(string), object, object2);
    }

    public String circulateThru() {
        String string = "";
        if (this.isPresent().booleanValue()) {
            if (this.isPauses().booleanValue()) {
                this.setPresent(Boolean.FALSE);
                string = this.getResource("Dancer.absent", this.getGivenName());
            } else {
                this.setPauses(Boolean.TRUE);
                string = this.getResource("Dancer.pauses", this.getGivenName());
            }
        } else {
            this.setPresent(Boolean.TRUE);
            string = this.getPartnerId() != null ? this.getResource("Dancer.present_chained", this.getDisplayName(), DancersSingleton.getInstance().findDancer(this.getPartnerId()).getDisplayName()) : this.getResource("Dancer.present_split", this.getDisplayName());
        }
        return string;
    }

    @Override
    public void deuce(Float f) {
    }

    public boolean isJoinedWith(Dancer dancer, Level level) {
        return this.getPartnerId() != null && this.getPartnerId().equals(dancer.getId());
    }

    public boolean canDanceLevel(Level level) {
        return level.lessOrEqual(this.level);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public Level increaseLevel(boolean bl) {
        return this.getLevel().increaseLevel(bl);
    }

    public Level decreaseLevel(boolean bl) {
        return this.getLevel().decreaseLevel(bl);
    }

    public void changeGender(int n, Random random) {
        if (Gender.BeauAndBelle.equals(this.gender)) {
            if (n > 0) {
                this.actualGender = Gender.Belle;
            }
            if (n < 0) {
                this.actualGender = Gender.Beau;
            }
            if (n == 0) {
                this.actualGender = random.nextBoolean() ? Gender.Beau : Gender.Belle;
            }
        } else {
            throw new RuntimeException("Changing a fixed Gender on " + this.getGivenName());
        }
    }

    public Gender getWishedGender() {
        return this.gender;
    }

    public void setWishedGender(Gender gender) {
        this.gender = gender;
    }

    public Gender getGender() {
        if (this.actualGender != null) {
            return this.actualGender;
        }
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String string) {
        this.givenName = string;
    }

    public String getDisplayName() {
        return this.displayName == null ? this.getGivenName() : this.displayName + ".";
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public String getClubName() {
        return this.clubName;
    }

    public void setClubName(String string) {
        this.clubName = string;
    }

    public String getSurName() {
        return this.surName;
    }

    public void setSurName(String string) {
        this.surName = string;
    }

    public String getFullName() {
        return this.getGivenName() + " " + (this.getSurName() != null ? this.getSurName() : "-");
    }

    public String getCompleteName() {
        return this.getGivenName() + " " + (this.getSurName() != null ? this.getSurName() : "-") + " " + (this.getClubName() != null ? this.getClubName() : "-") + " " + this.getLevel().getName();
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public Boolean isPresent() {
        if (this.present == null) {
            this.present = Boolean.FALSE;
        }
        return this.present;
    }

    public void setPresent(Boolean bl) {
        this.present = bl;
        this.pauses = this.isPresent() != false ? Boolean.FALSE : Boolean.FALSE;
    }

    public String getShortCut() {
        if (this.shortCut == null) {
            this.shortCut = "";
        }
        return this.shortCut;
    }

    public void setShortCut(String string) {
        this.shortCut = string;
    }

    public Dancer getPartner() {
        return this.partner;
    }

    public void setPartner(Dancer dancer) {
        this.partner = dancer;
    }

    public Long getPartnerId() {
        return this.partnerId;
    }

    public void setPartnerId(Long l) {
        this.partnerId = l;
    }

    @Deprecated
    public String getJoinedWith() {
        return this.joinedWith;
    }

    @Deprecated
    public void setJoinedWith(String string) {
        this.joinedWith = string;
    }

    public String getSquareNumberOrOUT() {
        return this.squareNumberOrOUT;
    }

    public void setSquareNumberOrOUT(String string) {
        this.squareNumberOrOUT = string;
    }

    public void setPauses(Boolean bl) {
        this.pauses = bl;
    }

    public Boolean isPauses() {
        if (this.pauses == null) {
            this.pauses = Boolean.FALSE;
        }
        return this.pauses;
    }

    private StringBuilder getHistory() {
        if (this.history == null) {
            this.history = new StringBuilder();
        }
        return this.history;
    }

    public Vector<String> getPartnerHistory() {
        return this.partnerHistory;
    }

    public Boolean getAlwaysVisible() {
        if (this.alwaysVisible == null) {
            this.alwaysVisible = Boolean.TRUE;
        }
        return this.alwaysVisible;
    }

    public void setAlwaysVisible(Boolean bl) {
        this.alwaysVisible = bl;
    }

    public Boolean getClassmember() {
        return this.classmember;
    }

    public void setClassmember(Boolean bl) {
        this.classmember = bl;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            this.actionListener.actionPerformed(new ActionEvent(mouseEvent.getSource(), 1001, this.getShortCut()));
            this.setForegroundColor((JLabel)mouseEvent.getSource(), true);
        }
        if (mouseEvent.getButton() == 3) {
            DancerDialog dancerDialog = new DancerDialog(null);
            dancerDialog.setDancer(this);
            dancerDialog.popup();
            JLabel jLabel = (JLabel)mouseEvent.getSource();
            jLabel.setText(this.getDisplayName());
            jLabel.setToolTipText(this.getCompleteName());
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        JLabel jLabel = (JLabel)mouseEvent.getSource();
        this.setForegroundColor(jLabel, true);
        jLabel.setOpaque(true);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        JLabel jLabel = (JLabel)mouseEvent.getSource();
        jLabel.setOpaque(false);
        this.setForegroundColor(jLabel, false);
    }

    public Vector<String> getSquareHistory() {
        if (this.squareHistory == null) {
            this.squareHistory = new Vector();
        }
        return this.squareHistory;
    }
}

