/*
 * Decompiled with CFR 0.152.
 */
package de.ready.splitchainer.business;

import de.ready.splitchainer.business.Dancer;
import de.ready.splitchainer.business.DancerVisibleRenderer;
import de.ready.splitchainer.util.ImagePathUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.table.DefaultTableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DancerBooleanRenderer
extends DefaultTableCellRenderer {
    private final Logger logger = LoggerFactory.getLogger(DancerBooleanRenderer.class);
    protected final List<Dancer> dancer;
    private Image imageIconPresent = null;
    private Image imageIconAbsent = null;

    public DancerBooleanRenderer(List<Dancer> list) {
        this.dancer = list;
    }

    protected Image getImage(URL uRL, String string) {
        BufferedImage bufferedImage = null;
        try {
            if (uRL.toString().startsWith("jar:")) {
                File file = ImagePathUtils.convert(uRL, string);
                bufferedImage = ImageIO.read(file);
            } else {
                bufferedImage = ImageIO.read(uRL);
            }
        }
        catch (Exception exception) {
            this.logger.error(uRL.toString(), (Throwable)exception);
        }
        return bufferedImage;
    }

    protected Image getImageIconPresent() {
        if (this.imageIconPresent == null) {
            URL uRL = DancerVisibleRenderer.class.getResource("images/present.gif");
            this.logger.trace("Resource-url for present.gif is {}", (Object)uRL);
            if (uRL != null) {
                this.imageIconPresent = this.getImage(uRL, "present.gif");
            }
        }
        return this.imageIconPresent;
    }

    protected Image getImageIconAbsent() {
        if (this.imageIconAbsent == null) {
            URL uRL = DancerVisibleRenderer.class.getResource("images/absent.gif");
            this.logger.trace("Resource-url for absent.gif is {}", (Object)uRL);
            if (uRL != null) {
                this.imageIconAbsent = this.getImage(uRL, "absent.gif");
            }
        }
        return this.imageIconAbsent;
    }
}

