/*
 * Decompiled with CFR 0.152.
 */
package de.ready.splitchainer.business;

import de.ready.splitchainer.business.Dancer;
import de.ready.splitchainer.util.ImagePathUtils;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DancersStateRenderer
extends DefaultTableCellRenderer {
    private final List<Dancer> dancer;
    private final Logger logger = LoggerFactory.getLogger(DancersStateRenderer.class);
    private static final long serialVersionUID = 20120116114000L;
    private Image imageIconPresent = null;
    private Image imageIconAbsent = null;
    private Image imageIconPauses = null;

    public DancersStateRenderer(List<Dancer> list) {
        this.dancer = list;
    }

    private Image getImage(URL uRL, String string) {
        BufferedImage bufferedImage = null;
        try {
            if (uRL.toString().startsWith("jar:")) {
                File file = ImagePathUtils.convert(uRL, string);
                bufferedImage = ImageIO.read(file);
            } else {
                bufferedImage = ImageIO.read(uRL);
            }
        }
        catch (Exception exception) {
            this.logger.error(uRL.toString(), (Throwable)exception);
        }
        return bufferedImage;
    }

    private Image getImageIconPresent() {
        if (this.imageIconPresent == null) {
            URL uRL = DancersStateRenderer.class.getResource("images/present.gif");
            this.logger.trace("Resource-url for present.gif is {}", (Object)uRL);
            if (uRL != null) {
                this.imageIconPresent = this.getImage(uRL, "present.gif");
            }
        }
        return this.imageIconPresent;
    }

    private Image getImageIconAbsent() {
        if (this.imageIconAbsent == null) {
            URL uRL = DancersStateRenderer.class.getResource("images/absent.gif");
            this.logger.trace("Resource-url for absent.gif is {}", (Object)uRL);
            if (uRL != null) {
                this.imageIconAbsent = this.getImage(uRL, "absent.gif");
            }
        }
        return this.imageIconAbsent;
    }

    private Image getImageIconPauses() {
        if (this.imageIconPauses == null) {
            URL uRL = DancersStateRenderer.class.getResource("images/pauses.gif");
            this.logger.trace("Resource-url for pauses.gif is {}", (Object)uRL);
            if (uRL != null) {
                this.imageIconPauses = this.getImage(uRL, "pauses.gif");
            }
        }
        return this.imageIconPauses;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        int n3 = jTable.getRowSorter().convertRowIndexToModel(n);
        Dancer dancer = this.dancer.get(n3);
        Image image = dancer.isPauses() != false ? this.getImageIconPauses() : (dancer.isPresent() != false ? this.getImageIconPresent() : this.getImageIconAbsent());
        Component component = super.getTableCellRendererComponent(jTable, null, n2 != 0 ? bl : false, n2 != 0 ? bl2 : false, n, n2);
        this.setIcon(new ImageIcon(image));
        this.setDisabledIcon(new ImageIcon(image));
        return component;
    }
}

