/*
 * Decompiled with CFR 0.152.
 */
package de.ready.splitchainer.business;

import de.ready.splitchainer.interfaces.Searchable;
import javax.swing.JComboBox;

public enum Gender implements Searchable
{
    Beau(1),
    Belle(2),
    BeauAndBelle(3);

    private String[] genders = new String[]{"Beau", "Belle", "Beau&Belle"};
    private String[] symbols = new String[]{"/", "+", "#"};
    private int gender;

    private Gender(int n2) {
        this.gender = n2;
    }

    public int getGender() {
        return this.gender;
    }

    public String getGenderName() {
        return this.genders[this.gender - 1];
    }

    public String getSymbol() {
        return this.symbols[this.gender - 1];
    }

    public boolean equals(Gender gender) {
        if (gender == null) {
            return false;
        }
        return this.getGender() == gender.getGender();
    }

    public boolean isOf(Gender gender) {
        if (this.getGender() == 3 || gender.getGender() == 3) {
            return true;
        }
        return this.equals(gender);
    }

    public boolean fits(Gender gender) {
        if (this.getGender() == 1 && gender.getGender() == 1) {
            return false;
        }
        return this.getGender() != 2 || gender.getGender() != 2;
    }

    public String toString() {
        return this.getGenderName();
    }

    public static void fill(JComboBox jComboBox) {
        jComboBox.addItem(Beau);
        jComboBox.addItem(Belle);
        jComboBox.addItem(BeauAndBelle);
    }

    public static Gender getOppositCamp(Gender gender) {
        Gender gender2 = null;
        if (Beau.equals(gender)) {
            gender2 = Belle;
        }
        if (Belle.equals(gender)) {
            gender2 = Beau;
        }
        return gender2;
    }
}

