/*
 * Decompiled with CFR 0.152.
 */
package de.ready.splitchainer.business;

import de.ready.splitchainer.util.ImagePathUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageTools {
    public static Logger logger = LoggerFactory.getLogger(ImageTools.class);

    public static BufferedImage getImage(Class clazz, String string) throws Exception {
        URL uRL = clazz.getResource("images/" + string);
        logger.trace("reading images/" + string + " -> " + uRL);
        BufferedImage bufferedImage = null;
        if (uRL.toString().startsWith("jar:")) {
            File file = ImagePathUtils.convert(uRL, string);
            bufferedImage = ImageIO.read(file);
        } else {
            bufferedImage = ImageIO.read(uRL);
        }
        return bufferedImage;
    }

    public static BufferedImage combineImages(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        assert (bufferedImage.getWidth() == bufferedImage2.getWidth());
        assert (bufferedImage.getHeight() == bufferedImage2.getHeight());
        BufferedImage bufferedImage3 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
        Graphics graphics = bufferedImage3.getGraphics();
        graphics.drawImage(bufferedImage, 0, 0, null);
        graphics.drawImage(bufferedImage2, 0, 0, null);
        return bufferedImage3;
    }

    public static BufferedImage resize(BufferedImage bufferedImage, int n) {
        BufferedImage bufferedImage2 = new BufferedImage(n, n, 2);
        Graphics graphics = bufferedImage2.getGraphics();
        graphics.drawImage(bufferedImage, 0, 0, n, n, null);
        return bufferedImage2;
    }

    public static BufferedImage setBackground(BufferedImage bufferedImage, Color color) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
        Graphics graphics = bufferedImage2.getGraphics();
        graphics.setColor(color);
        graphics.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics.drawImage(bufferedImage, 0, 0, null);
        return bufferedImage2;
    }
}

