/*
 * Decompiled with CFR 0.152.
 */
package de.ready.splitchainer.business;

public class LicensedFunctions {
    private Long functions = 0L;
    private final Long OVERVIEW_MASK = 8L;
    private final Long HISTOGRAM_MASK = 16L;
    private final Long DIAGRAM_MASK = 32L;
    private final Long BARCODE_MASK = 64L;
    private final Long PERSON_MASK = 128L;
    private final Long SQUARE_MASK = 256L;
    private final Long CALLER_MASK = 512L;

    public LicensedFunctions() {
        this.functions = this.OVERVIEW_MASK + this.HISTOGRAM_MASK + this.DIAGRAM_MASK * this.BARCODE_MASK + this.PERSON_MASK + this.SQUARE_MASK + this.CALLER_MASK;
    }

    public LicensedFunctions(Long l) {
        this.functions = l;
    }

    private Boolean isLicensed(Long l) {
        return (this.functions & l) != 0L;
    }

    public Boolean isPersonInSquareLicensed() {
        return this.isLicensed(this.PERSON_MASK);
    }

    public Boolean isSquareToPersonLicensed() {
        return this.isLicensed(this.SQUARE_MASK);
    }

    public Boolean isHistogramLicensed() {
        return this.isLicensed(this.HISTOGRAM_MASK);
    }

    public Boolean isDiagramLicensed() {
        return this.isLicensed(this.DIAGRAM_MASK);
    }

    public Boolean isBarcodeLicensed() {
        return this.isLicensed(this.BARCODE_MASK);
    }

    public Boolean isOverviewLicensed() {
        return this.isLicensed(this.OVERVIEW_MASK);
    }

    public Boolean isCallerDisplayLicensed() {
        return this.isLicensed(this.CALLER_MASK);
    }
}

