/*
 * Decompiled with CFR 0.152.
 */
package de.ready.splitchainer.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDiagram
extends JPanel {
    private static Logger logger = LoggerFactory.getLogger(JDiagram.class);
    private String name = null;
    private Vector<String> history = new Vector();
    private Vector<String> uniqueNames = new Vector();
    private Integer maximum_x = Integer.MIN_VALUE;
    private Integer maximum_y = Integer.MIN_VALUE;

    public JDiagram(String string, Vector<String> vector) {
        this.name = string;
        if (vector != null) {
            this.history = vector;
        }
        this.init();
    }

    private void init() {
        this.maximum_x = this.history.size();
        this.uniqueNames.add("OUT");
        for (String string : this.history) {
            if (string.length() == 0) {
                string = "OUT";
            }
            if (this.uniqueNames.contains(string)) continue;
            this.uniqueNames.add(string);
        }
        this.maximum_y = this.uniqueNames.size();
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Dimension dimension = this.getSize();
        Graphics2D graphics2D = (Graphics2D)graphics;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        dimension.height -= 5;
        graphics2D.setColor(Color.BLACK);
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(this.name, graphics2D);
        graphics2D.drawString(this.name, (int)((double)dimension.width - rectangle2D.getWidth()) / 2, fontMetrics.getHeight() - 1);
        if (this.maximum_x > 0 && this.maximum_y > 0) {
            int n = dimension.width / this.maximum_x;
            int n2 = (dimension.height - 15) / this.maximum_y;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            BasicStroke basicStroke = new BasicStroke(3.0f, 0, 0, 1.0f, null, 0.0f);
            graphics2D.setStroke(basicStroke);
            for (String string : this.history) {
                if (string.length() == 0) {
                    string = "OUT";
                }
                int n6 = this.uniqueNames.indexOf(string);
                if (n3 == 0) {
                    n4 = 0 * n;
                    n5 = dimension.height - n6 * n2;
                } else {
                    int n7 = n3 * n;
                    int n8 = dimension.height - n6 * n2;
                    graphics2D.drawLine(n4, n5, n7, n8);
                    n4 = n7;
                    n5 = n8;
                }
                graphics2D.draw(new Ellipse2D.Float(n4, n5, 4.0f, 4.0f));
                ++n3;
            }
            BasicStroke basicStroke2 = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{10.0f}, 0.0f);
            graphics2D.setStroke(basicStroke2);
            int n9 = dimension.height;
            for (String string : this.uniqueNames) {
                graphics2D.drawLine(0, n9, dimension.width, n9);
                graphics2D.drawString(string, 10, n9);
                n9 -= n2;
            }
        }
    }
}

