/*
 * Decompiled with CFR 0.152.
 */
package de.ready.splitchainer.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JPanel;

public class JHistogram
extends JPanel {
    private String name = null;
    private Vector<String> history = new Vector();
    private HashMap<String, Integer> histogram = new HashMap();
    private Integer maximum_x = Integer.MIN_VALUE;
    private Integer maximum_y = Integer.MIN_VALUE;

    public JHistogram(String string, Vector<String> vector) {
        this.name = string;
        this.history = vector != null ? vector : new Vector();
        this.init();
    }

    private void init() {
        for (String string : this.history) {
            Integer n;
            if (string.length() == 0) {
                string = "OUT";
            }
            if ((n = this.histogram.get(string)) == null) {
                n = 0;
            }
            n = n + 1;
            this.histogram.put(string, n);
            if (this.maximum_y >= n) continue;
            this.maximum_y = n;
        }
        this.maximum_x = this.histogram.size();
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Dimension dimension = this.getSize();
        Graphics2D graphics2D = (Graphics2D)graphics;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawString(this.name, 10, fontMetrics.getHeight() - 1);
        if (this.maximum_x > 0 && this.maximum_y > 0) {
            int n = (dimension.width - 10) / this.maximum_x - 5;
            int n2 = (dimension.height - 15) / this.maximum_y;
            int n3 = 5;
            int n4 = 0;
            graphics2D.setColor(Color.BLACK);
            boolean bl = false;
            if (this.maximum_y > 9) {
                bl = true;
            }
            for (int i = 1; i <= this.maximum_y; ++i) {
                graphics2D.drawLine(dimension.width - 5, dimension.height - i * n2, dimension.width, dimension.height - i * n2);
            }
            for (String string : this.histogram.keySet()) {
                ++n4;
                if ("OUT".equals(string)) {
                    graphics2D.setColor(Color.BLACK);
                } else if (n4 % 2 == 0) {
                    graphics2D.setColor(Color.LIGHT_GRAY);
                } else {
                    graphics2D.setColor(Color.LIGHT_GRAY.darker());
                }
                Integer n5 = this.histogram.get(string);
                graphics2D.fillRect(n3, dimension.height - n5 * n2, n, n5 * n2);
                AffineTransform affineTransform = graphics2D.getTransform();
                graphics2D.rotate(Math.toRadians(-90.0));
                if ("OUT".equals(string)) {
                    graphics2D.setColor(Color.LIGHT_GRAY);
                } else if (n4 % 2 == 0) {
                    graphics2D.setColor(Color.LIGHT_GRAY.darker().darker());
                } else {
                    graphics2D.setColor(Color.LIGHT_GRAY.brighter());
                }
                graphics2D.drawString(string, -dimension.height + 5, n3 + (n + fontMetrics.getHeight()) / 2);
                graphics2D.setTransform(affineTransform);
                n3 += n + 5;
            }
        }
    }
}

