/*
 * Decompiled with CFR 0.152.
 */
package de.ready.splitchainer.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;

public class DialogUtil {
    private static int counter = 0;
    private static ArrayList dialogs = new ArrayList();
    private static JMenuBar menuBar = null;

    public static synchronized void registerJDialog(JDialog jDialog) {
        if (menuBar != null) {
            DialogUtil.setupActions(jDialog, menuBar);
        } else {
            dialogs.add(jDialog);
        }
    }

    public static synchronized void setupDialogActions(JMenuBar jMenuBar) {
        menuBar = jMenuBar;
        if (dialogs == null) {
            return;
        }
        for (JDialog jDialog : dialogs) {
            DialogUtil.setupActions(jDialog, menuBar);
        }
        dialogs.clear();
        dialogs = null;
    }

    public static void setupActions(JDialog jDialog, JMenuBar jMenuBar) {
        counter = 0;
        for (int i = 0; i < jMenuBar.getComponentCount(); ++i) {
            Component component = jMenuBar.getComponent(i);
            if (!(component instanceof MenuElement)) continue;
            DialogUtil.setActionsMenu(jDialog, (MenuElement)((Object)component));
        }
    }

    private static void setActionsMenu(JDialog jDialog, MenuElement menuElement) {
        MenuElement[] menuElementArray = menuElement.getSubElements();
        for (int i = 0; i < menuElementArray.length; ++i) {
            MenuElement menuElement2 = menuElementArray[i];
            if (menuElement2 instanceof JMenuItem) {
                final JMenuItem jMenuItem = (JMenuItem)menuElement2;
                if (jMenuItem.getAccelerator() == null) continue;
                String string = "hackAction" + counter++;
                jDialog.getRootPane().getInputMap(2).put(jMenuItem.getAccelerator(), string);
                if (jMenuItem.getAction() == null) {
                    jDialog.getRootPane().getActionMap().put(string, new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            jMenuItem.doClick();
                        }
                    });
                    continue;
                }
                jDialog.getRootPane().getActionMap().put(string, jMenuItem.getAction());
                continue;
            }
            if (menuElement2.getSubElements().length <= 0) continue;
            DialogUtil.setActionsMenu(jDialog, menuElement2);
        }
    }
}

