/*
 * Decompiled with CFR 0.152.
 */
package de.ready.splitchainer.util;

import de.ready.splitchainer.util.SortedKeyValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Matrix<U, V extends Integer> {
    private HashMap<U, SortedKeyValue<U, V>> data = new HashMap();
    private static Logger logger = LoggerFactory.getLogger(Matrix.class);

    public void add(U u, U u2, V v) {
        SortedKeyValue<U, V> sortedKeyValue = this.data.get(u);
        if (sortedKeyValue == null) {
            sortedKeyValue = new SortedKeyValue();
            this.data.put(u, sortedKeyValue);
        }
        sortedKeyValue.add(u2, v);
    }

    private Double sum(HashMap<U, SortedKeyValue<U, V>> hashMap) {
        Double d = 0.0;
        for (Map.Entry<U, SortedKeyValue<U, V>> entry : hashMap.entrySet()) {
            d = d + ((Integer)entry.getValue().getValue(entry.getKey())).doubleValue();
        }
        return d;
    }

    private HashMap<U, SortedKeyValue<U, V>> cloneMap() {
        HashMap hashMap = new HashMap();
        return hashMap;
    }

    private Integer testFunction(HashMap<U, SortedKeyValue<U, V>> hashMap) {
        int n = 0;
        for (U u : hashMap.keySet()) {
            assert (hashMap.get(u).keys.size() == 1);
            n += ((Integer)hashMap.get(u).vals.get(0)).intValue();
        }
        return n;
    }

    private HashMap<U, SortedKeyValue<U, V>> combine(Vector<U> vector, Vector<U> vector2, Vector<V> vector3, Integer n) {
        HashMap hashMap = this.cloneMap();
        for (int i = 0; i < vector.size(); ++i) {
            int n2 = (i + n) % vector.size();
            SortedKeyValue<U, Integer> sortedKeyValue = new SortedKeyValue<U, Integer>();
            sortedKeyValue.add(vector2.get(n2), (Integer)vector3.get(n2));
            hashMap.put(vector.get(i), sortedKeyValue);
        }
        return hashMap;
    }

    public void collapse() {
        Integer n2;
        Object object3;
        Object object22;
        Vector<U> vector = new Vector<U>();
        for (Object object22 : this.data.keySet()) {
            vector.add(object22);
        }
        Vector vector2 = new Vector();
        for (Object object3 : this.data.get(this.data.keySet().iterator().next()).keys) {
            vector2.add(object3);
        }
        object22 = new Vector();
        for (Integer n2 : this.data.get(this.data.keySet().iterator().next()).vals) {
            ((Vector)object22).add(n2);
        }
        assert (vector.size() == vector2.size());
        object3 = new Vector();
        n2 = Integer.MIN_VALUE;
        for (int i = 0; i < vector.size(); ++i) {
            HashMap hashMap = this.combine(vector, vector2, (Vector<V>)object22, i);
            Integer n3 = this.testFunction(hashMap);
            if (n3 == n2) {
                object3.add(hashMap);
            }
            if (n3 <= n2) continue;
            object3 = new Vector();
            object3.add(hashMap);
            n2 = n3;
        }
        HashMap hashMap = null;
        if (object3.size() == 1) {
            hashMap = (HashMap)object3.get(0);
        }
        if (object3.size() > 1) {
            int n4 = new Random().nextInt(object3.size());
            hashMap = (HashMap)object3.get(n4);
        }
        this.data = hashMap;
    }

    private Set<U> orderLeastFirst(Set<U> set) {
        HashSet hashSet = new HashSet();
        HashMap<U, Integer> hashMap = new HashMap<U, Integer>();
        for (U u : set) {
            int n = Integer.MIN_VALUE;
            int n2 = 0;
            for (Serializable serializable : this.data.get(u).vals) {
                if (((Integer)serializable).compareTo(n) == 0) {
                    ++n2;
                }
                if (((Integer)serializable).compareTo(n) <= 0) continue;
                n = (Integer)serializable;
                n2 = 1;
            }
            hashMap.put(u, n2);
        }
        HashMap hashMap2 = new HashMap();
        int n = 0;
        for (U u : set) {
            Serializable serializable;
            Integer n3 = (Integer)hashMap.get(u);
            if (n3 > n) {
                n = n3;
            }
            if ((serializable = (List)hashMap2.get(n3)) == null) {
                serializable = new Vector<U>();
                hashMap2.put(n3, serializable);
            }
            serializable.add(u);
        }
        for (int i = 0; i <= n; ++i) {
            List list = (List)hashMap2.get(i);
            if (list == null) continue;
            for (int j = 0; j < list.size(); ++j) {
                hashSet.add(list.get(j));
            }
        }
        return hashSet;
    }

    public void maximize() {
        Random random = new Random(System.currentTimeMillis());
        for (U u : this.orderLeastFirst(this.data.keySet())) {
            U u2 = this.data.get(u).choose(random);
            for (U u3 : this.data.keySet()) {
                if (u3.equals(u)) continue;
                this.data.get(u3).remove(u2);
            }
            this.data.get(u).removeAllExcept(u2);
        }
    }

    public List<U> getMaximized(U u) {
        return this.data.get(u).keys;
    }

    public List<U> getKeys() {
        Vector<U> vector = new Vector<U>();
        for (Map.Entry<U, SortedKeyValue<U, V>> entry : this.data.entrySet()) {
            vector.add(entry.getKey());
        }
        return vector;
    }
}

