/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.license;

import de.schlichtherle.license.CipherParam;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseContentException;
import de.schlichtherle.license.LicenseCreator;
import de.schlichtherle.license.LicenseNotary;
import de.schlichtherle.license.LicenseParam;
import de.schlichtherle.license.LicenseVerifier;
import de.schlichtherle.license.NoLicenseInstalledException;
import de.schlichtherle.license.Policy;
import de.schlichtherle.license.PrivacyGuard;
import de.schlichtherle.license.Resources;
import de.schlichtherle.util.ObfuscatedString;
import de.schlichtherle.xml.GenericCertificate;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.prefs.Preferences;
import javax.security.auth.x500.X500Principal;
import javax.swing.filechooser.FileFilter;

public class LicenseManager
implements LicenseCreator,
LicenseVerifier {
    private static final long TIMEOUT = 1800000L;
    private static final String PREFERENCES_KEY = new ObfuscatedString(new long[]{-2999492566024573771L, -1728025856628382701L}).toString();
    public static final String LICENSE_SUFFIX = new ObfuscatedString(new long[]{-7559156485370438418L, 5084921010819724770L}).toString();
    protected static final String CN;
    private static final String CN_USER;
    private static final String USER;
    private static final String SYSTEM;
    private static final String EXC_INVALID_SUBJECT;
    private static final String EXC_HOLDER_IS_NULL;
    private static final String EXC_ISSUER_IS_NULL;
    private static final String EXC_ISSUED_IS_NULL;
    private static final String EXC_LICENSE_IS_NOT_YET_VALID;
    private static final String EXC_LICENSE_HAS_EXPIRED;
    private static final String EXC_CONSUMER_TYPE_IS_NULL;
    private static final String EXC_CONSUMER_TYPE_IS_NOT_USER;
    private static final String EXC_CONSUMER_AMOUNT_IS_NOT_ONE;
    private static final String EXC_CONSUMER_AMOUNT_IS_NOT_POSITIVE;
    private static final String FILE_FILTER_DESCRIPTION;
    private static final String FILE_FILTER_SUFFIX;
    private LicenseParam param;
    private LicenseNotary notary;
    private PrivacyGuard guard;
    private GenericCertificate certificate;
    private long certificateTime;
    private FileFilter fileFilter;
    private Preferences preferences;

    protected static Date midnight() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    protected LicenseManager() {
    }

    public LicenseManager(LicenseParam licenseParam) {
        this.setLicenseParam0(licenseParam);
    }

    public synchronized LicenseParam getLicenseParam() {
        return this.param;
    }

    public synchronized void setLicenseParam(LicenseParam licenseParam) {
        this.setLicenseParam0(licenseParam);
    }

    private void setLicenseParam0(LicenseParam licenseParam) {
        CipherParam cipherParam;
        if (null == licenseParam || null == licenseParam.getSubject() || null == licenseParam.getKeyStoreParam() || null == (cipherParam = licenseParam.getCipherParam())) {
            throw new NullPointerException();
        }
        Policy.getCurrent().checkPwd(cipherParam.getKeyPwd());
        this.param = licenseParam;
        this.notary = null;
        this.certificate = null;
        this.certificateTime = 0L;
        this.fileFilter = null;
        this.preferences = null;
    }

    public final synchronized void store(LicenseContent licenseContent, File file) throws Exception {
        this.store(licenseContent, this.getLicenseNotary(), file);
    }

    protected synchronized void store(LicenseContent licenseContent, LicenseNotary licenseNotary, File file) throws Exception {
        LicenseManager.storeLicenseKey(this.create(licenseContent, licenseNotary), file);
    }

    @Override
    public final synchronized byte[] create(LicenseContent licenseContent) throws Exception {
        return this.create(licenseContent, this.getLicenseNotary());
    }

    protected synchronized byte[] create(LicenseContent licenseContent, LicenseNotary licenseNotary) throws Exception {
        this.initialize(licenseContent);
        this.validate(licenseContent);
        GenericCertificate genericCertificate = licenseNotary.sign(licenseContent);
        byte[] byArray = this.getPrivacyGuard().cert2key(genericCertificate);
        return byArray;
    }

    public final synchronized LicenseContent install(File file) throws Exception {
        return this.install(file, this.getLicenseNotary());
    }

    protected synchronized LicenseContent install(File file, LicenseNotary licenseNotary) throws Exception {
        return this.install(LicenseManager.loadLicenseKey(file), licenseNotary);
    }

    protected synchronized LicenseContent install(byte[] byArray, LicenseNotary licenseNotary) throws Exception {
        GenericCertificate genericCertificate = this.getPrivacyGuard().key2cert(byArray);
        licenseNotary.verify(genericCertificate);
        LicenseContent licenseContent = (LicenseContent)genericCertificate.getContent();
        this.validate(licenseContent);
        this.setLicenseKey(byArray);
        this.setCertificate(genericCertificate);
        return licenseContent;
    }

    public final synchronized LicenseContent verify() throws Exception {
        return this.verify(this.getLicenseNotary());
    }

    protected synchronized LicenseContent verify(LicenseNotary licenseNotary) throws Exception {
        GenericCertificate genericCertificate = this.getCertificate();
        if (null != genericCertificate) {
            return (LicenseContent)genericCertificate.getContent();
        }
        byte[] byArray = this.getLicenseKey();
        if (null == byArray) {
            throw new NoLicenseInstalledException(this.getLicenseParam().getSubject());
        }
        genericCertificate = this.getPrivacyGuard().key2cert(byArray);
        licenseNotary.verify(genericCertificate);
        LicenseContent licenseContent = (LicenseContent)genericCertificate.getContent();
        this.validate(licenseContent);
        this.setCertificate(genericCertificate);
        return licenseContent;
    }

    @Override
    public final synchronized LicenseContent verify(byte[] byArray) throws Exception {
        return this.verify(byArray, this.getLicenseNotary());
    }

    protected synchronized LicenseContent verify(byte[] byArray, LicenseNotary licenseNotary) throws Exception {
        GenericCertificate genericCertificate = this.getPrivacyGuard().key2cert(byArray);
        licenseNotary.verify(genericCertificate);
        LicenseContent licenseContent = (LicenseContent)genericCertificate.getContent();
        this.validate(licenseContent);
        return licenseContent;
    }

    public synchronized void uninstall() throws Exception {
        this.setLicenseKey(null);
        this.setCertificate(null);
    }

    protected synchronized void initialize(LicenseContent licenseContent) {
        Preferences preferences;
        if (licenseContent.getHolder() == null) {
            licenseContent.setHolder(new X500Principal(CN_USER));
        }
        if (licenseContent.getSubject() == null) {
            licenseContent.setSubject(this.getLicenseParam().getSubject());
        }
        if (licenseContent.getConsumerType() == null && (preferences = this.getLicenseParam().getPreferences()) != null) {
            if (preferences.isUserNode()) {
                licenseContent.setConsumerType(USER);
            } else {
                licenseContent.setConsumerType(SYSTEM);
            }
            licenseContent.setConsumerAmount(1);
        }
        if (licenseContent.getIssuer() == null) {
            licenseContent.setIssuer(new X500Principal(CN + this.getLicenseParam().getSubject()));
        }
        if (licenseContent.getIssued() == null) {
            licenseContent.setIssued(new Date());
        }
        if (licenseContent.getNotBefore() == null) {
            licenseContent.setNotBefore(LicenseManager.midnight());
        }
    }

    protected synchronized void validate(LicenseContent licenseContent) throws LicenseContentException {
        LicenseParam licenseParam = this.getLicenseParam();
        if (!licenseParam.getSubject().equals(licenseContent.getSubject())) {
            throw new LicenseContentException(EXC_INVALID_SUBJECT);
        }
        if (licenseContent.getHolder() == null) {
            throw new LicenseContentException(EXC_HOLDER_IS_NULL);
        }
        if (licenseContent.getIssuer() == null) {
            throw new LicenseContentException(EXC_ISSUER_IS_NULL);
        }
        if (licenseContent.getIssued() == null) {
            throw new LicenseContentException(EXC_ISSUED_IS_NULL);
        }
        Date date = new Date();
        Date date2 = licenseContent.getNotBefore();
        if (date2 != null && date.before(date2)) {
            throw new LicenseContentException(EXC_LICENSE_IS_NOT_YET_VALID);
        }
        Date date3 = licenseContent.getNotAfter();
        if (date3 != null && date.after(date3)) {
            throw new LicenseContentException(EXC_LICENSE_HAS_EXPIRED);
        }
        String string = licenseContent.getConsumerType();
        if (string == null) {
            throw new LicenseContentException(EXC_CONSUMER_TYPE_IS_NULL);
        }
        Preferences preferences = licenseParam.getPreferences();
        if (preferences != null && preferences.isUserNode()) {
            if (!USER.equalsIgnoreCase(string)) {
                throw new LicenseContentException(EXC_CONSUMER_TYPE_IS_NOT_USER);
            }
            if (licenseContent.getConsumerAmount() != 1) {
                throw new LicenseContentException(EXC_CONSUMER_AMOUNT_IS_NOT_ONE);
            }
        } else if (licenseContent.getConsumerAmount() <= 0) {
            throw new LicenseContentException(EXC_CONSUMER_AMOUNT_IS_NOT_POSITIVE);
        }
    }

    protected synchronized GenericCertificate getCertificate() {
        if (null != this.certificate && System.currentTimeMillis() < this.certificateTime + 1800000L) {
            return this.certificate;
        }
        return null;
    }

    protected synchronized void setCertificate(GenericCertificate genericCertificate) {
        this.certificate = genericCertificate;
        this.certificateTime = System.currentTimeMillis();
    }

    protected synchronized byte[] getLicenseKey() {
        return this.getLicenseParam().getPreferences().getByteArray(PREFERENCES_KEY, null);
    }

    protected synchronized void setLicenseKey(byte[] byArray) {
        Preferences preferences = this.getLicenseParam().getPreferences();
        if (byArray != null) {
            preferences.putByteArray(PREFERENCES_KEY, byArray);
        } else {
            preferences.remove(PREFERENCES_KEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void storeLicenseKey(byte[] byArray, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            ((OutputStream)fileOutputStream).write(byArray);
        }
        finally {
            try {
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] loadLicenseKey(File file) throws IOException {
        int n = Math.min((int)file.length(), 0x100000);
        byte[] byArray = new byte[n];
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            ((InputStream)fileInputStream).read(byArray);
        }
        return byArray;
    }

    protected synchronized LicenseNotary getLicenseNotary() {
        if (this.notary == null) {
            this.notary = new LicenseNotary(this.getLicenseParam().getKeyStoreParam());
        }
        return this.notary;
    }

    protected synchronized PrivacyGuard getPrivacyGuard() {
        if (this.guard == null) {
            this.guard = new PrivacyGuard(this.getLicenseParam().getCipherParam());
        }
        return this.guard;
    }

    public synchronized FileFilter getFileFilter() {
        if (this.fileFilter != null) {
            return this.fileFilter;
        }
        final String string = Resources.getString(FILE_FILTER_DESCRIPTION, this.getLicenseParam().getSubject());
        this.fileFilter = File.separatorChar == '\\' ? new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getPath().toLowerCase().endsWith(LICENSE_SUFFIX);
            }

            @Override
            public String getDescription() {
                return string + FILE_FILTER_SUFFIX;
            }
        } : new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getPath().endsWith(LICENSE_SUFFIX);
            }

            @Override
            public String getDescription() {
                return string + FILE_FILTER_SUFFIX;
            }
        };
        return this.fileFilter;
    }

    static {
        assert (LICENSE_SUFFIX.equals(LICENSE_SUFFIX.toLowerCase()));
        CN = new ObfuscatedString(new long[]{7165044359350484836L, -6008675436704023088L}).toString();
        CN_USER = CN + Resources.getString(new ObfuscatedString(new long[]{-883182015789302099L, 6587252612286394632L}).toString());
        USER = new ObfuscatedString(new long[]{-6950934198262740461L, -10280221617836935L}).toString();
        SYSTEM = new ObfuscatedString(new long[]{-1441033263392531498L, 6113162389128247115L}).toString();
        EXC_INVALID_SUBJECT = new ObfuscatedString(new long[]{-9211605111142713620L, 391714365510707393L, -7356761750428556372L, 6379560902598103028L}).toString();
        EXC_HOLDER_IS_NULL = new ObfuscatedString(new long[]{7150026245468079143L, 6314884536402738366L, -1360923923476698800L}).toString();
        EXC_ISSUER_IS_NULL = new ObfuscatedString(new long[]{-3034693013076752554L, -1011266899694033610L, 6775785917404597234L}).toString();
        EXC_ISSUED_IS_NULL = new ObfuscatedString(new long[]{-6084371209004858580L, 3028840747031697166L, -3524637886726219307L}).toString();
        EXC_LICENSE_IS_NOT_YET_VALID = new ObfuscatedString(new long[]{5434633639502011825L, -3406117476263181371L, 6903673940810780388L, -6816911225052310716L}).toString();
        EXC_LICENSE_HAS_EXPIRED = new ObfuscatedString(new long[]{1000558500458715757L, -6998261911041258483L, -5490039629745846648L, 3561172928787106880L}).toString();
        EXC_CONSUMER_TYPE_IS_NULL = new ObfuscatedString(new long[]{-3274088377466921882L, -1704115158449736962L, -1134622897105293263L, 2875630655915253859L}).toString();
        EXC_CONSUMER_TYPE_IS_NOT_USER = new ObfuscatedString(new long[]{-3559580260061340089L, 8807812719464926891L, 3255622466169980128L, 3208430498260873670L, 8772089725159421213L}).toString();
        EXC_CONSUMER_AMOUNT_IS_NOT_ONE = new ObfuscatedString(new long[]{6854702630454082314L, -1676630527348424687L, 4853969635229547239L, -7087814313396201500L, 7133601245775504376L}).toString();
        EXC_CONSUMER_AMOUNT_IS_NOT_POSITIVE = new ObfuscatedString(new long[]{-5670394608177286583L, -3674104453170648872L, 4159301984262248157L, 7442355638167795990L, 4780252201915657674L}).toString();
        FILE_FILTER_DESCRIPTION = new ObfuscatedString(new long[]{3160933239845492228L, -2320904495012387647L, -5935185636215549881L, -3418607682842311949L}).toString();
        FILE_FILTER_SUFFIX = new ObfuscatedString(new long[]{-6576160320308571504L, 7010427383913371869L}).toString();
    }
}

