/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageObserver;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.Timer;

public class AnimatedImageIcon
extends ImageIcon {
    private static final String CLASS_NAME = "de/schlichtherle/swing/AnimatedImageIcon".replace('/', '.');
    private static final Logger logger = Logger.getLogger(CLASS_NAME);
    private static final Level CALLING = Level.FINE;
    private static final Level FAILED = Level.WARNING;
    private static final Level RETURNED = Level.FINER;
    private static final long serialVersionUID = 1L;
    private int delay;
    private Image[] frames;
    private final Timer timer = new Timer(0, new Animator());

    public AnimatedImageIcon() {
    }

    public AnimatedImageIcon(int n, Image[] imageArray) {
        super(imageArray[0]);
        this.setRateImpl(n);
        this.setFramesImpl(imageArray);
    }

    public int getRate() {
        return 1000 / this.delay;
    }

    public void setRate(int n) {
        this.setRateImpl(n);
    }

    private void setRateImpl(int n) {
        this.delay = 1000 / n;
        this.timer.setDelay(this.delay);
    }

    public Image[] getFrames() {
        return (Image[])this.frames.clone();
    }

    public void setFrames(Image[] imageArray) {
        this.setFramesImpl(imageArray);
    }

    private void setFramesImpl(Image[] imageArray) {
        this.frames = imageArray;
        this.setImage(imageArray[0]);
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        logger.log(CALLING, System.identityHashCode(this) + "(c=" + System.identityHashCode(component) + ", g=" + System.identityHashCode(graphics) + ", x=" + n + ", y=" + n2 + ")");
        try {
            Image image = this.getImage();
            if (image == null) {
                return;
            }
            graphics.drawImage(image, n, n2, null);
            this.setImageObserver(component);
            this.timer.start();
            logger.log(RETURNED, System.identityHashCode(this) + "(...)");
        }
        catch (Throwable throwable) {
            logger.log(FAILED, System.identityHashCode(this) + "(...)");
            AnimatedImageIcon.rethrow(throwable);
        }
    }

    private static void rethrow(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new UndeclaredThrowableException(throwable);
    }

    private class Animator
    implements ActionListener {
        private int current;

        private Animator() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ImageObserver imageObserver = AnimatedImageIcon.this.getImageObserver();
            this.current = (this.current + 1) % AnimatedImageIcon.this.frames.length;
            boolean bl = this.imageUpdate(imageObserver, AnimatedImageIcon.this.frames[this.current]);
            if (!bl) {
                this.current = 0;
                bl = this.imageUpdate(imageObserver, AnimatedImageIcon.this.frames[this.current]);
                AnimatedImageIcon.this.timer.stop();
                AnimatedImageIcon.this.setImageObserver(null);
                assert (!bl) : "The image observer should not be interested in updates anymore!";
            }
        }

        private boolean imageUpdate(ImageObserver imageObserver, Image image) {
            logger.log(CALLING, System.identityHashCode(this) + "(observer=" + System.identityHashCode(imageObserver) + ", image=" + image + ")");
            try {
                AnimatedImageIcon.this.setImage(image);
                int n = image.getWidth(imageObserver);
                assert (n == AnimatedImageIcon.this.getIconWidth());
                int n2 = image.getHeight(imageObserver);
                assert (n2 == AnimatedImageIcon.this.getIconHeight());
                boolean bl = imageObserver.imageUpdate(image, 16, 0, 0, n, n2);
                logger.log(RETURNED, System.identityHashCode(this) + "(...)=" + bl);
                return bl;
            }
            catch (Throwable throwable) {
                logger.log(FAILED, System.identityHashCode(this) + "(...)");
                AnimatedImageIcon.rethrow(throwable);
                return false;
            }
        }
    }
}

