/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.swing;

import de.schlichtherle.swing.EnhancedComboBoxModel;
import de.schlichtherle.swing.EnhancedDocument;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class EnhancedComboBox
extends JComboBox {
    public static final String PROPERTY_PUSHING_PROPERTY_CHANGES = "pushingPropertyChanges";
    private static final long serialVersionUID = 1L;
    private final PropertyChangeListener controller = new Controller();

    public EnhancedComboBox(ComboBoxModel comboBoxModel) {
        this.changeModel(super.getModel(), comboBoxModel);
    }

    public EnhancedComboBox(Object[] objectArray) {
        this.changeModel(super.getModel(), new EnhancedComboBoxModel(objectArray));
    }

    public EnhancedComboBox(Vector vector) {
        this.changeModel(super.getModel(), new EnhancedComboBoxModel(vector));
    }

    public EnhancedComboBox() {
        this.changeModel(super.getModel(), new EnhancedComboBoxModel());
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        this.changeModel(this.getModel(), comboBoxModel);
    }

    @Override
    public void setEditor(ComboBoxEditor comboBoxEditor) {
        this.changeEditor(this.getEditor(), comboBoxEditor);
    }

    public Document getDocument() {
        if (!this.isEditable()) {
            throw new IllegalStateException();
        }
        JTextComponent jTextComponent = this.getTextComponent();
        return jTextComponent != null ? jTextComponent.getDocument() : null;
    }

    public void setDocument(Document document) {
        if (!this.isEditable()) {
            throw new IllegalStateException();
        }
        this.changeDocument(this.getDocument(), document);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.changeEnabled(this.isEnabled(), bl);
    }

    @Override
    public void setEditable(boolean bl) {
        this.changeEditable(this.isEditable(), bl);
    }

    private void changeModel(ComboBoxModel comboBoxModel, ComboBoxModel comboBoxModel2) {
        if (comboBoxModel2 == comboBoxModel) {
            return;
        }
        if (comboBoxModel instanceof EnhancedComboBoxModel) {
            ((EnhancedComboBoxModel)comboBoxModel).removePropertyChangeListener(this.controller);
        }
        super.setModel(comboBoxModel2);
        if (comboBoxModel2 instanceof EnhancedComboBoxModel) {
            EnhancedComboBoxModel enhancedComboBoxModel = (EnhancedComboBoxModel)comboBoxModel2;
            enhancedComboBoxModel.addPropertyChangeListener(this.controller);
            boolean bl = enhancedComboBoxModel.isEditable();
            this.changeEditable(super.isEditable(), bl);
            boolean bl2 = enhancedComboBoxModel.isEnabled();
            this.changeEnabled(super.isEnabled(), bl2);
        }
    }

    private void changeEditor(ComboBoxEditor comboBoxEditor, ComboBoxEditor comboBoxEditor2) {
        Component component;
        Component component2;
        if (comboBoxEditor2 == comboBoxEditor) {
            return;
        }
        JTextComponent jTextComponent = null;
        if (comboBoxEditor != null && (component2 = comboBoxEditor.getEditorComponent()) instanceof JTextComponent) {
            jTextComponent = (JTextComponent)component2;
        }
        super.setEditor(comboBoxEditor2);
        component2 = null;
        if (comboBoxEditor2 != null && (component = comboBoxEditor2.getEditorComponent()) instanceof JTextComponent) {
            component2 = (JTextComponent)component;
        }
        this.changeText(jTextComponent, (JTextComponent)component2);
    }

    private void changeText(JTextComponent jTextComponent, JTextComponent jTextComponent2) {
        if (jTextComponent2 == jTextComponent) {
            return;
        }
        Document document = null;
        if (jTextComponent != null) {
            jTextComponent.removePropertyChangeListener("document", this.controller);
            document = jTextComponent.getDocument();
        }
        Document document2 = null;
        if (jTextComponent2 != null) {
            jTextComponent2.addPropertyChangeListener("document", this.controller);
            document2 = jTextComponent2.getDocument();
        }
        this.changeDocument(document, document2);
    }

    private void changeDocument(Document document, Document document2) {
        Serializable serializable;
        if (document2 == document) {
            return;
        }
        if (document instanceof EnhancedDocument) {
            serializable = (EnhancedDocument)document;
            ((EnhancedDocument)serializable).removePropertyChangeListener("editable", this.controller);
        }
        if ((serializable = this.getTextComponent()) != null) {
            ((JTextComponent)serializable).setDocument(document2);
        }
        if (document2 instanceof EnhancedDocument) {
            EnhancedDocument enhancedDocument = (EnhancedDocument)document2;
            enhancedDocument.addPropertyChangeListener("editable", this.controller);
            boolean bl = enhancedDocument.isEditable();
            this.changeEnabled(super.isEnabled(), bl);
        }
    }

    private void changeEditable(boolean bl, boolean bl2) {
        JTextComponent jTextComponent;
        if (bl2 == bl) {
            return;
        }
        super.setEditable(bl2);
        ComboBoxModel comboBoxModel = super.getModel();
        if (comboBoxModel instanceof EnhancedComboBoxModel) {
            ((EnhancedComboBoxModel)comboBoxModel).setEditable(bl2);
        }
        if ((jTextComponent = this.getTextComponent()) != null) {
            Document document = jTextComponent.getDocument();
            if (document instanceof EnhancedDocument) {
                ((EnhancedDocument)document).setEditable(bl2);
            } else if (!bl) {
                assert (bl2);
                EnhancedDocument enhancedDocument = new EnhancedDocument();
                assert (enhancedDocument.isEditable());
                this.changeDocument(document, enhancedDocument);
            }
        }
    }

    private void changeEnabled(boolean bl, boolean bl2) {
        if (bl2 == bl) {
            return;
        }
        super.setEnabled(bl2);
        ComboBoxModel comboBoxModel = super.getModel();
        if (comboBoxModel instanceof EnhancedComboBoxModel) {
            ((EnhancedComboBoxModel)comboBoxModel).setEnabled(bl2);
        }
    }

    private JTextComponent getTextComponent() {
        Component component;
        ComboBoxEditor comboBoxEditor = super.getEditor();
        if (comboBoxEditor != null && (component = comboBoxEditor.getEditorComponent()) instanceof JTextComponent) {
            return (JTextComponent)component;
        }
        return null;
    }

    private final class Controller
    implements PropertyChangeListener {
        private Controller() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            JTextComponent jTextComponent = EnhancedComboBox.this.getTextComponent();
            if (jTextComponent != null && object == jTextComponent.getDocument()) {
                assert ("editable".equals(string));
                EnhancedComboBox.this.changeEnabled(Boolean.TRUE.equals(propertyChangeEvent.getOldValue()), Boolean.TRUE.equals(propertyChangeEvent.getNewValue()));
            } else if (object == jTextComponent) {
                assert ("document".equals(string));
                EnhancedComboBox.this.changeDocument((Document)propertyChangeEvent.getOldValue(), (Document)propertyChangeEvent.getNewValue());
            } else {
                assert (object == EnhancedComboBox.this.getModel());
                if ("editable".equals(string)) {
                    EnhancedComboBox.this.changeEditable(Boolean.TRUE.equals(propertyChangeEvent.getOldValue()), Boolean.TRUE.equals(propertyChangeEvent.getNewValue()));
                } else if ("enabled".equals(string)) {
                    EnhancedComboBox.this.changeEnabled(Boolean.TRUE.equals(propertyChangeEvent.getOldValue()), Boolean.TRUE.equals(propertyChangeEvent.getNewValue()));
                }
            }
        }
    }
}

