/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.swing;

import de.schlichtherle.swing.EnhancedComboBoxModel;
import de.schlichtherle.swing.EnhancedDocument;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class EnhancedTextField
extends JTextField {
    private static final long serialVersionUID = 1L;
    private transient Listener listener;

    private Listener listener() {
        if (null == this.listener) {
            this.listener = new Listener();
        }
        return this.listener;
    }

    public EnhancedTextField() {
    }

    public EnhancedTextField(String string) {
        super(string);
    }

    public EnhancedTextField(int n) {
        super(n);
    }

    public EnhancedTextField(String string, int n) {
        super(string, n);
    }

    public EnhancedTextField(Document document, String string, int n) {
        super(document, string, n);
    }

    @Override
    public void setEditable(boolean bl) {
        this.changeEditable(this.isEditable(), bl);
    }

    private void changeEditable(boolean bl, boolean bl2) {
        if (bl2 == bl) {
            return;
        }
        super.setEditable(bl2);
        Document document = super.getDocument();
        if (document instanceof EnhancedComboBoxModel) {
            ((EnhancedComboBoxModel)((Object)document)).setEditable(bl2);
        }
    }

    @Override
    protected Document createDefaultModel() {
        return new EnhancedDocument();
    }

    @Override
    public void setDocument(Document document) {
        Document document2 = this.getDocument();
        if (document2 instanceof EnhancedDocument) {
            ((EnhancedDocument)document2).removePropertyChangeListener("editable", this.listener());
        }
        super.setDocument(document);
        if (document instanceof EnhancedDocument) {
            EnhancedDocument enhancedDocument = (EnhancedDocument)document;
            enhancedDocument.addPropertyChangeListener("editable", this.listener());
            this.setEditable(enhancedDocument.isEditable());
        }
    }

    private final class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            EnhancedTextField.this.changeEditable(Boolean.TRUE.equals(propertyChangeEvent.getOldValue()), Boolean.TRUE.equals(propertyChangeEvent.getNewValue()));
        }
    }
}

