/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.swing;

import java.io.Serializable;

public class MnemonicText
implements Serializable {
    private static final String HTML_TAG = "<html>";
    private static final long serialVersionUID = 1L;
    private final String text;
    private final int mnemonicIndex;
    private final char mnemonic;
    private final boolean isHtmlText;

    public MnemonicText(String string) {
        int n = -1;
        char c = '\u0000';
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c2 = string.charAt(i);
            if (c2 == '&') {
                if (++i >= n2) break;
                c2 = string.charAt(i);
                if (c2 != '&' && n == -1) {
                    c = c2;
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(c2);
        }
        this.text = stringBuffer.length() != n2 ? stringBuffer.toString() : string;
        this.mnemonicIndex = n;
        this.mnemonic = c;
        String string2 = string.trim();
        this.isHtmlText = string2.substring(0, Math.min(HTML_TAG.length(), string2.length())).equalsIgnoreCase(HTML_TAG);
    }

    public String getText() {
        return this.text;
    }

    public int getMnemonicIndex() {
        return this.mnemonicIndex;
    }

    public char getMnemonic() {
        return this.mnemonic;
    }

    public final boolean isHtmlText() {
        return this.isHtmlText;
    }
}

