/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.swing;

import de.schlichtherle.swing.MnemonicText;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public abstract class ResourceBundleAction
extends AbstractAction {
    private static final String[] actionKeys = Collections.list(new ActionKeyEnumeration()).toArray(new String[8]);
    private final Action delegate;

    public ResourceBundleAction(Class clazz, String string) {
        this(clazz, string, null);
    }

    public ResourceBundleAction(Class clazz, String string, Action action) {
        this(clazz.getName(), ResourceBundleAction.getLoader(clazz), string, action);
    }

    public ResourceBundleAction(String string, String string2) {
        this(string, Thread.currentThread().getContextClassLoader(), string2, null);
    }

    public ResourceBundleAction(String string, ClassLoader classLoader, String string2) {
        this(string, classLoader, string2, null);
    }

    public ResourceBundleAction(String string, ClassLoader classLoader, String string2, Action action) {
        this.delegate = action;
        this.loadResources(string, classLoader, string2);
    }

    private static ClassLoader getLoader(Class clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader != null) {
            return classLoader;
        }
        return ClassLoader.getSystemClassLoader();
    }

    private void loadResources(String string, ClassLoader classLoader, String string2) {
        String string3;
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string, Locale.getDefault(), classLoader);
        try {
            string3 = resourceBundle.getString(string2);
        }
        catch (MissingResourceException missingResourceException) {
            string3 = null;
        }
        Integer n = null;
        string2 = string2 + '.';
        for (String string4 : actionKeys) {
            String string5 = string2 + ResourceBundleAction.fixCase(string4);
            try {
                String string6 = resourceBundle.getString(string5);
                assert (string6 != null);
                if ("Name".equals(string4)) {
                    string3 = string6;
                    continue;
                }
                if ("SmallIcon".equals(string4)) {
                    string6 = string6.charAt(0) == '/' ? string6.substring(1) : "images/16x16/actions/" + string6;
                    URL uRL = classLoader.getResource(string6);
                    this.putValue("SmallIcon", new ImageIcon(uRL));
                    continue;
                }
                if ("AcceleratorKey".equals(string4)) {
                    this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(string6));
                    continue;
                }
                if ("MnemonicKey".equals(string4)) {
                    try {
                        n = Integer.decode(string6);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = new Integer(string6.charAt(0));
                    }
                    continue;
                }
                this.putValue(string4, string6);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (string3 != null) {
            String string4;
            MnemonicText mnemonicText = new MnemonicText(string3);
            string4 = mnemonicText.getText();
            this.putValue("Name", string4);
            if (n == null && mnemonicText.getMnemonicIndex() >= 0) {
                n = new Integer(mnemonicText.getMnemonic());
            }
            if (n != null) {
                this.putValue("MnemonicKey", n);
            }
        }
    }

    private static String fixCase(String string) {
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    @Override
    public Object getValue(String string) {
        Object object = super.getValue(string);
        if (object != null) {
            return object;
        }
        if (this.delegate != null) {
            return this.delegate.getValue(string);
        }
        return null;
    }

    private static class ActionKeyEnumeration
    implements Enumeration {
        private final Field[] fields = Action.class.getFields();
        private int i;
        private Object key;

        @Override
        public boolean hasMoreElements() {
            if (this.key != null) {
                return true;
            }
            try {
                while (this.i < this.fields.length) {
                    Object object;
                    Field field;
                    int n;
                    if (!Modifier.isPublic(n = (field = this.fields[this.i++]).getModifiers()) || !Modifier.isStatic(n) || !((object = field.get(null)) instanceof String)) continue;
                    this.key = object;
                    return true;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
            return false;
        }

        public Object nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            try {
                Object object = this.key;
                return object;
            }
            finally {
                this.key = null;
            }
        }
    }
}

