/*
 * Decompiled with CFR 0.152.
 */
package de.ready.callerdisplay;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.thoughtworks.xstream.XStream;
import de.ready.callerdisplay.DisplayPersonDialog;
import de.ready.callerdisplay.business.CallerDisplayData;
import de.ready.callerdisplay.business.DisplayPair;
import de.ready.callerdisplay.business.PositionalSquare;
import de.ready.callerdisplay.swingcc.CCLabel;
import de.ready.license.LicenseChecker;
import de.ready.splitchainer.business.Constants;
import de.ready.splitchainer.business.Dancer;
import de.ready.splitchainer.business.DancersSingleton;
import de.ready.splitchainer.business.DisplayPerson;
import de.ready.splitchainer.business.Gender;
import de.ready.splitchainer.business.ImageTools;
import de.ready.splitchainer.business.Pair;
import de.ready.splitchainer.business.Square;
import de.ready.splitchainer.business.events.RotationEvent;
import de.ready.splitchainer.license.SCLicenseParam;
import de.schlichtherle.license.ftp.LicenseManager;
import de.schlichtherle.license.wizard.LicenseWizard;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallerDisplay
extends JFrame
implements ActionListener {
    CallerDisplayData cdData;
    private ResourceBundle resources = ResourceBundle.getBundle(CallerDisplay.class.getName());
    private File actualFile;
    private JMenuItem networkMenuItem = null;
    private JMenuItem jMenuItemRotated = null;
    private final Logger logger = LoggerFactory.getLogger(CallerDisplay.class);
    private Timer checkReceiveTimer = new Timer(1000, this);
    private Selector selector;
    private Vector<JCheckBox> checkBoxes = new Vector();
    private RotationEvent rotationEvent;
    private Vector<SquareDisplay> squareDisplayList = new Vector();

    private File askForNewFile(File file, boolean bl) {
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        File file2 = new File(preferences.get("lastExportFilename", System.getProperty("user.home")));
        File file3 = file;
        if (file == null) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setSelectedFile(file2);
            jFileChooser.setFileSelectionMode(0);
            int n = bl ? jFileChooser.showSaveDialog(this) : jFileChooser.showOpenDialog(this);
            if (n == 0) {
                file3 = jFileChooser.getSelectedFile();
                preferences.put("lastExportFilename", file3.getAbsolutePath());
            }
        }
        return file3;
    }

    private void loadFile(File file) {
        try {
            this.cdData = CallerDisplayData.load(file);
            this.logger.debug("Loaded from {}", (Object)file.getAbsolutePath());
        }
        catch (IOException iOException) {
            this.logger.error("Exception: ", (Throwable)iOException);
            StringWriter stringWriter = new StringWriter();
            stringWriter.write("Unknown internal error: ");
            PrintWriter printWriter = new PrintWriter(stringWriter);
            iOException.printStackTrace(printWriter);
            JOptionPane.showMessageDialog(this, stringWriter.getBuffer().toString(), "Error", 0);
        }
    }

    private void doOpen() {
        File file = this.askForNewFile(null, false);
        if (file != null) {
            this.actualFile = file;
            this.loadFile(file);
            this.laterInit();
        }
    }

    private void doSave(File file) {
        File file2 = this.askForNewFile(file, true);
        if (file2 != null) {
            try {
                this.actualFile = file2;
                this.cdData.persist(file2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.logger.error("Exception", (Throwable)fileNotFoundException);
                StringWriter stringWriter = new StringWriter();
                stringWriter.write("Unkown internal error: ");
                PrintWriter printWriter = new PrintWriter(stringWriter);
                fileNotFoundException.printStackTrace(printWriter);
                JOptionPane.showMessageDialog(this, stringWriter.getBuffer().toString(), "Error", 0);
            }
            catch (IOException iOException) {
                this.logger.error("Exception", (Throwable)iOException);
                StringWriter stringWriter = new StringWriter();
                stringWriter.write("Unkown internal error: ");
                PrintWriter printWriter = new PrintWriter(stringWriter);
                iOException.printStackTrace(printWriter);
                JOptionPane.showMessageDialog(this, stringWriter.getBuffer().toString(), "Error", 0);
            }
            catch (Exception exception) {
                this.logger.error("Exception", (Throwable)exception);
                StringWriter stringWriter = new StringWriter();
                stringWriter.write("Unkown internal error: ");
                PrintWriter printWriter = new PrintWriter(stringWriter);
                exception.printStackTrace(printWriter);
                JOptionPane.showMessageDialog(this, stringWriter.getBuffer().toString(), "Error", 0);
            }
        }
    }

    private void doSave() {
        this.doSave(this.actualFile);
    }

    private void doSaveAs() {
        this.doSave(null);
    }

    private void doLicense() {
        LicenseManager licenseManager = new LicenseManager(new SCLicenseParam());
        LicenseWizard licenseWizard = new LicenseWizard(licenseManager);
        this.setAlwaysOnTop(false);
        licenseWizard.showModalDialog(this);
        this.setAlwaysOnTop(true);
    }

    private void doSetupNetwork() {
        final JRadioButton jRadioButton = new JRadioButton();
        JRadioButton jRadioButton2 = new JRadioButton();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        jRadioButton.setSelected(this.cdData.listen2Network);
        jRadioButton2.setSelected(this.cdData.listen2Network == false);
        CellConstraints cellConstraints = new CellConstraints();
        final JDialog jDialog = new JDialog(this, this.getResource("NetworkSetup.title"), true);
        jDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("pref, 4dlu, 20dlu:grow", "pref, 5dlu, pref, 5dlu, pref"));
        panelBuilder.add((Component)new JLabel(this.getResource("NetworkSetup.hint.text")), cellConstraints.xyw(1, 1, 3));
        panelBuilder.add((Component)new JLabel(this.getResource("NetworkSetup.network.on.text")), cellConstraints.xy(1, 3));
        panelBuilder.add((Component)jRadioButton, cellConstraints.xy(3, 3));
        panelBuilder.add((Component)new JLabel(this.getResource("NetworkSetup.network.off.text")), cellConstraints.xy(1, 5));
        panelBuilder.add((Component)jRadioButton2, cellConstraints.xy(3, 5));
        PanelBuilder panelBuilder2 = new PanelBuilder(new FormLayout("4dlu, 20dlu:grow, pref, 20dlu:grow, 4dlu", "4dlu, pref, 8dlu, pref, 4dlu"));
        panelBuilder2.add((Component)panelBuilder.getPanel(), cellConstraints.xyw(2, 2, 3));
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CallerDisplay.this.cdData.listen2Network = jRadioButton.isSelected();
                CallerDisplay.this.jMenuItemRotated.setEnabled(CallerDisplay.this.cdData.listen2Network == false);
                jDialog.setVisible(false);
            }
        });
        panelBuilder2.add((Component)jButton, cellConstraints.xyw(3, 4, 1));
        jDialog.setContentPane(panelBuilder2.getPanel());
        jDialog.pack();
        jDialog.setLocationRelativeTo(this);
        jDialog.setVisible(true);
        this.requestFocus();
    }

    private void doSetupSquare() {
        final JRadioButton jRadioButton = new JRadioButton();
        JRadioButton jRadioButton2 = new JRadioButton();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        jRadioButton.setSelected(this.cdData.callerViewBoolean);
        jRadioButton2.setSelected(this.cdData.callerViewBoolean == false);
        final JComboBox<String> jComboBox = new JComboBox<String>(this.cdData.squareModes);
        jComboBox.setSelectedIndex(this.cdData.squareMode);
        CellConstraints cellConstraints = new CellConstraints();
        final JDialog jDialog = new JDialog(this, this.getResource("SquareSetup.title"), true);
        jDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("pref, 4dlu, 20dlu:grow", "pref, 5dlu, pref, 5dlu, pref, 5dlu, pref"));
        panelBuilder.add((Component)new JLabel(this.getResource("SquareSetup.hint.text")), cellConstraints.xyw(1, 1, 3));
        panelBuilder.add((Component)new JLabel(this.getResource("SquareSetup.callerView.text")), cellConstraints.xy(1, 3));
        panelBuilder.add((Component)jRadioButton, cellConstraints.xy(3, 3));
        panelBuilder.add((Component)new JLabel(this.getResource("SquareSetup.classicView.text")), cellConstraints.xy(1, 5));
        panelBuilder.add((Component)jRadioButton2, cellConstraints.xy(3, 5));
        panelBuilder.add((Component)new JLabel(this.getResource("SquareSetup.squareMode.text")), cellConstraints.xy(1, 7));
        panelBuilder.add(jComboBox, cellConstraints.xy(3, 7));
        PanelBuilder panelBuilder2 = new PanelBuilder(new FormLayout("4dlu, 20dlu:grow, pref, 20dlu:grow, 4dlu", "4dlu, pref, 8dlu, pref, 4dlu"));
        panelBuilder2.add((Component)panelBuilder.getPanel(), cellConstraints.xyw(2, 2, 3));
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CallerDisplay.this.cdData.callerViewBoolean = jRadioButton.isSelected();
                CallerDisplay.this.cdData.squareMode = jComboBox.getSelectedIndex();
                jDialog.setVisible(false);
            }
        });
        panelBuilder2.add((Component)jButton, cellConstraints.xyw(3, 4, 1));
        jDialog.setContentPane(panelBuilder2.getPanel());
        jDialog.pack();
        jDialog.setLocationRelativeTo(this);
        jDialog.setVisible(true);
        this.requestFocus();
    }

    private void doSetupPersons() {
        CellConstraints cellConstraints = new CellConstraints();
        final JDialog jDialog = new JDialog(this, this.getResource("PersonsSetup.title"), true);
        jDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("pref, 4dlu, 20dlu:grow", "pref, 5dlu, pref, 5dlu, pref"));
        PanelBuilder panelBuilder2 = new PanelBuilder(new FormLayout("4dlu, 20dlu:grow, pref, 20dlu:grow, 4dlu", "4dlu, pref, 8dlu, pref, 4dlu"));
        panelBuilder2.add((Component)panelBuilder.getPanel(), cellConstraints.xyw(2, 2, 3));
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
                CallerDisplay.this.laterInit();
            }
        });
        panelBuilder2.add((Component)jButton, cellConstraints.xyw(3, 4, 1));
        jDialog.setContentPane(panelBuilder2.getPanel());
        jDialog.pack();
        jDialog.setLocationRelativeTo(this);
        jDialog.setVisible(true);
        this.requestFocus();
    }

    private void doSetupFloor() {
        CellConstraints cellConstraints = new CellConstraints();
        final JDialog jDialog = new JDialog(this, this.getResource("FloorSetup.title"), true);
        jDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("pref, 4dlu, 20dlu:grow", "pref, 5dlu, pref, 5dlu, pref"));
        final SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this.cdData.numberOfColumns, 1, 10, 1);
        final SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(this.cdData.numberOfRows, 1, 10, 1);
        panelBuilder.add((Component)new JLabel(this.getResource("FloorSetup.hint.text")), cellConstraints.xyw(1, 1, 3));
        panelBuilder.add((Component)new JLabel(this.getResource("FloorSetup.columns.text")), cellConstraints.xy(1, 3));
        panelBuilder.add((Component)new JSpinner(spinnerNumberModel), cellConstraints.xy(3, 3));
        panelBuilder.add((Component)new JLabel(this.getResource("FloorSetup.rows.text")), cellConstraints.xy(1, 5));
        panelBuilder.add((Component)new JSpinner(spinnerNumberModel2), cellConstraints.xy(3, 5));
        PanelBuilder panelBuilder2 = new PanelBuilder(new FormLayout("4dlu, 20dlu:grow, pref, 20dlu:grow, 4dlu", "4dlu, pref, 8dlu, pref, 4dlu"));
        panelBuilder2.add((Component)panelBuilder.getPanel(), cellConstraints.xyw(2, 2, 3));
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CallerDisplay.this.cdData.numberOfColumns = spinnerNumberModel.getNumber().intValue();
                CallerDisplay.this.cdData.numberOfRows = spinnerNumberModel2.getNumber().intValue();
                jDialog.setVisible(false);
                CallerDisplay.this.laterInit();
            }
        });
        panelBuilder2.add((Component)jButton, cellConstraints.xyw(3, 4, 1));
        jDialog.setContentPane(panelBuilder2.getPanel());
        jDialog.pack();
        jDialog.setLocationRelativeTo(this);
        jDialog.setVisible(true);
        this.requestFocus();
    }

    private void doRotated() {
        if (!this.cdData.listen2Network.booleanValue()) {
            for (JCheckBox jCheckBox : this.checkBoxes) {
                jCheckBox.setSelected(false);
                String string = jCheckBox.getActionCommand();
                int n = Integer.valueOf(string.substring(1)) - 1;
                SquareDisplay squareDisplay = this.squareDisplayList.get(n);
                squareDisplay.reset();
                squareDisplay.setVisible(false);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("timer".equalsIgnoreCase(string)) {
            this.checkReceive();
            return;
        }
        if ("rotated".equalsIgnoreCase(string)) {
            this.doRotated();
        }
        if ("exit".equalsIgnoreCase(string)) {
            System.exit(0);
        }
        if ("open".equals(actionEvent.getActionCommand())) {
            this.doOpen();
        }
        if ("save".equals(actionEvent.getActionCommand())) {
            this.doSave();
        }
        if ("saveAs".equals(actionEvent.getActionCommand())) {
            this.doSaveAs();
        }
        if ("license".equals(actionEvent.getActionCommand())) {
            this.doLicense();
        }
        if ("floor".equals(actionEvent.getActionCommand())) {
            this.doSetupFloor();
        }
        if ("persons".equals(actionEvent.getActionCommand())) {
            this.doSetupPersons();
        }
        if ("square".equals(actionEvent.getActionCommand())) {
            this.doSetupSquare();
        }
        if ("network".equals(actionEvent.getActionCommand())) {
            this.doSetupNetwork();
        }
        if ("new".equals(actionEvent.getActionCommand())) {
            this.cdData = new CallerDisplayData();
            this.laterInit();
        }
        if (string.startsWith("c")) {
            int n = Integer.valueOf(string.substring(1)) - 1;
            if (actionEvent.getSource() instanceof JCheckBox) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                SquareDisplay squareDisplay = this.squareDisplayList.get(n);
                squareDisplay.setVisible(jCheckBox.isSelected());
                squareDisplay.showSquare();
            }
        }
        this.logger.debug("command=" + string);
    }

    private Dancer findDancer(Vector<Dancer> vector, String string) {
        if (string.length() == 0) {
            return null;
        }
        Long l = Long.valueOf(string);
        for (Dancer dancer : vector) {
            if (dancer.getId() != l) continue;
            return dancer;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void handleVectorReceived(Object object) {
        if (object instanceof Vector) {
            int n;
            Vector vector = (Vector)object;
            DancersSingleton.getInstance().adjustDancerNames(vector);
            for (Dancer dancer : vector) {
                dancer.setPartner(this.findDancer(vector, dancer.getJoinedWith()));
            }
            for (Dancer dancer : vector) {
                this.logger.info("{}", (Object)(dancer.getDisplayName() + " -> " + dancer.getSquareNumberOrOUT() + " partner " + (dancer.getPartner() != null ? dancer.getPartner().getDisplayName() : "")));
            }
            HashSet hashSet = new HashSet();
            int n2 = 0;
            for (JCheckBox object22 : this.checkBoxes) {
                this.squareDisplayList.get(n2).setTheSquare(null);
            }
            int n3 = 0;
            Square square = new Square(n3 + 1, this.cdData.getSquareCouples());
            for (n = 0; n < this.checkBoxes.size(); ++n) {
                for (Dancer dancer : vector) {
                    void var6_10;
                    int n4;
                    if (hashSet.contains(dancer.getId()) || "OUT".equals(dancer.getSquareNumberOrOUT()) || (n4 = Integer.valueOf(dancer.getSquareNumberOrOUT()).intValue()) != n3 + 1 || dancer.getPartner() == null) continue;
                    var6_10.add(new Pair(dancer, dancer.getPartner()));
                    hashSet.add(dancer.getId());
                    hashSet.add(dancer.getPartner().getId());
                    if (!var6_10.isFull()) continue;
                    this.squareDisplayList.get(n3).setTheSquare((Square)var6_10);
                    Square square2 = new Square(++n3 + 1, this.cdData.getSquareCouples());
                }
            }
            n = 0;
            for (JCheckBox jCheckBox : this.checkBoxes) {
                jCheckBox.setEnabled(n++ < n3);
            }
        }
    }

    private void handleRotationEvent(Object object) {
        if (object instanceof RotationEvent) {
            this.rotationEvent = (RotationEvent)object;
        }
    }

    private void checkReceive() {
        if (!this.cdData.listen2Network.booleanValue()) {
            return;
        }
        if (this.selector == null) {
            return;
        }
        try {
            int n = this.selector.selectNow();
            Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
            while (iterator.hasNext()) {
                SelectionKey selectionKey = iterator.next();
                iterator.remove();
                if (!selectionKey.isReadable()) continue;
                ByteBuffer byteBuffer = (ByteBuffer)selectionKey.attachment();
                DatagramChannel datagramChannel = (DatagramChannel)selectionKey.channel();
                byteBuffer.clear();
                datagramChannel.receive(byteBuffer);
                XStream xStream = new XStream();
                xStream.processAnnotations(Dancer.class);
                Object object = xStream.fromXML(new String(byteBuffer.array()));
                if (object instanceof Vector) {
                    this.handleVectorReceived(object);
                    continue;
                }
                if (!(object instanceof RotationEvent)) continue;
                this.handleRotationEvent(object);
            }
        }
        catch (Exception exception) {
            this.logger.error("Exception", (Throwable)exception);
        }
    }

    public CallerDisplay() {
        this.cdData = new CallerDisplayData();
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            super.setDefaultCloseOperation(3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.error("Exception", (Throwable)classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            this.logger.error("Exception", (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.logger.error("Exception", (Throwable)illegalAccessException);
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            this.logger.error("Exception", (Throwable)unsupportedLookAndFeelException);
        }
    }

    public String getResource(String string) {
        return this.resources.getString(string);
    }

    private Integer getResourceInt(String string, Integer n) {
        try {
            return Integer.valueOf(this.resources.getString(string));
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    private String getResource(String string, Object object) {
        return MessageFormat.format(this.resources.getString(string), object);
    }

    private String getResource(String string, Object[] objectArray) {
        return MessageFormat.format(this.resources.getString(string), objectArray);
    }

    private int getEventFromChar(String string) {
        Class<KeyEvent> clazz = KeyEvent.class;
        try {
            Field field = clazz.getDeclaredField("VK_" + string);
            return field.getInt(null);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private KeyMapping translate(String string) {
        Matcher matcher;
        if (string.matches(".*(/.*/)") && (matcher = Pattern.compile(".*(/.*/)").matcher(string)).find()) {
            String string2 = matcher.group(1).replace("/", "");
            String string3 = string.replace(string2, "").replace("/", "");
            int n = string2.indexOf("_&");
            if (n == -1) {
                n = string2.indexOf("&");
                if (n == -1) {
                    n = string2.indexOf("_");
                    if (n == -1) {
                        return new KeyMapping(string);
                    }
                    String string4 = string2.substring(n + 1).toUpperCase();
                    int n2 = this.getEventFromChar(string4);
                    return new KeyMapping(string3, n2, 512);
                }
                String string5 = string2.substring(n + 1).toUpperCase();
                int n3 = this.getEventFromChar(string5);
                return new KeyMapping(string3, n3, 128);
            }
            String string6 = string2.substring(n + 2).toUpperCase();
            int n4 = this.getEventFromChar(string6);
            return new KeyMapping(string3, n4, 192);
        }
        int n = string.indexOf("_&");
        if (n == -1) {
            n = string.indexOf("&");
            if (n == -1) {
                n = string.indexOf("_");
                if (n == -1) {
                    return new KeyMapping(string);
                }
                String string7 = string.substring(n + 1, n + 2).toUpperCase();
                int n5 = this.getEventFromChar(string7);
                return new KeyMapping(string.replace("_", ""), n5, 512);
            }
            String string8 = string.substring(n + 1, n + 2).toUpperCase();
            int n6 = this.getEventFromChar(string8);
            return new KeyMapping(string.replace("&", ""), n6, 128);
        }
        String string9 = string.substring(n + 2, n + 3).toUpperCase();
        int n7 = this.getEventFromChar(string9);
        return new KeyMapping(string.replace("_&", ""), n7, 192);
    }

    private JMenu buildMenuFile() {
        KeyMapping keyMapping = this.translate(this.getResource("Menu.file.text"));
        JMenu jMenu = new JMenu(keyMapping.text);
        keyMapping = this.translate(this.getResource("Menu.file.open.text"));
        JMenuItem jMenuItem = new JMenuItem(keyMapping.text);
        jMenuItem.setActionCommand("open");
        jMenuItem.addActionListener(this);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(keyMapping.keyEvent, keyMapping.keyModifier, true));
        jMenu.add(jMenuItem);
        keyMapping = this.translate(this.getResource("Menu.file.new.text"));
        JMenuItem jMenuItem2 = new JMenuItem(keyMapping.text);
        jMenuItem2.setActionCommand("new");
        jMenuItem2.addActionListener(this);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(keyMapping.keyEvent, keyMapping.keyModifier, true));
        jMenu.add(jMenuItem2);
        keyMapping = this.translate(this.getResource("Menu.file.save.text"));
        JMenuItem jMenuItem3 = new JMenuItem(keyMapping.text);
        jMenuItem3.setActionCommand("save");
        jMenuItem3.addActionListener(this);
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(keyMapping.keyEvent, keyMapping.keyModifier, true));
        jMenu.add(jMenuItem3);
        keyMapping = this.translate(this.getResource("Menu.file.save_as.text"));
        JMenuItem jMenuItem4 = new JMenuItem(keyMapping.text);
        jMenuItem4.setActionCommand("saveAs");
        jMenuItem4.addActionListener(this);
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(keyMapping.keyEvent, keyMapping.keyModifier, true));
        jMenu.add(jMenuItem4);
        JSeparator jSeparator = new JSeparator();
        jMenu.add(jSeparator);
        keyMapping = this.translate(this.getResource("Menu.file.rotated.text"));
        this.jMenuItemRotated = new JMenuItem(keyMapping.text);
        this.jMenuItemRotated.setActionCommand("rotated");
        this.jMenuItemRotated.addActionListener(this);
        this.jMenuItemRotated.setAccelerator(KeyStroke.getKeyStroke(keyMapping.keyEvent, keyMapping.keyModifier, true));
        jMenu.add(this.jMenuItemRotated);
        JSeparator jSeparator2 = new JSeparator();
        jMenu.add(jSeparator2);
        keyMapping = this.translate(this.getResource("Menu.file.license.text"));
        JMenuItem jMenuItem5 = new JMenuItem(keyMapping.text);
        jMenuItem5.setActionCommand("license");
        jMenuItem5.addActionListener(this);
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(keyMapping.keyEvent, keyMapping.keyModifier, true));
        jMenu.add(jMenuItem5);
        JSeparator jSeparator3 = new JSeparator();
        jMenu.add(jSeparator3);
        keyMapping = this.translate(this.getResource("Menu.file.exit.text"));
        JMenuItem jMenuItem6 = new JMenuItem(keyMapping.text);
        jMenuItem6.setActionCommand("exit");
        jMenuItem6.addActionListener(this);
        jMenuItem6.setAccelerator(KeyStroke.getKeyStroke(keyMapping.keyEvent, keyMapping.keyModifier, true));
        jMenu.add(jMenuItem6);
        return jMenu;
    }

    private JMenu buildMenuSetup() {
        KeyMapping keyMapping = this.translate(this.getResource("Menu.setup.text"));
        JMenu jMenu = new JMenu(keyMapping.text);
        keyMapping = this.translate(this.getResource("Menu.setup.persons.text"));
        JMenuItem jMenuItem = new JMenuItem(keyMapping.text);
        jMenuItem.setActionCommand("persons");
        jMenuItem.addActionListener(this);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(keyMapping.keyEvent, keyMapping.keyModifier, true));
        jMenu.add(jMenuItem);
        keyMapping = this.translate(this.getResource("Menu.setup.floor.text"));
        JMenuItem jMenuItem2 = new JMenuItem(keyMapping.text);
        jMenuItem2.setActionCommand("floor");
        jMenuItem2.addActionListener(this);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(keyMapping.keyEvent, keyMapping.keyModifier, true));
        jMenu.add(jMenuItem2);
        keyMapping = this.translate(this.getResource("Menu.setup.square.text"));
        JMenuItem jMenuItem3 = new JMenuItem(keyMapping.text);
        jMenuItem3.setActionCommand("square");
        jMenuItem3.addActionListener(this);
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(keyMapping.keyEvent, keyMapping.keyModifier, true));
        jMenu.add(jMenuItem3);
        JSeparator jSeparator = new JSeparator();
        jMenu.add(jSeparator);
        keyMapping = this.translate(this.getResource("Menu.setup.network.text"));
        this.networkMenuItem = new JMenuItem(keyMapping.text);
        this.networkMenuItem.setActionCommand("network");
        this.networkMenuItem.addActionListener(this);
        this.networkMenuItem.setAccelerator(KeyStroke.getKeyStroke(keyMapping.keyEvent, keyMapping.keyModifier, true));
        jMenu.add(this.networkMenuItem);
        return jMenu;
    }

    private void netWorkInit() throws Exception {
        if (!this.cdData.listen2Network.booleanValue()) {
            return;
        }
        try {
            Object object;
            DatagramChannel datagramChannel = DatagramChannel.open();
            datagramChannel.socket().setBroadcast(true);
            try {
                object = InetAddress.getByName(Constants.UDP_BROADCAST_ADDRESS_1);
                datagramChannel.socket().bind(new InetSocketAddress((InetAddress)object, Constants.UPD_SERVER_PORT));
            }
            catch (Exception exception) {
                InetAddress inetAddress = InetAddress.getByName(Constants.UDP_BROADCAST_ADDRESS_0);
                datagramChannel.socket().bind(new InetSocketAddress(inetAddress, Constants.UPD_SERVER_PORT));
            }
            datagramChannel.configureBlocking(false);
            this.selector = Selector.open();
            object = datagramChannel.register(this.selector, 1);
            ((SelectionKey)object).attach(ByteBuffer.allocate(100000));
        }
        catch (Exception exception) {
            this.logger.error("No Network available");
            this.cdData.listen2Network = false;
            this.networkMenuItem.setEnabled(false);
        }
    }

    private void laterInit() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CallerDisplay.this.init();
            }
        });
        this.logger.debug("Later?");
    }

    private void init() {
        this.logger.debug("init...");
        this.setTitle("CallerDisplay ControlCenter");
        this.setSize(new Dimension(131 * this.cdData.numberOfColumns + 20, 60 + 25 * this.cdData.numberOfRows));
        this.setLocationRelativeTo(null);
        this.setLocale(Locale.ENGLISH);
        this.squareDisplayList.clear();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.gray);
        JMenuBar jMenuBar = new JMenuBar();
        jPanel.add((Component)jMenuBar, "North");
        jMenuBar.add(this.buildMenuFile());
        jMenuBar.add(this.buildMenuSetup());
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("fill:50dlu:grow", "fill:10dlu:grow"));
        String string = "10dlu,";
        String string2 = "";
        for (int i = 0; i < this.cdData.numberOfColumns; ++i) {
            string2 = string2 + string2 + string + " fill:50dlu:grow,";
            string = " 5dlu,";
        }
        string2 = string2 + " 10dlu";
        string = "5dlu,";
        String string3 = "";
        for (int i = 0; i < this.cdData.numberOfRows; ++i) {
            string3 = string3 + string3 + string + " fill:10dlu,";
            string = " 5dlu,";
        }
        string3 = string3 + " 5dlu";
        PanelBuilder panelBuilder2 = new PanelBuilder(new FormLayout(string2, string3));
        int n = 1;
        for (int i = 0; i < this.cdData.numberOfRows; ++i) {
            panelBuilder2.nextLine();
            for (int j = 0; j < this.cdData.numberOfColumns; ++j) {
                panelBuilder2.nextColumn();
                JCheckBox jCheckBox = new JCheckBox("Square" + n);
                jCheckBox.setActionCommand("c" + n);
                jCheckBox.addActionListener(this);
                this.checkBoxes.add(jCheckBox);
                panelBuilder2.add((Component)jCheckBox);
                panelBuilder2.nextColumn(1);
                this.squareDisplayList.add(new SquareDisplay(n, this.cdData));
                ++n;
            }
            panelBuilder2.nextLine();
        }
        panelBuilder.add((Component)panelBuilder2.getPanel());
        this.setAlwaysOnTop(true);
        jPanel.add((Component)panelBuilder.getPanel(), "Center");
        this.setContentPane(jPanel);
        this.checkReceiveTimer.setRepeats(true);
        this.checkReceiveTimer.setActionCommand("timer");
        this.checkReceiveTimer.start();
    }

    public void showMe() throws Exception {
        this.setVisible(true);
    }

    public static void main(String[] stringArray) throws Exception {
        LicenseChecker.checkLicense(new SCLicenseParam());
        CallerDisplay callerDisplay = new CallerDisplay();
        if (!LicenseChecker.licensedFunctions.isCallerDisplayLicensed().booleanValue()) {
            JOptionPane.showMessageDialog(callerDisplay, callerDisplay.getResource("CallerDisplay.licensePopup.advice.text"), callerDisplay.getResource("CallerDisplay.licensePopup.title"), 1);
            callerDisplay.doLicense();
            System.exit(1);
        }
        callerDisplay.netWorkInit();
        callerDisplay.init();
        callerDisplay.showMe();
    }

    private class KeyMapping {
        public String text;
        public int keyEvent;
        public int keyModifier;

        private KeyMapping(String string) {
            this.text = string;
        }

        private KeyMapping(String string, int n, int n2) {
            this.text = string;
            this.keyEvent = n;
            this.keyModifier = n2;
        }
    }

    private class SquareDisplay
    extends JFrame
    implements MouseActionListener,
    ComponentListener {
        private PositionalSquare theSquare;
        private PositionalSquare defaultSquare;
        int squareNumber;
        private CCLabel[] pairs;
        private DisplayPerson[] squarePersons = new DisplayPerson[8];
        private TranslatingSquare translatingSquare;
        private JLabel squareNumberLabel;
        private int windowHeight;

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            Dimension dimension = componentEvent.getComponent().getSize();
            this.windowHeight = dimension.height;
            Font font = new Font("Courier", 1, 20 + (dimension.height - 150) / 5);
            boolean bl = false;
            for (CCLabel cCLabel : this.pairs) {
                cCLabel.setFont(font);
                cCLabel.adaptIcon(20 + (dimension.height - 150) / 4);
            }
            font = new Font("Courier", 1, 35 + (dimension.height - 150) / 5);
            this.squareNumberLabel.setFont(font);
            this.repaint();
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }

        private JPanel buildSquarePanel() {
            CellConstraints cellConstraints = new CellConstraints();
            PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("fill:20dlu:grow, fill:30dlu:grow, fill:20dlu:grow, p, fill:20dlu:grow, fill:30dlu:grow, fill:20dlu:grow", "5dlu, pref, pref, pref, pref, pref, 10dlu"));
            this.pairs = new CCLabel[8];
            this.pairs[5] = new CCLabel("One/");
            this.pairs[5].setHorizontalAlignment(4);
            this.pairs[4] = new CCLabel("One+");
            panelBuilder.add((Component)this.pairs[5], cellConstraints.xywh(2, 2, 2, 1));
            panelBuilder.add((Component)new JLabel(" / "), cellConstraints.xy(4, 2));
            panelBuilder.add((Component)this.pairs[4], cellConstraints.xywh(5, 2, 2, 1));
            this.pairs[2] = new CCLabel("Two/");
            this.pairs[3] = new CCLabel("Two+");
            this.pairs[6] = new CCLabel("Fou/");
            this.pairs[6].setHorizontalAlignment(4);
            this.pairs[7] = new CCLabel("Fou+");
            this.pairs[7].setHorizontalAlignment(4);
            panelBuilder.add((Component)this.pairs[6], cellConstraints.xywh(1, 3, 2, 1));
            panelBuilder.add((Component)this.pairs[3], cellConstraints.xywh(6, 3, 2, 1));
            panelBuilder.add((Component)this.pairs[7], cellConstraints.xywh(1, 4, 2, 1));
            panelBuilder.add((Component)this.pairs[2], cellConstraints.xywh(6, 4, 2, 1));
            this.pairs[0] = new CCLabel("Thr/");
            this.pairs[0].setHorizontalAlignment(4);
            this.pairs[1] = new CCLabel("Thr+");
            panelBuilder.add((Component)this.pairs[0], cellConstraints.xywh(2, 5, 2, 1));
            panelBuilder.add((Component)new JLabel(" / "), cellConstraints.xy(4, 5));
            panelBuilder.add((Component)this.pairs[1], cellConstraints.xywh(5, 5, 2, 1));
            this.squareNumberLabel = new JLabel("-" + this.squareNumber + "-");
            this.squareNumberLabel.setHorizontalAlignment(0);
            this.squareNumberLabel.setVerticalAlignment(0);
            this.squareNumberLabel.setForeground(this.squareNumberLabel.getForeground().brighter().brighter().brighter());
            this.squareNumberLabel.addMouseListener(new ShowConfigureSquare(this, this.theSquare));
            panelBuilder.add((Component)this.squareNumberLabel, cellConstraints.xywh(3, 3, 3, 2));
            int n = 0;
            for (CCLabel cCLabel : this.pairs) {
                cCLabel.addMouseListener(new DelegatingMouseListener("p" + this.translatingSquare.mapping(n++), this));
                cCLabel.setOpaque(true);
            }
            return panelBuilder.getPanel();
        }

        public void reset() {
            int n = this.defaultSquare.getSquareCouples();
            this.defaultSquare = new PositionalSquare(this.squareNumber, n);
            for (int i = 0; i < n; ++i) {
                this.defaultSquare.add(new DisplayPair(new DisplayPerson(Long.valueOf(-(2 * i + 0) - CallerDisplay.this.cdData.getSquarePersons() * this.squareNumber), "" + (i + 1) + "-/", Gender.Beau).build(CallerDisplay.this.cdData.getFilename()), new DisplayPerson(Long.valueOf(-(2 * i + 1) - CallerDisplay.this.cdData.getSquarePersons() * this.squareNumber), "" + (i + 1) + "-+", Gender.Belle).build(CallerDisplay.this.cdData.getFilename())));
            }
            this.theSquare = this.defaultSquare;
            this.showSquare();
            this.showSquare();
        }

        public SquareDisplay(int n, CallerDisplayData callerDisplayData) {
            this.defaultSquare = new PositionalSquare(n, callerDisplayData.getSquareCouples());
            for (int i = 0; i < callerDisplayData.getSquareCouples(); ++i) {
                this.defaultSquare.add(new DisplayPair(new DisplayPerson(Long.valueOf(-(2 * i + 0) - CallerDisplay.this.cdData.getSquarePersons() * n), "" + (i + 1) + "-/", Gender.Beau).build(CallerDisplay.this.cdData.getFilename()), new DisplayPerson(Long.valueOf(-(2 * i + 1) - CallerDisplay.this.cdData.getSquarePersons() * n), "" + (i + 1) + "-+", Gender.Belle).build(CallerDisplay.this.cdData.getFilename())));
            }
            this.theSquare = this.defaultSquare;
            this.translatingSquare = new TranslatingSquare(callerDisplayData);
            this.squareNumber = n;
            this.setTitle("Square " + n);
            PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("5dlu, fill:10dlu:grow, 5dlu", "1dlu, fill:10dlu:grow, 5dlu"));
            panelBuilder.nextLine();
            panelBuilder.nextColumn();
            panelBuilder.add((Component)this.buildSquarePanel());
            this.setContentPane(panelBuilder.getPanel());
            this.setSize(new Dimension(600, 150));
            this.addComponentListener(this);
            this.setAlwaysOnTop(true);
        }

        private void showSquare() {
            if (this.translatingSquare != null) {
                int n;
                Integer n2 = this.squareNumber;
                if (n2 != null) {
                    this.setTitle("Square " + n2);
                }
                for (n = 0; n < CallerDisplay.this.cdData.getSquareCouples(); ++n) {
                    this.squarePersons[2 * n + 0] = this.theSquare.getPair(n).getPersonOne();
                    this.squarePersons[2 * n + 1] = this.theSquare.getPair(n).getPersonTwo();
                }
                for (n = 0; n < CallerDisplay.this.cdData.getSquarePersons(); ++n) {
                    if (this.squarePersons[this.translatingSquare.mapping(n)] == null) continue;
                    this.squarePersons[this.translatingSquare.mapping(n)].doDisplay(this.pairs[n]);
                }
            } else {
                this.setVisible(false);
                for (int i = 0; i < CallerDisplay.this.cdData.getSquarePersons(); ++i) {
                    this.pairs[i].setText("");
                }
            }
        }

        private Dancer getDancer(Pair pair, Gender gender) {
            Dancer dancer = pair.getDancerOne();
            if (dancer.getGender().equals(gender)) {
                return dancer;
            }
            return pair.getDancerTwo();
        }

        private Dancer getBeauDancer(Pair pair) {
            return this.getDancer(pair, Gender.Beau);
        }

        private Dancer getBelleDancer(Pair pair) {
            return this.getDancer(pair, Gender.Belle);
        }

        private void setTheSquare(Square square) {
            if (square != null) {
                this.theSquare = new PositionalSquare(square.getSquareNumber(), CallerDisplay.this.cdData.getSquareCouples());
                for (int i = 0; i < CallerDisplay.this.cdData.getSquareCouples(); ++i) {
                    Dancer dancer = this.getBeauDancer(square.getTheSquare().get(i));
                    Dancer dancer2 = this.getBelleDancer(square.getTheSquare().get(i));
                    square.add(new Pair(dancer, dancer2));
                    this.squarePersons[2 * i + 0] = new DisplayPerson(dancer.getId(), dancer.getFullName(), dancer.getGender()).build(CallerDisplay.this.cdData.getFilename());
                    this.squarePersons[2 * i + 1] = new DisplayPerson(dancer2.getId(), dancer2.getFullName(), dancer2.getGender()).build(CallerDisplay.this.cdData.getFilename());
                }
            } else {
                this.theSquare = this.defaultSquare;
                for (int i = 0; i < CallerDisplay.this.cdData.getSquareCouples(); ++i) {
                    this.squarePersons[2 * i + 0] = this.defaultSquare.getPair(i).getPersonOne();
                    this.squarePersons[2 * i + 1] = this.defaultSquare.getPair(i).getPersonTwo();
                }
            }
            this.showSquare();
        }

        @Override
        public void mouseClicked(String string, MouseEvent mouseEvent) {
            CallerDisplay.this.logger.info("Mouse clicked");
            int n = this.translatingSquare.mapping(Integer.valueOf(string.substring(1)));
            DisplayPersonDialog displayPersonDialog = new DisplayPersonDialog(CallerDisplay.this.resources, this.squarePersons[n], CallerDisplay.this.cdData);
            displayPersonDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            displayPersonDialog.setVisible(true);
            if (displayPersonDialog.isResultOK()) {
                this.squarePersons[n] = displayPersonDialog.getDisplayPerson();
                this.theSquare.set(n, displayPersonDialog.getDisplayPerson());
            }
            this.showSquare();
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            JLabel jLabel = (JLabel)mouseEvent.getSource();
            jLabel.setForeground(jLabel.getForeground().brighter().brighter().brighter());
            CallerDisplay.this.logger.info("Mouse entered");
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            JLabel jLabel = (JLabel)mouseEvent.getSource();
            jLabel.setForeground(jLabel.getForeground().darker().darker().darker());
            CallerDisplay.this.logger.info("Mouse exited");
        }
    }

    private class TranslatingSquare {
        private CallerDisplayData callerView;

        public int mapping(int n) {
            switch (n) {
                case 0: {
                    return this.callerView.callerViewBoolean != false ? 0 : 4;
                }
                case 1: {
                    return this.callerView.callerViewBoolean != false ? 1 : 5;
                }
                case 2: {
                    return this.callerView.callerViewBoolean != false ? 2 : 6;
                }
                case 3: {
                    return this.callerView.callerViewBoolean != false ? 3 : 7;
                }
                case 4: {
                    return this.callerView.callerViewBoolean != false ? 4 : 0;
                }
                case 5: {
                    return this.callerView.callerViewBoolean != false ? 5 : 1;
                }
                case 6: {
                    return this.callerView.callerViewBoolean != false ? 6 : 2;
                }
                case 7: {
                    return this.callerView.callerViewBoolean != false ? 7 : 3;
                }
            }
            return -1;
        }

        private TranslatingSquare(CallerDisplayData callerDisplayData) {
            this.callerView = callerDisplayData;
        }
    }

    private class DelegatingMouseListener
    implements MouseListener {
        private String actionCommand;
        private MouseActionListener mouseActionListener;

        private DelegatingMouseListener(String string, MouseActionListener mouseActionListener) {
            this.actionCommand = string;
            this.mouseActionListener = mouseActionListener;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.mouseActionListener.mouseClicked(this.actionCommand, mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.mouseActionListener.mouseEntered(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.mouseActionListener.mouseExited(mouseEvent);
        }
    }

    private class ShowConfigureSquare
    implements MouseListener {
        private SquareDisplay owner;
        private PositionalSquare theSquare;

        private ShowConfigureSquare(SquareDisplay squareDisplay, PositionalSquare positionalSquare) {
            this.owner = squareDisplay;
            this.theSquare = positionalSquare;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (CallerDisplay.this.cdData.listen2Network.booleanValue()) {
                ShowConfigureSquareDialog showConfigureSquareDialog = new ShowConfigureSquareDialog(this.owner, this.theSquare);
                showConfigureSquareDialog.init();
                showConfigureSquareDialog.setVisible(true);
                this.owner.showSquare();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }

    private class ShowConfigureSquareDialog
    extends JDialog {
        private SquareDisplay owner;
        PositionalSquare theSquare;
        PositionalSquare theSquareTemp;
        CCLabel[] persons;
        int[] transformer;

        private ShowConfigureSquareDialog(SquareDisplay squareDisplay, PositionalSquare positionalSquare) {
            super(squareDisplay, CallerDisplay.this.getResource("ConfigureSquare.title"), true);
            this.persons = new CCLabel[]{new CCLabel("1-1"), new CCLabel("1-2"), new CCLabel("2-1"), new CCLabel("2-2"), new CCLabel("3-1"), new CCLabel("3-2"), new CCLabel("4-1"), new CCLabel("4-2")};
            this.transformer = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
            this.owner = squareDisplay;
            this.theSquare = positionalSquare;
            this.theSquareTemp = new PositionalSquare(this.theSquare.getSquareNumber(), CallerDisplay.this.cdData.getSquareCouples());
            this.theSquareTemp.copy(this.theSquare);
        }

        private DisplayPerson transform(int n) {
            int n2 = this.transformer[n];
            int n3 = n2 / 2;
            int n4 = n2 % 2;
            DisplayPair displayPair = this.theSquareTemp.getPair(n3);
            return n4 == 0 ? displayPair.getPersonOne() : displayPair.getPersonTwo();
        }

        private void doPaint() {
            for (int i = 0; i < CallerDisplay.this.cdData.getSquarePersons(); ++i) {
                this.transform(i).doDisplay(this.persons[i]);
            }
        }

        public void init() {
            JButton jButton;
            JButton jButton2;
            int n;
            JPanel jPanel = new JPanel(new BorderLayout());
            CellConstraints cellConstraints = new CellConstraints();
            Font font = new Font("Courier", 1, 14);
            PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("4dlu, fill:100dlu:grow, 2dlu, fill:pref, 2dlu, fill:pref, 2dlu, fill:pref, 4dlu", "4dlu, pref, 1dlu, pref, 4dlu, pref, 1dlu, pref, 4dlu, pref, 1dlu, pref, 4dlu, pref, 1dlu, pref, 4dlu"));
            for (n = 0; n < CallerDisplay.this.cdData.getSquarePersons(); ++n) {
                this.persons[n].setFont(font);
                this.persons[n].setOpaque(true);
                panelBuilder.add((Component)this.persons[n], cellConstraints.xy(2, 2 * n + 2));
            }
            for (n = 0; n < CallerDisplay.this.cdData.getSquareCouples(); ++n) {
                jButton2 = null;
                jButton = null;
                JButton jButton3 = null;
                try {
                    jButton2 = new JButton(new ImageIcon(ImageTools.resize(ImageTools.getImage(CallerDisplay.class, "triangle-up-down.png"), 33)));
                    jButton2.setActionCommand("s" + n);
                    jButton2.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            String string = actionEvent.getActionCommand();
                            int n = Integer.parseInt(string.substring(1));
                            int n2 = ShowConfigureSquareDialog.this.transformer[2 * n + 0];
                            ShowConfigureSquareDialog.this.transformer[2 * n + 0] = ShowConfigureSquareDialog.this.transformer[2 * n + 1];
                            ShowConfigureSquareDialog.this.transformer[2 * n + 1] = n2;
                            ShowConfigureSquareDialog.this.doPaint();
                        }
                    });
                    jButton = new JButton(new ImageIcon(ImageTools.resize(ImageTools.getImage(CallerDisplay.class, "triangle-up.png"), 33)));
                    jButton.setActionCommand("u" + n);
                    jButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            String string = actionEvent.getActionCommand();
                            int n = Integer.parseInt(string.substring(1));
                            int n2 = n - 1;
                            if (n2 < 0) {
                                n2 += 4;
                            }
                            for (int i = 0; i < 2; ++i) {
                                int n3 = ShowConfigureSquareDialog.this.transformer[2 * n2 + i];
                                ShowConfigureSquareDialog.this.transformer[2 * n2 + i] = ShowConfigureSquareDialog.this.transformer[2 * n + i];
                                ShowConfigureSquareDialog.this.transformer[2 * n + i] = n3;
                            }
                            ShowConfigureSquareDialog.this.doPaint();
                        }
                    });
                    jButton3 = new JButton(new ImageIcon(ImageTools.resize(ImageTools.getImage(CallerDisplay.class, "triangle-down.png"), 33)));
                    jButton3.setActionCommand("d" + n);
                    jButton3.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            String string = actionEvent.getActionCommand();
                            int n = Integer.parseInt(string.substring(1));
                            int n2 = n + 1;
                            if (n2 > 3) {
                                n2 -= 4;
                            }
                            for (int i = 0; i < 2; ++i) {
                                int n3 = ShowConfigureSquareDialog.this.transformer[2 * n2 + i];
                                ShowConfigureSquareDialog.this.transformer[2 * n2 + i] = ShowConfigureSquareDialog.this.transformer[2 * n + i];
                                ShowConfigureSquareDialog.this.transformer[2 * n + i] = n3;
                            }
                            ShowConfigureSquareDialog.this.doPaint();
                        }
                    });
                }
                catch (Exception exception) {
                    CallerDisplay.this.logger.error("Error when reading images", (Throwable)exception);
                }
                panelBuilder.add((Component)jButton2, cellConstraints.xywh(4, 4 * n + 2, 1, 3));
                panelBuilder.add((Component)jButton, cellConstraints.xywh(6, 4 * n + 2, 1, 3));
                panelBuilder.add(jButton3, cellConstraints.xywh(8, 4 * n + 2, 1, 3));
            }
            jPanel.add((Component)panelBuilder.getPanel(), "Center");
            PanelBuilder panelBuilder2 = new PanelBuilder(new FormLayout("1dlu:grow, pref, 2dlu, pref, 1dlu:grow:", "pref, 4dlu"));
            jButton2 = new JButton(CallerDisplay.this.getResource("CallerDisplay.cancel.text"));
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ShowConfigureSquareDialog.this.setVisible(false);
                }
            });
            jButton = new JButton(CallerDisplay.this.getResource("CallerDisplay.ok.text"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ShowConfigureSquareDialog.this.setVisible(false);
                    for (int i = 0; i < CallerDisplay.this.cdData.getSquareCouples(); ++i) {
                        DisplayPerson displayPerson = ShowConfigureSquareDialog.this.transform(2 * i + 0);
                        DisplayPerson displayPerson2 = ShowConfigureSquareDialog.this.transform(2 * i + 1);
                        ShowConfigureSquareDialog.this.theSquare.set(i, new DisplayPair(displayPerson, displayPerson2));
                    }
                }
            });
            this.getRootPane().setDefaultButton(jButton);
            panelBuilder2.add((Component)jButton2, cellConstraints.xy(2, 1));
            panelBuilder2.add((Component)jButton, cellConstraints.xy(4, 1));
            jPanel.add((Component)panelBuilder2.getPanel(), "South");
            this.setContentPane(jPanel);
            this.pack();
            this.doPaint();
        }

        public void display() {
            this.setVisible(true);
        }
    }

    private static interface MouseActionListener {
        public void mouseClicked(String var1, MouseEvent var2);

        public void mouseEntered(MouseEvent var1);

        public void mouseExited(MouseEvent var1);
    }
}

