/*
 * Decompiled with CFR 0.152.
 */
package de.ready.callerdisplay.business;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

@XStreamAlias(value="de.ready.callerdisplay.CallerDisplayData")
public class CallerDisplayData {
    @XStreamAlias(value="numberOfColums")
    public Integer numberOfColumns = 2;
    @XStreamAlias(value="numberOfRows")
    public Integer numberOfRows = 3;
    @XStreamAlias(value="callerViewBoolean")
    public Boolean callerViewBoolean = Boolean.TRUE;
    @XStreamAlias(value="listen2Network")
    public Boolean listen2Network = Boolean.FALSE;
    @XStreamAlias(value="pathToData")
    public String pathToData = "data/personData/";
    @XStreamAlias(value="globalIdCounter")
    public Long globalIdCounter = 0L;
    @XStreamAlias(value="pathOfFile")
    private String pathOfFile;
    @XStreamAlias(value="squareMode")
    public int squareMode = 1;
    public String[] squareModes = new String[]{"Bigon", "Normal", "Hexagon"};

    public static CallerDisplayData load(File file) throws IOException {
        CallerDisplayData callerDisplayData = null;
        XStream xStream = new XStream();
        xStream.processAnnotations(CallerDisplayData.class);
        FileInputStream fileInputStream = new FileInputStream(file);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "ISO-8859-1");
        Object object = xStream.fromXML((Reader)inputStreamReader);
        inputStreamReader.close();
        if (object instanceof CallerDisplayData) {
            callerDisplayData = (CallerDisplayData)object;
        }
        return callerDisplayData;
    }

    public void persist(File file) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        this.pathOfFile = file.getAbsolutePath();
        this.persist();
    }

    public void persist() throws FileNotFoundException, UnsupportedEncodingException, IOException {
        if (this.pathOfFile != null) {
            FileOutputStream fileOutputStream = new FileOutputStream(this.pathOfFile);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "ISO-8859-1");
            XStream xStream = new XStream();
            xStream.processAnnotations(CallerDisplayData.class);
            String string = xStream.toXML((Object)this);
            outputStreamWriter.write(string);
            ((Writer)outputStreamWriter).close();
        }
    }

    public Long newGlobalIdCounter() throws IOException {
        String[] stringArray;
        File file = new File(this.pathToData);
        for (String string : stringArray = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.matches("\\d+\\.xml");
            }
        })) {
            long l = Long.valueOf(string.substring(0, string.indexOf(".xml")));
            if (l <= this.globalIdCounter) continue;
            this.globalIdCounter = l;
        }
        Long l = this.globalIdCounter;
        Long l2 = this.globalIdCounter = Long.valueOf(this.globalIdCounter + 1L);
        this.persist();
        return this.globalIdCounter;
    }

    public String getFilename() {
        if (this.pathOfFile == null || this.pathOfFile.length() == 0) {
            return "";
        }
        int n = this.pathOfFile.lastIndexOf("/");
        String string = this.pathOfFile.substring(n + 1);
        int n2 = string.lastIndexOf(".");
        if (n2 < 0) {
            n2 = string.length();
        }
        return string.substring(0, n2);
    }

    public int getSquareCouples() {
        return (this.squareMode + 1) * 2;
    }

    public int getSquarePersons() {
        return this.getSquareCouples() * 2;
    }
}

