/*
 * Decompiled with CFR 0.152.
 */
package de.ready.splitchainer.business;

import java.util.regex.Pattern;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class ComponentFactory {
    public static JTextField inputField() {
        return new JTextField();
    }

    public static JTextField numberInputField() {
        JTextField jTextField = new JTextField();
        ((AbstractDocument)jTextField.getDocument()).setDocumentFilter(new InternalFilter(-1, Pattern.compile("[0-9]")));
        return jTextField;
    }

    public static JTextField hexadecimalInputField() {
        JTextField jTextField = new JTextField();
        ((AbstractDocument)jTextField.getDocument()).setDocumentFilter(new InternalFilter(-1, Pattern.compile("[0-9A-F]")));
        return jTextField;
    }

    private static class InternalFilter
    extends DocumentFilter {
        private Pattern pattern;
        private int maxCharacters;

        public InternalFilter(int n, Pattern pattern) {
            this.pattern = pattern;
            this.maxCharacters = n;
        }

        public int getMaxCharacters() {
            return this.maxCharacters;
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            this.replace(filterBypass, n, 0, string, attributeSet);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            int n3;
            if (this.pattern != null && string != null && string.length() == 1 && !this.pattern.matcher(string).matches()) {
                throw new BadLocationException("Illegal characters", n);
            }
            StringBuffer stringBuffer = new StringBuffer("");
            int n4 = 0;
            if (this.pattern == null) {
                stringBuffer = new StringBuffer(string == null ? "" : string);
            } else {
                n4 = string == null ? 0 : string.length();
                for (n3 = 0; n3 < n4; ++n3) {
                    if (this.pattern == null || !this.pattern.matcher(string.substring(n3, n3 + 1)).matches()) continue;
                    stringBuffer.append(string.substring(n3, n3 + 1));
                }
            }
            n4 = stringBuffer.length();
            n3 = filterBypass.getDocument().getLength() - n2 + n4;
            if (this.getMaxCharacters() < 0 || n3 <= this.getMaxCharacters()) {
                filterBypass.replace(n, n2, stringBuffer.toString(), attributeSet);
            } else {
                int n5 = this.getMaxCharacters() - filterBypass.getDocument().getLength() + n2;
                if (n5 < 0) {
                    throw new BadLocationException("New characters exceed max size of document", n);
                }
                filterBypass.replace(n, n2, stringBuffer.substring(0, n5), attributeSet);
            }
        }
    }
}

