/*
 * Decompiled with CFR 0.152.
 */
package de.ready.splitchainer.business;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import de.ready.callerdisplay.swingcc.CCLabel;
import de.ready.splitchainer.business.DisplayTypeEnum;
import de.ready.splitchainer.business.Gender;
import de.ready.splitchainer.business.ImageTools;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="de.ready.splitchainer.business.DisplayPerson")
public class DisplayPerson {
    @XStreamAlias(value="displayType")
    private DisplayTypeEnum displayType;
    @XStreamAlias(value="personId")
    private Long personId;
    @XStreamAlias(value="personName")
    private String personName;
    @XStreamAlias(value="personDescription")
    private String personDescription;
    @XStreamAlias(value="gender")
    private Gender gender;
    @XStreamAlias(value="background")
    private Color background;
    @XStreamAlias(value="imageOne")
    private Image imageOne;
    @XStreamAlias(value="imageTwo")
    private Image imageTwo;
    @XStreamAlias(value="imageThr")
    private Image imageThr;
    @XStreamOmitField
    private static Logger logger = LoggerFactory.getLogger(DisplayPerson.class);
    @XStreamOmitField
    private static Color colorDefined = Color.decode("#aaaaee");
    @XStreamOmitField
    private static Color colorDefault = Color.decode("#aabbcc");

    public String getPersonName() {
        return this.personName;
    }

    public void setPersonName(String string) {
        this.personName = string;
    }

    public String getPersonDescription() {
        return this.personDescription;
    }

    public void setPersonDescription(String string) {
        this.personDescription = string;
    }

    public DisplayTypeEnum getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(DisplayTypeEnum displayTypeEnum) {
        this.displayType = displayTypeEnum;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public Image getImageOne() {
        return this.imageOne;
    }

    public void setImageOne(Image image) {
        this.imageOne = image;
    }

    public Image getImageTwo() {
        return this.imageTwo;
    }

    public void setImageTwo(Image image) {
        this.imageTwo = image;
    }

    public Image getImageThr() {
        return this.imageThr;
    }

    public void setImageThr(Image image) {
        this.imageThr = image;
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public Long getPersonId() {
        return this.personId;
    }

    public void setPersonId(Long l) {
        this.personId = l;
    }

    public DisplayPerson() {
        this.personId = -1L;
        this.displayType = DisplayTypeEnum.DISPLAY_NAME;
    }

    public DisplayPerson(DisplayTypeEnum displayTypeEnum, Long l, String string, String string2, Gender gender) {
        this.displayType = displayTypeEnum;
        this.personId = l;
        this.personName = string;
        this.personDescription = string2;
        this.gender = gender;
    }

    public DisplayPerson(Long l, String string, Gender gender) {
        this(DisplayTypeEnum.DISPLAY_NAME, l, string, null, gender);
    }

    private boolean isInternalPerson() {
        return this.personId < 0L;
    }

    private String buildPath(String string) {
        StringBuilder stringBuilder = new StringBuilder("data/");
        if (string != null && string.length() > 0) {
            stringBuilder.append(string + "/");
        } else {
            stringBuilder.append("personData/");
        }
        new File(stringBuilder.toString()).mkdirs();
        stringBuilder.append(this.personId).append(".xml");
        return stringBuilder.toString();
    }

    public void load(File file) {
        XStream xStream = new XStream();
        xStream.processAnnotations(DisplayPerson.class);
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "ISO-8859-1");
            Object object = xStream.fromXML((Reader)inputStreamReader);
            inputStreamReader.close();
            if (object instanceof DisplayPerson) {
                DisplayPerson displayPerson = (DisplayPerson)object;
                this.personId = displayPerson.personId;
                this.personName = displayPerson.personName;
                this.displayType = displayPerson.displayType;
                this.personDescription = displayPerson.personDescription;
                this.background = displayPerson.background;
                this.imageOne = displayPerson.imageOne;
                this.imageTwo = displayPerson.imageTwo;
                this.imageThr = displayPerson.imageThr;
            }
            logger.debug("Loaded from {}", (Object)file.getAbsolutePath());
        }
        catch (IOException iOException) {
            logger.error("Exception: ", (Throwable)iOException);
        }
    }

    public DisplayPerson build(String string) {
        String string2 = this.buildPath(string);
        File file = new File(string2);
        if (file.exists()) {
            this.load(file);
        }
        return this;
    }

    public DisplayPerson persist() {
        return this.persist("personData");
    }

    public DisplayPerson persist(String string) {
        if (this.isInternalPerson()) {
            return this;
        }
        String string2 = this.buildPath(string);
        File file = new File(string2);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "ISO-8859-1");
            XStream xStream = new XStream();
            xStream.processAnnotations(DisplayPerson.class);
            String string3 = xStream.toXML((Object)this);
            outputStreamWriter.write(string3);
            ((Writer)outputStreamWriter).close();
        }
        catch (IOException iOException) {
            logger.error("Exception when storing {}", (Object)file.getAbsolutePath(), (Object)iOException);
        }
        return this;
    }

    private void mapFont(JLabel jLabel) {
        if (this.personId < 0L) {
            Font font = jLabel.getFont();
            Map<TextAttribute, ?> map = font.getAttributes();
            map.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            jLabel.setFont(new Font(map));
        } else {
            Font font = jLabel.getFont();
            Map<TextAttribute, ?> map = font.getAttributes();
            map.remove(TextAttribute.STRIKETHROUGH);
            jLabel.setFont(new Font(map));
        }
    }

    public void doDisplay(CCLabel cCLabel) {
        cCLabel.setBackground(this.personId > 0L ? colorDefined : colorDefault);
        if (this.displayType.equals((Object)DisplayTypeEnum.DISPLAY_NAME) || this.displayType.equals((Object)DisplayTypeEnum.DISPLAY_NAME_SYMBOLS)) {
            cCLabel.setText(this.getPersonName());
            cCLabel.setIcon(null);
        }
        if (this.displayType.equals((Object)DisplayTypeEnum.DISPLAY_DESCRIPTION) || this.displayType.equals((Object)DisplayTypeEnum.DISPLAY_DESCRIPTION_SYMBOLS)) {
            cCLabel.setText(this.getPersonDescription());
            cCLabel.setIcon(null);
        }
        if (this.displayType.equals((Object)DisplayTypeEnum.DISPLAY_NAME_DESCRIPTION) || this.displayType.equals((Object)DisplayTypeEnum.DISPLAY_NAME_DESCRIPTION_SYMBOLS)) {
            cCLabel.setText(this.getPersonName() + " " + this.getPersonDescription());
            cCLabel.setIcon(null);
        }
        if (this.displayType.equals((Object)DisplayTypeEnum.DISPLAY_SYMBOLS)) {
            cCLabel.setBufferedImage(ImageTools.setBackground(ImageTools.resize((BufferedImage)this.imageOne, cCLabel.getSize().height - 2), this.background));
            cCLabel.setText("");
        }
        if (this.displayType.equals((Object)DisplayTypeEnum.DISPLAY_NAME_SYMBOLS) || this.displayType.equals((Object)DisplayTypeEnum.DISPLAY_DESCRIPTION_SYMBOLS)) {
            cCLabel.setBufferedImage(ImageTools.setBackground(ImageTools.resize((BufferedImage)this.imageOne, cCLabel.getSize().height - 2), this.background));
        }
        this.mapFont(cCLabel);
    }

    public void copy(DisplayPerson displayPerson) {
        this.displayType = displayPerson.displayType;
        this.personId = displayPerson.personId;
        this.personName = displayPerson.personName;
        this.personDescription = displayPerson.personDescription;
        this.background = displayPerson.background;
        this.gender = displayPerson.gender;
        this.imageOne = displayPerson.imageOne;
        this.imageTwo = displayPerson.imageTwo;
        this.imageThr = displayPerson.imageThr;
    }

    public String toString() {
        return (this.personName != null ? this.personName : "<noName>") + " " + (this.personDescription != null ? this.personDescription : "<NoDescription>");
    }
}

