/*
 * Decompiled with CFR 0.152.
 */
package de.ready.splitchainer.business;

import javax.swing.JComboBox;

public enum Level {
    BASIC(1),
    MAINSTREAM(2),
    PLUS(3),
    A1(4),
    A2(5),
    C1(6),
    C2(7),
    C3A(8),
    C3B(9),
    C4(10);

    private String[] levels = new String[]{"Basic", "Mainstream", "PLUS", "A1", "A2", "C1", "C2", "C3a", "C3b", "C4"};
    private int code;

    private Level(int n2) {
        this.code = n2;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.levels[this.code - 1];
    }

    public String toString() {
        return this.getName();
    }

    public boolean lessOrEqual(Level level) {
        return this.getCode() <= level.getCode();
    }

    public int getDistance(Level level) {
        return this.getCode();
    }

    public double preferFactor(Level level, boolean bl) {
        double d = 1.0;
        if (bl) {
            d = Math.pow(10.0, 2.0 * (double)Math.max(-1, level.getCode() - this.getCode()));
        }
        return d;
    }

    public Level increaseLevel(boolean bl) {
        if (bl) {
            switch (this.code) {
                case 1: {
                    return MAINSTREAM;
                }
                case 2: {
                    return PLUS;
                }
                case 3: {
                    return A1;
                }
                case 4: {
                    return A2;
                }
                case 5: {
                    return C1;
                }
                case 6: {
                    return C2;
                }
                case 7: {
                    return C3A;
                }
                case 8: {
                    return C3B;
                }
                case 9: {
                    return C4;
                }
                case 10: {
                    return BASIC;
                }
            }
        } else if (this.code == 1) {
            return MAINSTREAM;
        }
        return BASIC;
    }

    public Level decreaseLevel(boolean bl) {
        if (bl) {
            switch (this.code) {
                case 3: {
                    return MAINSTREAM;
                }
                case 4: {
                    return PLUS;
                }
                case 5: {
                    return A1;
                }
                case 6: {
                    return A2;
                }
                case 7: {
                    return C1;
                }
                case 8: {
                    return C2;
                }
                case 9: {
                    return C3A;
                }
                case 10: {
                    return C3B;
                }
                case 1: {
                    return C4;
                }
                case 2: {
                    return BASIC;
                }
            }
        } else if (this.code == 2) {
            return BASIC;
        }
        return MAINSTREAM;
    }

    public static Level[] allLevel() {
        return new Level[]{BASIC, MAINSTREAM, PLUS, A1, A2, C1, C2, C3A, C3B, C4};
    }

    public static void fill(JComboBox jComboBox) {
        Level.fill(jComboBox, true);
    }

    public static void fill(JComboBox jComboBox, boolean bl) {
        jComboBox.addItem(BASIC);
        jComboBox.addItem(MAINSTREAM);
        if (bl) {
            jComboBox.addItem(PLUS);
            jComboBox.addItem(A1);
            jComboBox.addItem(A2);
            jComboBox.addItem(C1);
            jComboBox.addItem(C2);
            jComboBox.addItem(C3A);
            jComboBox.addItem(C3B);
            jComboBox.addItem(C4);
        }
    }

    public static void fill(JComboBox jComboBox, boolean bl, Level level) {
        jComboBox.addItem(BASIC);
        jComboBox.addItem(MAINSTREAM);
        if (bl) {
            jComboBox.addItem(PLUS);
            jComboBox.addItem(A1);
            jComboBox.addItem(A2);
            jComboBox.addItem(C1);
            jComboBox.addItem(C2);
            jComboBox.addItem(C3A);
            jComboBox.addItem(C3B);
            jComboBox.addItem(C4);
        }
        jComboBox.setSelectedItem((Object)level);
    }
}

