/*
 * Decompiled with CFR 0.152.
 */
package de.ready.splitchainer.business;

import de.ready.splitchainer.business.Dancer;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pair {
    private Dancer dancerOne;
    private Dancer dancerTwo;
    private static Logger logger = LoggerFactory.getLogger(Pair.class);

    public Pair(Dancer dancer, Dancer dancer2) {
        if (!dancer.getGender().fits(dancer2.getGender())) {
            throw new IllegalArgumentException("Dancer " + dancer + " does not fit dancer " + dancer2);
        }
        this.setDancerOne(dancer);
        this.setDancerTwo(dancer2);
        dancer.setPartner(dancer2);
        dancer2.setPartner(dancer);
        if (logger.isTraceEnabled()) {
            logger.trace("ctor {} {}", (Object)dancer.getDisplayName(), (Object)dancer2.getDisplayName());
        }
    }

    public Dancer getDancerOne() {
        return this.dancerOne;
    }

    public void setDancerOne(Dancer dancer) {
        this.dancerOne = dancer;
    }

    public Dancer getDancerTwo() {
        return this.dancerTwo;
    }

    public void setDancerTwo(Dancer dancer) {
        this.dancerTwo = dancer;
    }

    public String toString() {
        return "Pair [dancerOne=" + this.dancerOne + ", dancerTwo=" + this.dancerTwo + "]";
    }

    public List<Dancer> getDancers() {
        Vector<Dancer> vector = new Vector<Dancer>();
        vector.add(this.dancerOne);
        vector.add(this.dancerTwo);
        return vector;
    }
}

