/*
 * Decompiled with CFR 0.152.
 */
package de.ready.splitchainer.gui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.FormLayout;
import de.ready.barcode.BarCode;
import de.ready.splitchainer.SplitChainer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BarcodeCreateDialog
extends JDialog {
    private JPanel contentPane;
    private JButton buttonOK = new JButton();
    private JButton buttonCancel = new JButton();
    private SpinnerNumberModel model4Spinder1 = new SpinnerNumberModel(0.0, 0.0, 100.0, 0.1);
    private SpinnerNumberModel model4Spinder2 = new SpinnerNumberModel(0.0, 0.0, 100.0, 0.1);
    private SpinnerNumberModel model4Spinder3 = new SpinnerNumberModel(0.0, 0.0, 100.0, 0.1);
    private SpinnerNumberModel model4Spinder4 = new SpinnerNumberModel(0.0, 0.0, 100.0, 0.1);
    private SpinnerNumberModel model4Spinder5 = new SpinnerNumberModel(0.0, 0.0, 100.0, 0.1);
    private SpinnerNumberModel model4Spinder6 = new SpinnerNumberModel(0.0, 0.0, 100.0, 0.1);
    private SpinnerNumberModel model4Spinder7 = new SpinnerNumberModel(0.0, 0.0, 100.0, 0.1);
    private JComboBox etikettAuswahl = new JComboBox();
    private JSpinner spinner1 = new JSpinner(this.model4Spinder1);
    private JSpinner spinner2 = new JSpinner(this.model4Spinder2);
    private JSpinner spinner3 = new JSpinner(this.model4Spinder3);
    private JSpinner spinner4 = new JSpinner(this.model4Spinder4);
    private JSpinner spinner5 = new JSpinner(this.model4Spinder5);
    private JSpinner spinner6 = new JSpinner(this.model4Spinder6);
    private JSpinner spinner7 = new JSpinner(this.model4Spinder7);
    private JTextField textField1 = new JTextField();
    private JTextField textField2 = new JTextField();
    private JTextField textField3 = new JTextField();
    private JTextField textField4 = new JTextField();
    private JTextField textField5 = new JTextField();
    private JLabel label1 = new JLabel();
    private JLabel label2 = new JLabel();
    private JLabel label3 = new JLabel();
    private JLabel label4 = new JLabel();
    private JLabel label5 = new JLabel();
    private JLabel label6 = new JLabel();
    private JLabel label7 = new JLabel();
    private JLabel label8 = new JLabel();
    private JLabel label9 = new JLabel();
    private JLabel label10 = new JLabel();
    private JLabel label11 = new JLabel();
    private JLabel label12 = new JLabel();
    private JLabel radio1Label = new JLabel();
    private JLabel radio2Label = new JLabel();
    private JRadioButton radio1 = new JRadioButton();
    private JRadioButton radio2 = new JRadioButton();
    private JFrame frame;
    private Logger logger = LoggerFactory.getLogger((String)"BarcodeCreateDialog");

    public BarcodeCreateDialog(JFrame jFrame) {
        this.frame = jFrame;
        this.initialize();
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.etikettAuswahl.addItem("HERMA 10001");
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BarcodeCreateDialog.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BarcodeCreateDialog.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                BarcodeCreateDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BarcodeCreateDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    private ByteMapper getByteMapper() {
        if (this.radio1.isSelected()) {
            return new Base48Mapper();
        }
        if (this.radio2.isSelected()) {
            return new AsIsMapper();
        }
        return new AsIsMapper();
    }

    private Integer convert2Integer(Object object) {
        if (Integer.class.isInstance(object)) {
            return (Integer)Integer.class.cast(object);
        }
        if (String.class.isInstance(object)) {
            return Integer.valueOf((String)String.class.cast(object));
        }
        if (Float.class.isInstance(object)) {
            return ((Float)object).intValue();
        }
        return null;
    }

    private Float convert2Float(Object object) {
        if (Float.class.isInstance(object)) {
            return (Float)Float.class.cast(object);
        }
        if (String.class.isInstance(object)) {
            return Float.valueOf((String)String.class.cast(object));
        }
        if (Double.class.isInstance(object)) {
            return Float.valueOf(((Double)object).floatValue());
        }
        return null;
    }

    private String getFormat() {
        if (this.radio1.isSelected()) {
            return "%04x";
        }
        if (this.radio2.isSelected()) {
            return "%04d";
        }
        return "%04x";
    }

    private void onOK() {
        BarCode barCode = new BarCode();
        try {
            Object object;
            Object object2;
            Preferences preferences = Preferences.userNodeForPackage(SplitChainer.class);
            preferences.putFloat("label.1.value", this.convert2Float(this.spinner1.getValue()).floatValue());
            float f = this.convert2Float(this.spinner1.getValue()).floatValue();
            preferences.putFloat("label.2.value", this.convert2Float(this.spinner2.getValue()).floatValue());
            float f2 = this.convert2Float(this.spinner2.getValue()).floatValue();
            preferences.putFloat("label.3.value", this.convert2Float(this.spinner3.getValue()).floatValue());
            float f3 = this.convert2Float(this.spinner3.getValue()).floatValue();
            preferences.putFloat("label.4.value", this.convert2Float(this.spinner4.getValue()).floatValue());
            float f4 = this.convert2Float(this.spinner4.getValue()).floatValue();
            preferences.putFloat("label.5.value", this.convert2Float(this.spinner5.getValue()).floatValue());
            float f5 = this.convert2Float(this.spinner5.getValue()).floatValue();
            preferences.putFloat("label.6.value", this.convert2Float(this.spinner6.getValue()).floatValue());
            float f6 = this.convert2Float(this.spinner6.getValue()).floatValue();
            preferences.putInt("label.7.value", this.convert2Integer(this.spinner7.getValue()));
            int n = this.convert2Integer(this.spinner7.getValue());
            preferences.put("label.8.value", this.textField1.getText());
            preferences.put("label.9.value", this.textField2.getText());
            preferences.put("label.10.value", this.textField3.getText());
            preferences.put("label.11.value", this.textField4.getText());
            preferences.put("label.12.value", this.textField5.getText());
            preferences.putBoolean("radio.1.value", this.radio1.isSelected());
            preferences.putBoolean("radio.2.value", this.radio2.isSelected());
            byte[] byArray = null;
            if (this.radio1.isSelected()) {
                object2 = this.textField2.getText() + this.textField3.getText() + this.textField4.getText();
                object = MessageDigest.getInstance("MD5");
                ((MessageDigest)object).reset();
                byArray = ((MessageDigest)object).digest(((String)object2).getBytes());
            }
            if (this.radio2.isSelected()) {
                byArray = this.textField5.getText().getBytes();
            }
            object2 = this.getByteMapper();
            object = this.getFormat();
            barCode.createA4(f, f2, f3, f4, f5, f6, n, this.textField1.getText(), ((ByteMapper)object2).convert(byArray), (String)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.dispose();
    }

    private void onCancel() {
        this.dispose();
    }

    public void initialize() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("de.ready.splitchainer.gui.BarcodeCreateDialog");
        this.label1.setText(resourceBundle.getString("label.1.text"));
        this.label2.setText(resourceBundle.getString("label.2.text"));
        this.label3.setText(resourceBundle.getString("label.3.text"));
        this.label4.setText(resourceBundle.getString("label.4.text"));
        this.label5.setText(resourceBundle.getString("label.5.text"));
        this.label6.setText(resourceBundle.getString("label.6.text"));
        this.label7.setText(resourceBundle.getString("label.7.text"));
        this.label8.setText(resourceBundle.getString("label.8.text"));
        this.label9.setText(resourceBundle.getString("label.9.text"));
        this.label10.setText(resourceBundle.getString("label.10.text"));
        this.label11.setText(resourceBundle.getString("label.11.text"));
        this.label12.setText(resourceBundle.getString("label.12.text"));
        this.radio1Label.setText(resourceBundle.getString("radio.1.text"));
        this.radio2Label.setText(resourceBundle.getString("radio.2.text"));
        this.buttonOK.setText(resourceBundle.getString("button.ok.text"));
        this.buttonCancel.setText(resourceBundle.getString("button.cancel.text"));
        this.setTitle(resourceBundle.getString("dialog.title"));
        Preferences preferences = Preferences.userNodeForPackage(SplitChainer.class);
        this.spinner1.setValue(Float.valueOf(preferences.getFloat("label.1.value", 42.0f)));
        this.spinner2.setValue(Float.valueOf(preferences.getFloat("label.2.value", 27.0f)));
        this.spinner3.setValue(Float.valueOf(preferences.getFloat("label.3.value", 66.0f)));
        this.spinner4.setValue(Float.valueOf(preferences.getFloat("label.4.value", 20.0f)));
        this.spinner5.setValue(Float.valueOf(preferences.getFloat("label.5.value", 14.0f)));
        this.spinner6.setValue(Float.valueOf(preferences.getFloat("label.6.value", 8.4f)));
        this.spinner7.setValue(Float.valueOf(preferences.getFloat("label.7.value", 4.0f)));
        this.textField1.setText(preferences.get("label.8.value", System.getProperty("user.home") + "/SplitChainer-Barcode.pdf"));
        this.textField2.setText(preferences.get("label.9.value", "Solingen"));
        this.textField3.setText(preferences.get("label.10.value", "NRW"));
        this.textField4.setText(preferences.get("label.11.value", "Triangle Squares"));
        this.textField5.setText(preferences.get("label.12.value", "0000XX"));
        ButtonGroup buttonGroup = new ButtonGroup();
        RadioButtonActionListener radioButtonActionListener = new RadioButtonActionListener(buttonGroup);
        this.radio1.addActionListener(radioButtonActionListener);
        this.radio2.addActionListener(radioButtonActionListener);
        buttonGroup.add(this.radio1);
        buttonGroup.add(this.radio2);
        this.radio1.setSelected(preferences.getBoolean("radio.1.value", false));
        this.radio2.setSelected(preferences.getBoolean("radio.2.value", true));
        this.radio1.setEnabled(false);
        for (ActionListener actionListener : this.radio2.getActionListeners()) {
            actionListener.actionPerformed(new ActionEvent(this.radio2, 0, "action"));
        }
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("fill:100dlu, 4dlu, fill:100dlu:grow", "fill:pref:grow, 4dlu, fill:pref:grow, 4dlu, fill:pref:grow, 4dlu, fill:pref:grow, 4dlu, fill:pref:grow, 4dlu, fill:pref:grow, 4dlu, fill:pref:grow, 4dlu, fill:pref:grow, 4dlu, fill:pref:grow, 4dlu, fill:pref:grow, 4dlu, fill:pref:grow, 4dlu, fill:pref:grow, 4dlu, fill:pref:grow, 4dlu, fill:pref:grow, 4dlu, fill:pref:grow"));
        panelBuilder.add((Component)new JLabel("Etikett"));
        panelBuilder.nextColumn();
        panelBuilder.nextColumn();
        panelBuilder.add((Component)this.etikettAuswahl);
        panelBuilder.nextLine();
        panelBuilder.nextLine();
        panelBuilder.add((Component)this.label1);
        panelBuilder.nextColumn();
        panelBuilder.nextColumn();
        panelBuilder.add((Component)this.spinner1);
        panelBuilder.nextLine();
        panelBuilder.nextLine();
        panelBuilder.add((Component)this.label2);
        panelBuilder.nextColumn();
        panelBuilder.nextColumn();
        panelBuilder.add((Component)this.spinner2);
        panelBuilder.nextLine();
        panelBuilder.nextLine();
        panelBuilder.add((Component)this.label3);
        panelBuilder.nextColumn();
        panelBuilder.nextColumn();
        panelBuilder.add((Component)this.spinner3);
        panelBuilder.nextLine();
        panelBuilder.nextLine();
        panelBuilder.add((Component)this.label4);
        panelBuilder.nextColumn();
        panelBuilder.nextColumn();
        panelBuilder.add((Component)this.spinner4);
        panelBuilder.nextLine();
        panelBuilder.nextLine();
        panelBuilder.add((Component)this.label5);
        panelBuilder.nextColumn();
        panelBuilder.nextColumn();
        panelBuilder.add((Component)this.spinner5);
        panelBuilder.nextLine();
        panelBuilder.nextLine();
        panelBuilder.add((Component)this.label6);
        panelBuilder.nextColumn();
        panelBuilder.nextColumn();
        panelBuilder.add((Component)this.spinner6);
        panelBuilder.nextLine();
        panelBuilder.nextLine();
        panelBuilder.add((Component)this.label7);
        panelBuilder.nextColumn();
        panelBuilder.nextColumn();
        panelBuilder.add((Component)this.spinner7);
        panelBuilder.nextLine();
        panelBuilder.nextLine();
        panelBuilder.add((Component)this.label8);
        panelBuilder.nextColumn();
        panelBuilder.nextColumn();
        panelBuilder.add((Component)this.textField1);
        panelBuilder.nextLine();
        panelBuilder.nextLine();
        panelBuilder.add((Component)this.radio1Label);
        panelBuilder.nextColumn();
        panelBuilder.nextColumn();
        panelBuilder.add((Component)this.radio1);
        panelBuilder.nextLine();
        panelBuilder.nextLine();
        panelBuilder.add((Component)this.label9);
        panelBuilder.nextColumn();
        panelBuilder.nextColumn();
        panelBuilder.add((Component)this.textField2);
        panelBuilder.nextLine();
        panelBuilder.nextLine();
        panelBuilder.add((Component)this.label10);
        panelBuilder.nextColumn();
        panelBuilder.nextColumn();
        panelBuilder.add((Component)this.textField3);
        panelBuilder.nextLine();
        panelBuilder.nextLine();
        panelBuilder.add((Component)this.label11);
        panelBuilder.nextColumn();
        panelBuilder.nextColumn();
        panelBuilder.add((Component)this.textField4);
        panelBuilder.nextLine();
        panelBuilder.nextLine();
        panelBuilder.add((Component)this.radio2Label);
        panelBuilder.nextColumn();
        panelBuilder.nextColumn();
        panelBuilder.add((Component)this.radio2);
        panelBuilder.nextLine();
        panelBuilder.nextLine();
        panelBuilder.add((Component)this.label12);
        panelBuilder.nextColumn();
        panelBuilder.nextColumn();
        panelBuilder.add((Component)this.textField5);
        panelBuilder.nextLine();
        panelBuilder.nextLine();
        PanelBuilder panelBuilder2 = new PanelBuilder(new FormLayout("fill:4dlu:grow, pref:grow, 4dlu:grow, pref:grow, 4dlu:grow", "10dlu, fill:pref"));
        panelBuilder2.nextLine();
        panelBuilder2.nextColumn();
        panelBuilder2.add((Component)this.buttonOK);
        panelBuilder2.nextColumn();
        panelBuilder2.nextColumn();
        panelBuilder2.add((Component)this.buttonCancel);
        PanelBuilder panelBuilder3 = new PanelBuilder(new FormLayout("10dlu,pref:grow,10dlu", "10dlu,pref, fill:pref:grow, pref,10dlu"));
        panelBuilder3.nextLine();
        panelBuilder3.nextColumn();
        panelBuilder3.add((Component)panelBuilder.getPanel());
        panelBuilder3.nextLine();
        panelBuilder3.nextColumn();
        panelBuilder3.add((Component)panelBuilder2.getPanel());
        this.contentPane = panelBuilder3.getPanel();
        this.setContentPane(this.contentPane);
    }

    public static void main(String[] stringArray) {
        BarcodeCreateDialog barcodeCreateDialog = new BarcodeCreateDialog(null);
        barcodeCreateDialog.pack();
        barcodeCreateDialog.setVisible(true);
        System.exit(0);
    }

    private class RadioButtonActionListener
    implements ActionListener {
        ButtonGroup buttonGroup;

        private RadioButtonActionListener(ButtonGroup buttonGroup) {
            this.buttonGroup = buttonGroup;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
            if (jRadioButton.equals(BarcodeCreateDialog.this.radio1) && BarcodeCreateDialog.this.radio1.isSelected()) {
                BarcodeCreateDialog.this.label9.setEnabled(true);
                BarcodeCreateDialog.this.label10.setEnabled(true);
                BarcodeCreateDialog.this.label11.setEnabled(true);
                BarcodeCreateDialog.this.label12.setEnabled(false);
                BarcodeCreateDialog.this.textField2.setEnabled(true);
                BarcodeCreateDialog.this.textField3.setEnabled(true);
                BarcodeCreateDialog.this.textField4.setEnabled(true);
                BarcodeCreateDialog.this.textField5.setEnabled(false);
            }
            if (jRadioButton.equals(BarcodeCreateDialog.this.radio2) && BarcodeCreateDialog.this.radio2.isSelected()) {
                BarcodeCreateDialog.this.label9.setEnabled(false);
                BarcodeCreateDialog.this.label10.setEnabled(false);
                BarcodeCreateDialog.this.label11.setEnabled(false);
                BarcodeCreateDialog.this.label12.setEnabled(true);
                BarcodeCreateDialog.this.textField2.setEnabled(false);
                BarcodeCreateDialog.this.textField3.setEnabled(false);
                BarcodeCreateDialog.this.textField4.setEnabled(false);
                BarcodeCreateDialog.this.textField5.setEnabled(true);
            }
        }
    }

    private class Base48Mapper
    extends ByteMapper {
        private Base48Mapper() {
        }

        @Override
        public String convert(byte[] byArray) {
            BigInteger bigInteger = new BigInteger(byArray);
            BigInteger bigInteger2 = new BigInteger("48");
            StringBuilder stringBuilder = new StringBuilder();
            while (bigInteger.compareTo(BigInteger.ZERO) > 0) {
                BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(bigInteger2);
                stringBuilder.append((char)(48 + bigIntegerArray[1].intValue()));
                bigInteger = bigIntegerArray[0];
            }
            return stringBuilder.toString().substring(0, 10);
        }
    }

    private class Bit5Mapper
    extends ByteMapper {
        private Bit5Mapper() {
        }

        @Override
        public String convert(byte[] byArray) {
            String string = this.toBinary(byArray);
            StringBuilder stringBuilder = new StringBuilder();
            while (string.length() > 5) {
                String string2 = string.substring(0, 5);
                string = string.substring(5);
                stringBuilder.append((char)(64 + Integer.parseInt(string2, 2)));
            }
            if (string.length() > 0) {
                stringBuilder.append((char)(64 + Integer.parseInt(string, 2)));
            }
            return stringBuilder.toString().substring(0, 10);
        }
    }

    private class HexMapper
    extends ByteMapper {
        private HexMapper() {
        }

        @Override
        public String convert(byte[] byArray) {
            StringBuilder stringBuilder = new StringBuilder();
            for (byte by : byArray) {
                stringBuilder.append(Integer.toString((by & 0xFF) + 256, 16).substring(1));
            }
            return stringBuilder.toString().substring(0, 10);
        }
    }

    private class IntegerMapper
    extends ByteMapper {
        private IntegerMapper() {
        }

        @Override
        public String convert(byte[] byArray) {
            String string = this.toBinary(byArray);
            Integer n = Integer.parseInt(string, 2);
            return n.toString();
        }
    }

    private class AsIsMapper
    extends ByteMapper {
        private AsIsMapper() {
        }

        @Override
        public String convert(byte[] byArray) {
            return new String(byArray);
        }
    }

    private abstract class ByteMapper {
        private ByteMapper() {
        }

        protected String toBinary(byte[] byArray) {
            StringBuilder stringBuilder = new StringBuilder();
            for (byte by : byArray) {
                stringBuilder.append(String.format("%8s", Integer.toBinaryString(by & 0xFF)).replace(' ', '0'));
            }
            return stringBuilder.toString();
        }

        public abstract String convert(byte[] var1);
    }
}

