/*
 * Decompiled with CFR 0.152.
 */
package de.ready.splitchainer.gui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.FormLayout;
import de.ready.splitchainer.business.Dancer;
import de.ready.splitchainer.business.DancersSingleton;
import de.ready.splitchainer.gui.DancerDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListDancersDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private Logger logger = LoggerFactory.getLogger(ListDancersDialog.class);
    private static final long serialVersionUID = 20120115180200L;
    private JFrame frame = null;
    private JTable table = null;
    private JButton okButton = new JButton();
    private JButton deleteButton = new JButton();
    private final String okCommand = "okCommand";
    private final String newDancerCommand = "newDancerCommand";
    private final String delDancerCommand = "delDancerCommand";
    private ResourceBundle resources = ResourceBundle.getBundle("de.ready.splitchainer.gui.ListDancersDialog");

    public ListDancersDialog(JFrame jFrame) {
        this.frame = jFrame;
        this.initialize();
    }

    private String getResource(String string) {
        return this.resources.getString(string);
    }

    private String getResource(String string, Object object) {
        return MessageFormat.format(this.resources.getString(string), object);
    }

    private void initialize() {
        Rectangle rectangle;
        this.okButton.setText(this.getResource("button.ok.text"));
        this.okButton.setActionCommand("okCommand");
        this.okButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.okButton);
        this.deleteButton.setText(this.getResource("button.delete.text"));
        this.deleteButton.setActionCommand("delDancerCommand");
        this.deleteButton.addActionListener(this);
        this.deleteButton.setEnabled(false);
        this.setTitle(this.getResource("dialog.title"));
        this.table = DancersSingleton.getInstance().createTable();
        this.table.getSelectionModel().addListSelectionListener(this);
        JButton jButton = new JButton(this.getResource("button.new.text"));
        jButton.addActionListener(this);
        jButton.setActionCommand("newDancerCommand");
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("10dlu, fill:100dlu:grow, 10dlu, fill:100dlu:grow, 10dlu", "fill:10dlu:grow, 10dlu"));
        panelBuilder.nextColumn();
        panelBuilder.add((Component)jButton);
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.deleteButton);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        Point point = this.frame.getLocationOnScreen();
        if (Math.abs(point.x) < 5) {
            point.x = 0;
        }
        if (Math.abs(point.y) < 5) {
            point.y = 0;
        }
        this.logger.trace("location (after adapting) {}", (Object)point);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        for (GraphicsDevice object2 : graphicsDeviceArray) {
            rectangle = object2.getDefaultConfiguration().getBounds();
            this.logger.trace("Screen {} is located at {}", (Object)object2.getIDstring(), (Object)rectangle);
            if (!rectangle.contains(point)) continue;
            dimension = new Dimension(rectangle.width, rectangle.height);
        }
        this.logger.trace("size to work with is {}", (Object)dimension);
        int n = Math.min((int)Math.floor(dimension.getHeight() / 3.0), 400);
        int n2 = Math.min((int)Math.floor(3.0 * dimension.getWidth() / 2.0), 1000);
        PanelBuilder panelBuilder2 = new PanelBuilder(new FormLayout("fill:" + n2 + "px:grow", "fill:" + n + "px:grow"));
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.table.setFillsViewportHeight(true);
        panelBuilder2.add((Component)jScrollPane);
        this.table.setSelectionMode(0);
        rectangle = new PanelBuilder(new FormLayout("4dlu:grow, fill:100dlu, 4dlu:grow", "10dlu, fill:pref"));
        rectangle.nextLine();
        rectangle.nextColumn();
        rectangle.add(this.okButton);
        PanelBuilder panelBuilder3 = new PanelBuilder(new FormLayout("10dlu,pref:grow,10dlu", "10dlu,pref, fill:pref:grow, pref,10dlu"));
        panelBuilder3.nextLine();
        panelBuilder3.nextColumn();
        panelBuilder3.add((Component)panelBuilder.getPanel());
        panelBuilder3.nextLine();
        panelBuilder3.nextColumn();
        panelBuilder3.add((Component)panelBuilder2.getPanel());
        panelBuilder3.nextLine();
        panelBuilder3.nextColumn();
        panelBuilder3.add((Component)rectangle.getPanel());
        this.setContentPane(panelBuilder3.getPanel());
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        panelBuilder3.getPanel().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListDancersDialog.this.onClose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    public void popup() {
        this.pack();
        this.setLocationRelativeTo(this.frame);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setVisible(true);
    }

    private void onClose() {
        DancersSingleton.getInstance().commit();
        DancersSingleton.getInstance().saveActual();
        DancersSingleton.getInstance().adjustDancerNames();
        this.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("okCommand".equals(actionEvent.getActionCommand())) {
            this.onClose();
        }
        if ("newDancerCommand".equals(actionEvent.getActionCommand())) {
            DancerDialog dancerDialog = new DancerDialog(this.frame);
            dancerDialog.setDancer(null);
            dancerDialog.popup();
        }
        if ("delDancerCommand".equals(actionEvent.getActionCommand())) {
            int n = this.table.convertRowIndexToModel(this.table.getSelectionModel().getMinSelectionIndex());
            Dancer dancer = DancersSingleton.getInstance().findDancer(n);
            Object[] objectArray = new Object[]{this.getResource("dialog.delete.ok"), this.getResource("dialog.delete.no")};
            int n2 = JOptionPane.showOptionDialog(this.frame, this.getResource("dialog.delete.message", dancer.getGivenName()), this.getResource("dialog.delete.title"), 0, 3, null, objectArray, objectArray[1]);
            if (n2 == 0) {
                DancersSingleton.getInstance().removeDancer(n);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)ListSelectionModel.class.cast(listSelectionEvent.getSource());
            boolean bl = listSelectionModel.getMinSelectionIndex() > -1;
            this.deleteButton.setEnabled(bl);
        }
    }
}

