/*
 * Decompiled with CFR 0.152.
 */
package de.ready.splitchainer.gui;

import de.ready.splitchainer.business.ImageTools;
import java.awt.image.BufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternFactory {
    private static Logger logger = LoggerFactory.getLogger(PatternFactory.class);

    public int getNumImages() {
        return 2;
    }

    public static BufferedImage getImage(Pattern pattern) {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageTools.getImage(PatternFactory.class, pattern.getFilename());
        }
        catch (Exception exception) {
            logger.error("Exception:", (Throwable)exception);
        }
        return bufferedImage;
    }

    public static enum Pattern {
        HORIZONTAL("horizontal.png"),
        VERTICAL("vertical.png"),
        AR_UP("triangle-up.png"),
        AR_DO("triangle-down.png"),
        AR_UD("triangle-up-down.png");

        private String filename;

        private Pattern(String string2) {
            this.filename = string2;
        }

        public String getFilename() {
            return this.filename;
        }
    }
}

