/*
 * Decompiled with CFR 0.152.
 */
package de.ready.splitchainer.gui;

import de.ready.splitchainer.business.Level;
import de.ready.splitchainer.business.PreferLevel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class RotateDialog
extends JDialog
implements ActionListener {
    JCheckBox checkBox = null;
    JComboBox levelBox = null;
    private boolean okPressed;
    private ResourceBundle resources = ResourceBundle.getBundle("de.ready.splitchainer.gui.RotateDialog");

    private String getResource(String string) {
        return this.resources.getString(string);
    }

    private String getResource(String string, Object object) {
        return MessageFormat.format(this.resources.getString(string), object);
    }

    public RotateDialog(Frame frame, Component component, PreferLevel preferLevel) {
        super(frame, "dialog.title", true);
        this.setTitle(this.getResource("dialog.title"));
        this.checkBox = new JCheckBox(this.getResource("dialog.prefer"));
        this.checkBox.setSelected(preferLevel.isPrefer());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.add(this.checkBox);
        if (preferLevel.getLevel() != null) {
            this.levelBox = new JComboBox();
            Level.fill(this.levelBox, preferLevel.isLicensed(), preferLevel.getLevel());
            jPanel.add(this.levelBox);
        }
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JButton jButton = new JButton(this.getResource("button.cancel.text"));
        jButton.setActionCommand("cancel");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton(this.getResource("button.ok.text"));
        jButton2.setActionCommand("ok");
        jButton2.addActionListener(this);
        this.getRootPane().setDefaultButton(jButton2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jButton);
        jPanel2.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel2.add(jButton2);
        Container container = this.getContentPane();
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel2, "Last");
        this.pack();
        this.setLocationRelativeTo(component);
    }

    public PreferLevel getResult() {
        this.setVisible(true);
        if (this.okPressed) {
            boolean bl = this.checkBox.isSelected();
            Level level = null;
            if (this.levelBox != null) {
                level = (Level)((Object)this.levelBox.getSelectedItem());
            }
            return new PreferLevel(bl, true, level);
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        this.okPressed = "ok".compareTo(string) == 0;
        this.setVisible(false);
    }
}

