/*
 * Decompiled with CFR 0.152.
 */
package de.ready.splitchainer.util;

import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;

public class X500PrincipalHelper {
    public static int LEASTSIGNIFICANT = 0;
    public static int MOSTSIGNIFICANT = 1;
    public static final String attrCN = "CN";
    public static final String attrOU = "OU";
    public static final String attrO = "O";
    public static final String attrC = "C";
    public static final String attrL = "L";
    public static final String attrST = "ST";
    public static final String attrSTREET = "STREET";
    public static final String attrEMAIL = "EMAILADDRESS";
    public static final String attrUID = "UID";
    ArrayList rdnNameArray = new ArrayList();
    private static final String attrTerminator = "=";

    public X500PrincipalHelper() {
    }

    public X500PrincipalHelper(X500Principal x500Principal) {
        this.parseDN(x500Principal.getName("RFC2253"));
    }

    public void setPrincipal(X500Principal x500Principal) {
        this.parseDN(x500Principal.getName("RFC2253"));
    }

    public String getCN() {
        return this.findPart(attrCN);
    }

    public String getOU() {
        return this.findPart(attrOU);
    }

    public String getO() {
        return this.findPart(attrO);
    }

    public String getC() {
        return this.findPart(attrC);
    }

    public String getL() {
        return this.findPart(attrL);
    }

    public String getST() {
        return this.findPart(attrST);
    }

    public String getSTREET() {
        return this.findPart(attrSTREET);
    }

    public String getEMAILDDRESS() {
        return this.findPart(attrEMAIL);
    }

    public String getUID() {
        return this.findPart(attrUID);
    }

    private void parseDN(String string) throws IllegalArgumentException {
        int n = 0;
        char c = '\u0000';
        ArrayList<String> arrayList = new ArrayList<String>();
        this.rdnNameArray.clear();
        while (n < string.length()) {
            int n2;
            for (n2 = n; n2 < string.length() && (c = string.charAt(n2)) != ',' && c != '+'; ++n2) {
                if (c != '\\') continue;
                ++n2;
            }
            if (n2 > string.length()) {
                throw new IllegalArgumentException("unterminated escape " + string);
            }
            arrayList.add(string.substring(n, n2));
            if (c != '+') {
                this.rdnNameArray.add(arrayList);
                arrayList = n2 != string.length() ? new ArrayList() : null;
            }
            n = n2 + 1;
        }
        if (arrayList != null) {
            throw new IllegalArgumentException("improperly terminated DN " + string);
        }
    }

    public ArrayList getAllValues(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = string + attrTerminator;
        for (ArrayList arrayList2 : this.rdnNameArray) {
            String string3 = (String)arrayList2.get(0);
            if (!string3.startsWith(string2)) continue;
            arrayList.add(string3.toString().substring(string2.length()));
        }
        return arrayList;
    }

    private String findPart(String string) {
        return this.findSignificantPart(string, MOSTSIGNIFICANT);
    }

    private String findSignificantPart(String string, int n) {
        String string2 = null;
        String string3 = string + attrTerminator;
        for (ArrayList arrayList : this.rdnNameArray) {
            String string4 = (String)arrayList.get(0);
            if (!string4.startsWith(string3)) continue;
            string2 = string4.toString().substring(string3.length());
            if (n != MOSTSIGNIFICANT) continue;
            break;
        }
        return string2;
    }
}

